/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen;

import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.can.adapter.CANDriverAdapter;
import org.apache.plc4x.java.can.adapter.Plc4xCANProtocolBase;
import org.apache.plc4x.java.canopen.configuration.CANOpenConfiguration;
import org.apache.plc4x.java.canopen.context.CANOpenDriverContext;
import org.apache.plc4x.java.canopen.field.CANOpenFieldHandler;
import org.apache.plc4x.java.canopen.protocol.CANOpenProtocolLogic;
import org.apache.plc4x.java.canopen.transport.CANOpenFrameDataHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.CustomProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleFieldOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.transport.can.CANTransport;

public class CANOpenPlcDriver
extends GeneratedDriverBase<Message> {
    public String getProtocolCode() {
        return "canopen";
    }

    public String getProtocolName() {
        return "CAN open";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return CANOpenConfiguration.class;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected String getDefaultTransport() {
        return "socketcan";
    }

    protected CANOpenFieldHandler getFieldHandler() {
        return new CANOpenFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler(){

            public PlcValue newPlcValue(PlcField field, Object[] values) {
                if (values[0] instanceof PlcList) {
                    return (PlcList)values[0];
                }
                return super.newPlcValue(field, values);
            }
        };
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleFieldOptimizer();
    }

    protected ProtocolStackConfigurer<Message> getStackConfigurer() {
        throw new PlcRuntimeException("CANopen driver requires access to transport layer.");
    }

    protected ProtocolStackConfigurer<Message> getStackConfigurer(Transport transport) {
        if (!(transport instanceof CANTransport)) {
            throw new PlcRuntimeException("CANopen driver requires a CAN transport instance");
        }
        CANTransport canTransport = (CANTransport)transport;
        return CustomProtocolStackConfigurer.builder((Class)canTransport.getMessageType(), arg_0 -> ((CANTransport)canTransport).getMessageInput(arg_0)).withProtocol(cfg -> {
            CANOpenProtocolLogic protocolLogic = new CANOpenProtocolLogic();
            ConfigurationFactory.configure((Configuration)cfg, (Object)((Object)protocolLogic));
            return new CANDriverAdapter((Plc4xCANProtocolBase)protocolLogic, canTransport.getMessageType(), canTransport.adapter(), (CANTransport.FrameHandler)new CANOpenFrameDataHandler(() -> ((CANTransport)canTransport).getTransportFrameBuilder()));
        }).withDriverContext(cfg -> new CANOpenDriverContext()).withPacketSizeEstimator(configuration1 -> canTransport.getEstimator()).littleEndian().build();
    }
}

