/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class SDOResponse implements Message {

  // Abstract accessors for discriminator values.
  public abstract SDOResponseCommand getCommand();

  public SDOResponse() {
    super();
  }

  protected abstract void serializeSDOResponseChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SDOResponse");

    // Switch field (Serialize the sub-type)
    serializeSDOResponseChild(writeBuffer);

    writeBuffer.popContext("SDOResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SDOResponse _value = this;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static SDOResponse staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    SDOResponseCommand command;
    if (args[0] instanceof SDOResponseCommand) {
      command = (SDOResponseCommand) args[0];
    } else if (args[0] instanceof String) {
      command = SDOResponseCommand.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type SDOResponseCommand or a string which is parseable but"
              + " was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, command);
  }

  public static SDOResponse staticParse(ReadBuffer readBuffer, SDOResponseCommand command)
      throws ParseException {
    readBuffer.pullContext("SDOResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    SDOResponseBuilder builder = null;
    if (EvaluationHelper.equals(command, SDOResponseCommand.SEGMENT_UPLOAD)) {
      builder = SDOSegmentUploadResponse.staticParseBuilder(readBuffer, command);
    } else if (EvaluationHelper.equals(command, SDOResponseCommand.SEGMENT_DOWNLOAD)) {
      builder = SDOSegmentDownloadResponse.staticParseBuilder(readBuffer, command);
    } else if (EvaluationHelper.equals(command, SDOResponseCommand.INITIATE_UPLOAD)) {
      builder = SDOInitiateUploadResponse.staticParseBuilder(readBuffer, command);
    } else if (EvaluationHelper.equals(command, SDOResponseCommand.INITIATE_DOWNLOAD)) {
      builder = SDOInitiateDownloadResponse.staticParseBuilder(readBuffer, command);
    } else if (EvaluationHelper.equals(command, SDOResponseCommand.ABORT)) {
      builder = SDOAbortResponse.staticParseBuilder(readBuffer, command);
    } else if (EvaluationHelper.equals(command, SDOResponseCommand.BLOCK)) {
      builder = SDOBlockResponse.staticParseBuilder(readBuffer, command);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type" + " parameters [" + "command=" + command + "]");
    }

    readBuffer.closeContext("SDOResponse");
    // Create the instance
    SDOResponse _sDOResponse = builder.build();
    return _sDOResponse;
  }

  public static interface SDOResponseBuilder {
    SDOResponse build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOResponse)) {
      return false;
    }
    SDOResponse that = (SDOResponse) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
