/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SDOInitiateSegmentedUploadResponse extends SDOInitiateUploadResponsePayload
    implements Message {

  // Accessors for discriminator values.
  public Boolean getExpedited() {
    return (boolean) false;
  }

  public Boolean getIndicated() {
    return (boolean) true;
  }

  // Properties.
  protected final long bytes;

  // Arguments.
  protected final Byte size;

  public SDOInitiateSegmentedUploadResponse(long bytes, Byte size) {
    super(size);
    this.bytes = bytes;
    this.size = size;
  }

  public long getBytes() {
    return bytes;
  }

  @Override
  protected void serializeSDOInitiateUploadResponsePayloadChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SDOInitiateSegmentedUploadResponse");

    // Simple Field (bytes)
    writeSimpleField("bytes", bytes, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("SDOInitiateSegmentedUploadResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SDOInitiateSegmentedUploadResponse _value = this;

    // Simple field (bytes)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static SDOInitiateSegmentedUploadResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean expedited, Boolean indicated, Byte size)
      throws ParseException {
    readBuffer.pullContext("SDOInitiateSegmentedUploadResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long bytes = readSimpleField("bytes", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("SDOInitiateSegmentedUploadResponse");
    // Create the instance
    return new SDOInitiateSegmentedUploadResponseBuilder(bytes, size);
  }

  public static class SDOInitiateSegmentedUploadResponseBuilder
      implements SDOInitiateUploadResponsePayload.SDOInitiateUploadResponsePayloadBuilder {
    private final long bytes;
    private final Byte size;

    public SDOInitiateSegmentedUploadResponseBuilder(long bytes, Byte size) {

      this.bytes = bytes;
      this.size = size;
    }

    public SDOInitiateSegmentedUploadResponse build(Byte size) {

      SDOInitiateSegmentedUploadResponse sDOInitiateSegmentedUploadResponse =
          new SDOInitiateSegmentedUploadResponse(bytes, size);
      return sDOInitiateSegmentedUploadResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOInitiateSegmentedUploadResponse)) {
      return false;
    }
    SDOInitiateSegmentedUploadResponse that = (SDOInitiateSegmentedUploadResponse) o;
    return (getBytes() == that.getBytes()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getBytes());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
