/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SDOAbortResponse extends SDOResponse implements Message {

  // Accessors for discriminator values.
  public SDOResponseCommand getCommand() {
    return SDOResponseCommand.ABORT;
  }

  // Properties.
  protected final SDOAbort abort;

  public SDOAbortResponse(SDOAbort abort) {
    super();
    this.abort = abort;
  }

  public SDOAbort getAbort() {
    return abort;
  }

  @Override
  protected void serializeSDOResponseChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SDOAbortResponse");

    // Simple Field (abort)
    writeSimpleField("abort", abort, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("SDOAbortResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SDOAbortResponse _value = this;

    // Simple field (abort)
    lengthInBits += abort.getLengthInBits();

    return lengthInBits;
  }

  public static SDOAbortResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, SDOResponseCommand command) throws ParseException {
    readBuffer.pullContext("SDOAbortResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    SDOAbort abort =
        readSimpleField(
            "abort",
            new DataReaderComplexDefault<>(() -> SDOAbort.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("SDOAbortResponse");
    // Create the instance
    return new SDOAbortResponseBuilder(abort);
  }

  public static class SDOAbortResponseBuilder implements SDOResponse.SDOResponseBuilder {
    private final SDOAbort abort;

    public SDOAbortResponseBuilder(SDOAbort abort) {

      this.abort = abort;
    }

    public SDOAbortResponse build() {
      SDOAbortResponse sDOAbortResponse = new SDOAbortResponse(abort);
      return sDOAbortResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOAbortResponse)) {
      return false;
    }
    SDOAbortResponse that = (SDOAbortResponse) o;
    return (getAbort() == that.getAbort()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAbort());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
