/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IndexAddress implements Message {

  // Properties.
  protected final int index;
  protected final short subindex;

  public IndexAddress(int index, short subindex) {
    super();
    this.index = index;
    this.subindex = subindex;
  }

  public int getIndex() {
    return index;
  }

  public short getSubindex() {
    return subindex;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("IndexAddress");

    // Simple Field (index)
    writeSimpleField("index", index, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (subindex)
    writeSimpleField("subindex", subindex, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("IndexAddress");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    IndexAddress _value = this;

    // Simple field (index)
    lengthInBits += 16;

    // Simple field (subindex)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static IndexAddress staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static IndexAddress staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("IndexAddress");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int index = readSimpleField("index", readUnsignedInt(readBuffer, 16));

    short subindex = readSimpleField("subindex", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("IndexAddress");
    // Create the instance
    IndexAddress _indexAddress;
    _indexAddress = new IndexAddress(index, subindex);
    return _indexAddress;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IndexAddress)) {
      return false;
    }
    IndexAddress that = (IndexAddress) o;
    return (getIndex() == that.getIndex()) && (getSubindex() == that.getSubindex()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getIndex(), getSubindex());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
