/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CANOpenNetworkPayload extends CANOpenPayload implements Message {

  // Accessors for discriminator values.
  public CANOpenService getService() {
    return CANOpenService.NMT;
  }

  // Properties.
  protected final NMTStateRequest request;
  protected final short node;
  // Reserved Fields
  private Byte reservedField0;

  public CANOpenNetworkPayload(NMTStateRequest request, short node) {
    super();
    this.request = request;
    this.node = node;
  }

  public NMTStateRequest getRequest() {
    return request;
  }

  public short getNode() {
    return node;
  }

  @Override
  protected void serializeCANOpenPayloadChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CANOpenNetworkPayload");

    // Simple Field (request)
    writeSimpleEnumField(
        "request",
        "NMTStateRequest",
        request,
        new DataWriterEnumDefault<>(
            NMTStateRequest::getValue, NMTStateRequest::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 1));

    // Simple Field (node)
    writeSimpleField("node", node, writeUnsignedShort(writeBuffer, 7));

    writeBuffer.popContext("CANOpenNetworkPayload");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CANOpenNetworkPayload _value = this;

    // Simple field (request)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (node)
    lengthInBits += 7;

    return lengthInBits;
  }

  public static CANOpenNetworkPayloadBuilder staticParseBuilder(
      ReadBuffer readBuffer, CANOpenService service) throws ParseException {
    readBuffer.pullContext("CANOpenNetworkPayload");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NMTStateRequest request =
        readEnumField(
            "request",
            "NMTStateRequest",
            new DataReaderEnumDefault<>(
                NMTStateRequest::enumForValue, readUnsignedShort(readBuffer, 8)));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

    short node = readSimpleField("node", readUnsignedShort(readBuffer, 7));

    readBuffer.closeContext("CANOpenNetworkPayload");
    // Create the instance
    return new CANOpenNetworkPayloadBuilder(request, node, reservedField0);
  }

  public static class CANOpenNetworkPayloadBuilder implements CANOpenPayload.CANOpenPayloadBuilder {
    private final NMTStateRequest request;
    private final short node;
    private final Byte reservedField0;

    public CANOpenNetworkPayloadBuilder(NMTStateRequest request, short node, Byte reservedField0) {
      this.request = request;
      this.node = node;
      this.reservedField0 = reservedField0;
    }

    public CANOpenNetworkPayload build() {
      CANOpenNetworkPayload cANOpenNetworkPayload = new CANOpenNetworkPayload(request, node);
      cANOpenNetworkPayload.reservedField0 = reservedField0;
      return cANOpenNetworkPayload;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CANOpenNetworkPayload)) {
      return false;
    }
    CANOpenNetworkPayload that = (CANOpenNetworkPayload) o;
    return (getRequest() == that.getRequest())
        && (getNode() == that.getNode())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRequest(), getNode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
