/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GenericCANDataType {
    BYTE(0L, "BYTE", 8),
    BOOLEAN(1L, "BIT", 1),
    UNSIGNED8(2L, "BYTE", 8),
    UNSIGNED16(3L, "WORD", 16),
    UNSIGNED24(4L, "RAW_BYTE_ARRAY", 24),
    UNSIGNED32(5L, "DWORD", 32),
    UNSIGNED40(6L, "RAW_BYTE_ARRAY", 40),
    UNSIGNED48(7L, "RAW_BYTE_ARRAY", 48),
    UNSIGNED56(8L, "RAW_BYTE_ARRAY", 56),
    UNSIGNED64(9L, "LWORD", 64),
    INTEGER8(10L, "SINT", 8),
    INTEGER16(11L, "INT", 16),
    INTEGER24(12L, "RAW_BYTE_ARRAY", 24),
    INTEGER32(13L, "DINT", 32),
    INTEGER40(14L, "RAW_BYTE_ARRAY", 40),
    INTEGER48(15L, "RAW_BYTE_ARRAY", 48),
    INTEGER56(16L, "RAW_BYTE_ARRAY", 56),
    INTEGER64(17L, "LINT", 64),
    REAL32(18L, "REAL", 32),
    REAL64(19L, "LREAL", 64),
    RAW(20L, "RAW_BYTE_ARRAY", 8);

    private static final Map<Long, GenericCANDataType> map;
    private final long value;
    private final String plcValueName;
    private final short numBits;

    static {
        map = new HashMap<Long, GenericCANDataType>();
        GenericCANDataType[] genericCANDataTypeArray = GenericCANDataType.values();
        int n = genericCANDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCANDataType value = genericCANDataTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private GenericCANDataType(long value, String plcValueName, short numBits) {
        this.value = value;
        this.plcValueName = plcValueName;
        this.numBits = numBits;
    }

    public long getValue() {
        return this.value;
    }

    public String getPlcValueName() {
        return this.plcValueName;
    }

    public static GenericCANDataType firstEnumForFieldPlcValueName(String fieldValue) {
        GenericCANDataType[] genericCANDataTypeArray = GenericCANDataType.values();
        int n = genericCANDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCANDataType _val = genericCANDataTypeArray[n2];
            if (_val.getPlcValueName().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<GenericCANDataType> enumsForFieldPlcValueName(String fieldValue) {
        ArrayList<GenericCANDataType> _values = new ArrayList<GenericCANDataType>();
        GenericCANDataType[] genericCANDataTypeArray = GenericCANDataType.values();
        int n = genericCANDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCANDataType _val = genericCANDataTypeArray[n2];
            if (_val.getPlcValueName().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public short getNumBits() {
        return this.numBits;
    }

    public static GenericCANDataType firstEnumForFieldNumBits(short fieldValue) {
        GenericCANDataType[] genericCANDataTypeArray = GenericCANDataType.values();
        int n = genericCANDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCANDataType _val = genericCANDataTypeArray[n2];
            if (_val.getNumBits() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<GenericCANDataType> enumsForFieldNumBits(short fieldValue) {
        ArrayList<GenericCANDataType> _values = new ArrayList<GenericCANDataType>();
        GenericCANDataType[] genericCANDataTypeArray = GenericCANDataType.values();
        int n = genericCANDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCANDataType _val = genericCANDataTypeArray[n2];
            if (_val.getNumBits() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static GenericCANDataType enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

