/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic;

import java.util.Optional;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.can.adapter.CANDriverAdapter;
import org.apache.plc4x.java.can.generic.configuration.GenericCANConfiguration;
import org.apache.plc4x.java.can.generic.context.GenericCANDriverContext;
import org.apache.plc4x.java.can.generic.protocol.GenericCANProtocolLogic;
import org.apache.plc4x.java.can.generic.tag.GenericCANTagHandler;
import org.apache.plc4x.java.can.generic.transport.GenericCANFrameDataHandler;
import org.apache.plc4x.java.can.generic.transport.GenericFrame;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.CustomProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.apache.plc4x.java.transport.can.CANTransport;

public class GenericCANDriver
extends GeneratedDriverBase<Message> {
    public String getProtocolCode() {
        return "genericcan";
    }

    public String getProtocolName() {
        return "Generic CAN";
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("socketcan");
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return GenericCANConfiguration.class;
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected GenericCANTagHandler getTagHandler() {
        return new GenericCANTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected BaseOptimizer getOptimizer() {
        return null;
    }

    protected ProtocolStackConfigurer<Message> getStackConfigurer() {
        throw new PlcRuntimeException("Generic CAN driver requires access to transport layer.");
    }

    protected ProtocolStackConfigurer<Message> getStackConfigurer(Transport transport) {
        if (!(transport instanceof CANTransport)) {
            throw new PlcRuntimeException("Generic CAN Driver requires CAN Transport instance");
        }
        CANTransport canTransport = (CANTransport)transport;
        return CustomProtocolStackConfigurer.builder((Class)canTransport.getMessageType(), arg_0 -> ((CANTransport)canTransport).getMessageInput(arg_0)).withProtocol(cfg -> {
            GenericCANProtocolLogic protocolLogic = new GenericCANProtocolLogic();
            ConfigurationFactory.configure((PlcConfiguration)cfg, (Object)((Object)protocolLogic));
            return new CANDriverAdapter<Message, GenericFrame>(protocolLogic, canTransport.getMessageType(), canTransport.adapter(), new GenericCANFrameDataHandler(() -> ((CANTransport)canTransport).getTransportFrameBuilder()));
        }).withDriverContext(cfg -> new GenericCANDriverContext()).withPacketSizeEstimator(cfg -> canTransport.getEstimator()).littleEndian().build();
    }
}

