/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum GenericCANDataType {
  BYTE((long) 0L, (short) 8),
  BOOLEAN((long) 1L, (short) 1),
  UNSIGNED8((long) 2L, (short) 8),
  UNSIGNED16((long) 3L, (short) 16),
  UNSIGNED24((long) 4L, (short) 24),
  UNSIGNED32((long) 5L, (short) 32),
  UNSIGNED40((long) 6L, (short) 40),
  UNSIGNED48((long) 7L, (short) 48),
  UNSIGNED56((long) 8L, (short) 56),
  UNSIGNED64((long) 9L, (short) 64),
  INTEGER8((long) 10L, (short) 8),
  INTEGER16((long) 11L, (short) 16),
  INTEGER24((long) 12L, (short) 24),
  INTEGER32((long) 13L, (short) 32),
  INTEGER40((long) 14L, (short) 40),
  INTEGER48((long) 15L, (short) 48),
  INTEGER56((long) 16L, (short) 56),
  INTEGER64((long) 17L, (short) 64),
  REAL32((long) 18L, (short) 32),
  REAL64((long) 19L, (short) 64);
  private static final Map<Long, GenericCANDataType> map;

  static {
    map = new HashMap<>();
    for (GenericCANDataType value : GenericCANDataType.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private long value;
  private short numBits;

  GenericCANDataType(long value, short numBits) {
    this.value = value;
    this.numBits = numBits;
  }

  public long getValue() {
    return value;
  }

  public short getNumBits() {
    return numBits;
  }

  public static GenericCANDataType firstEnumForFieldNumBits(short fieldValue) {
    for (GenericCANDataType _val : GenericCANDataType.values()) {
      if (_val.getNumBits() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<GenericCANDataType> enumsForFieldNumBits(short fieldValue) {
    List<GenericCANDataType> _values = new ArrayList();
    for (GenericCANDataType _val : GenericCANDataType.values()) {
      if (_val.getNumBits() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static GenericCANDataType enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
