/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsNotificationSample
implements Message {
    protected final long notificationHandle;
    protected final long sampleSize;
    protected final byte[] data;

    public AdsNotificationSample(long notificationHandle, long sampleSize, byte[] data) {
        this.notificationHandle = notificationHandle;
        this.sampleSize = sampleSize;
        this.data = data;
    }

    public long getNotificationHandle() {
        return this.notificationHandle;
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public byte[] getData() {
        return this.data;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsNotificationSample", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"notificationHandle", (Object)this.notificationHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sampleSize", (Object)this.sampleSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AdsNotificationSample", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        AdsNotificationSample _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AdsNotificationSample staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsNotificationSample", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long notificationHandle = (Long)FieldReaderFactory.readSimpleField((String)"notificationHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long sampleSize = (Long)FieldReaderFactory.readSimpleField((String)"sampleSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(sampleSize), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsNotificationSample", new WithReaderArgs[0]);
        AdsNotificationSample _adsNotificationSample = new AdsNotificationSample(notificationHandle, sampleSize, data);
        return _adsNotificationSample;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsNotificationSample)) {
            return false;
        }
        AdsNotificationSample that = (AdsNotificationSample)o;
        return this.getNotificationHandle() == that.getNotificationHandle() && this.getSampleSize() == that.getSampleSize() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getNotificationHandle(), this.getSampleSize(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

