/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Code generated by code-generation. DO NOT EDIT.

public class DataItem {

  private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

  public static PlcValue staticParse(
      ReadBuffer readBuffer, PlcValueType plcValueType, Integer stringLength)
      throws ParseException {
    if (EvaluationHelper.equals(plcValueType, PlcValueType.BOOL)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.BYTE)) { // BYTE

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcBYTE(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WORD)) { // WORD

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcWORD(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DWORD)) { // DWORD

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcDWORD(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LWORD)) { // LWORD

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcLWORD(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.SINT)) { // SINT

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readSignedByte("", 8);

      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.USINT)) { // USINT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.INT)) { // INT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UINT)) { // UINT

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DINT)) { // DINT

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UDINT)) { // UDINT

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LINT)) { // LINT

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readLong("", 64);

      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.ULINT)) { // ULINT

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.REAL)) { // REAL

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LREAL)) { // LREAL

      // Simple Field (value)
      Double value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readDouble("", 64);

      return new PlcLREAL(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.CHAR)) { // CHAR

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 8, "UTF-8");

      return new PlcCHAR(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WCHAR)) { // WCHAR

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 16, "UTF-16LE");

      return new PlcWCHAR(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.STRING)) { // STRING

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", (stringLength) * (8), "UTF-8");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WSTRING)) { // WSTRING

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", ((stringLength) * (8)) * (2), "UTF-16LE");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        int reserved = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);
        if (reserved != (int) 0x0000) {
          LOGGER.info(
              "Expected constant value "
                  + 0x0000
                  + " but got "
                  + reserved
                  + " for reserved field.");
        }
      }

      return new PlcWSTRING(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME)) { // TIME

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcTIME(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LTIME)) { // LTIME

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcLTIME(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE)) { // DATE

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcDATE(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME_OF_DAY)) { // TIME_OF_DAY

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcTIME_OF_DAY(value);
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE_AND_TIME)) { // DATE_AND_TIME

      // Simple Field (secondsSinceEpoch)
      Long secondsSinceEpoch = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedLong("", 32);

      LocalDateTime value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, 0, ZoneOffset.UTC);
      return new PlcDATE_AND_TIME(value);
    }
    return null;
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, PlcValueType plcValueType, Integer stringLength)
      throws SerializationException {
    staticSerialize(writeBuffer, _value, plcValueType, stringLength, ByteOrder.BIG_ENDIAN);
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer,
      PlcValue _value,
      PlcValueType plcValueType,
      Integer stringLength,
      ByteOrder byteOrder)
      throws SerializationException {
    if (EvaluationHelper.equals(plcValueType, PlcValueType.BOOL)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.BYTE)) { // BYTE
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WORD)) { // WORD
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DWORD)) { // DWORD
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LWORD)) { // LWORD
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.SINT)) { // SINT
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeSignedByte("", 8, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.USINT)) { // USINT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.INT)) { // INT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UINT)) { // UINT
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DINT)) { // DINT
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UDINT)) { // UDINT
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LINT)) { // LINT
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeLong("", 64, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.ULINT)) { // ULINT
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.REAL)) { // REAL
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LREAL)) { // LREAL
      // Simple Field (value)
      double value = (double) _value.getDouble();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeDouble("", 64, (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.CHAR)) { // CHAR
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 8, "UTF-8", (String) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WCHAR)) { // WCHAR
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 16, "UTF-16LE", (String) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.STRING)) { // STRING
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString(
          "", (stringLength) * (8), "UTF-8", (String) (value));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WSTRING)) { // WSTRING
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString(
          "", ((stringLength) * (8)) * (2), "UTF-16LE", (String) (value));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (int) 0x0000).intValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME)) { // TIME
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LTIME)) { // LTIME
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE)) { // DATE
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Simple Field (secondsSinceEpoch)
      long secondsSinceEpoch = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong(
          "", 32, ((Number) (secondsSinceEpoch)).longValue());
    }
  }

  public static int getLengthInBytes(
      PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
    return (int) Math.ceil((float) getLengthInBits(_value, plcValueType, stringLength) / 8.0);
  }

  public static int getLengthInBits(
      PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
    int sizeInBits = 0;
    if (EvaluationHelper.equals(plcValueType, PlcValueType.BOOL)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.BYTE)) { // BYTE
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WORD)) { // WORD
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DWORD)) { // DWORD
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LWORD)) { // LWORD
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.SINT)) { // SINT
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.USINT)) { // USINT
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.INT)) { // INT
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UINT)) { // UINT
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DINT)) { // DINT
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.UDINT)) { // UDINT
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LINT)) { // LINT
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.ULINT)) { // ULINT
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.REAL)) { // REAL
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LREAL)) { // LREAL
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.CHAR)) { // CHAR
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WCHAR)) { // WCHAR
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.STRING)) { // STRING
      // Simple Field (value)
      sizeInBits += -1;
      // Reserved Field
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.WSTRING)) { // WSTRING
      // Simple Field (value)
      sizeInBits += -1;
      // Reserved Field
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME)) { // TIME
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.LTIME)) { // LTIME
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE)) { // DATE
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(plcValueType, PlcValueType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Simple Field (secondsSinceEpoch)
      sizeInBits += 32;
    }
    return sizeInBits;
  }
}
