/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsSymbolTableEntry implements Message {

  // Constant values.
  public static final Short NAMETERMINATOR = 0x00;
  public static final Short DATATYPENAMETERMINATOR = 0x00;
  public static final Short COMMENTTERMINATOR = 0x00;

  // Properties.
  protected final long entryLength;
  protected final long group;
  protected final long offset;
  protected final long size;
  protected final long dataType;
  protected final boolean flagMethodDeref;
  protected final boolean flagItfMethodAccess;
  protected final boolean flagReadOnly;
  protected final boolean flagTComInterfacePointer;
  protected final boolean flagTypeGuid;
  protected final boolean flagReferenceTo;
  protected final boolean flagBitValue;
  protected final boolean flagPersistent;
  protected final boolean flagExtendedFlags;
  protected final boolean flagInitOnReset;
  protected final boolean flagStatic;
  protected final boolean flagAttributes;
  protected final boolean flagContextMask;
  protected final String name;
  protected final String dataTypeName;
  protected final String comment;
  protected final byte[] rest;
  // Reserved Fields
  private Byte reservedField0;
  private Integer reservedField1;

  public AdsSymbolTableEntry(
      long entryLength,
      long group,
      long offset,
      long size,
      long dataType,
      boolean flagMethodDeref,
      boolean flagItfMethodAccess,
      boolean flagReadOnly,
      boolean flagTComInterfacePointer,
      boolean flagTypeGuid,
      boolean flagReferenceTo,
      boolean flagBitValue,
      boolean flagPersistent,
      boolean flagExtendedFlags,
      boolean flagInitOnReset,
      boolean flagStatic,
      boolean flagAttributes,
      boolean flagContextMask,
      String name,
      String dataTypeName,
      String comment,
      byte[] rest) {
    super();
    this.entryLength = entryLength;
    this.group = group;
    this.offset = offset;
    this.size = size;
    this.dataType = dataType;
    this.flagMethodDeref = flagMethodDeref;
    this.flagItfMethodAccess = flagItfMethodAccess;
    this.flagReadOnly = flagReadOnly;
    this.flagTComInterfacePointer = flagTComInterfacePointer;
    this.flagTypeGuid = flagTypeGuid;
    this.flagReferenceTo = flagReferenceTo;
    this.flagBitValue = flagBitValue;
    this.flagPersistent = flagPersistent;
    this.flagExtendedFlags = flagExtendedFlags;
    this.flagInitOnReset = flagInitOnReset;
    this.flagStatic = flagStatic;
    this.flagAttributes = flagAttributes;
    this.flagContextMask = flagContextMask;
    this.name = name;
    this.dataTypeName = dataTypeName;
    this.comment = comment;
    this.rest = rest;
  }

  public long getEntryLength() {
    return entryLength;
  }

  public long getGroup() {
    return group;
  }

  public long getOffset() {
    return offset;
  }

  public long getSize() {
    return size;
  }

  public long getDataType() {
    return dataType;
  }

  public boolean getFlagMethodDeref() {
    return flagMethodDeref;
  }

  public boolean getFlagItfMethodAccess() {
    return flagItfMethodAccess;
  }

  public boolean getFlagReadOnly() {
    return flagReadOnly;
  }

  public boolean getFlagTComInterfacePointer() {
    return flagTComInterfacePointer;
  }

  public boolean getFlagTypeGuid() {
    return flagTypeGuid;
  }

  public boolean getFlagReferenceTo() {
    return flagReferenceTo;
  }

  public boolean getFlagBitValue() {
    return flagBitValue;
  }

  public boolean getFlagPersistent() {
    return flagPersistent;
  }

  public boolean getFlagExtendedFlags() {
    return flagExtendedFlags;
  }

  public boolean getFlagInitOnReset() {
    return flagInitOnReset;
  }

  public boolean getFlagStatic() {
    return flagStatic;
  }

  public boolean getFlagAttributes() {
    return flagAttributes;
  }

  public boolean getFlagContextMask() {
    return flagContextMask;
  }

  public String getName() {
    return name;
  }

  public String getDataTypeName() {
    return dataTypeName;
  }

  public String getComment() {
    return comment;
  }

  public byte[] getRest() {
    return rest;
  }

  public short getNameTerminator() {
    return NAMETERMINATOR;
  }

  public short getDataTypeNameTerminator() {
    return DATATYPENAMETERMINATOR;
  }

  public short getCommentTerminator() {
    return COMMENTTERMINATOR;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsSymbolTableEntry");

    // Simple Field (entryLength)
    writeSimpleField(
        "entryLength",
        entryLength,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (group)
    writeSimpleField(
        "group",
        group,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (offset)
    writeSimpleField(
        "offset",
        offset,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (size)
    writeSimpleField(
        "size",
        size,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (dataType)
    writeSimpleField(
        "dataType",
        dataType,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagMethodDeref)
    writeSimpleField(
        "flagMethodDeref",
        flagMethodDeref,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagItfMethodAccess)
    writeSimpleField(
        "flagItfMethodAccess",
        flagItfMethodAccess,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagReadOnly)
    writeSimpleField(
        "flagReadOnly",
        flagReadOnly,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagTComInterfacePointer)
    writeSimpleField(
        "flagTComInterfacePointer",
        flagTComInterfacePointer,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagTypeGuid)
    writeSimpleField(
        "flagTypeGuid",
        flagTypeGuid,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagReferenceTo)
    writeSimpleField(
        "flagReferenceTo",
        flagReferenceTo,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagBitValue)
    writeSimpleField(
        "flagBitValue",
        flagBitValue,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagPersistent)
    writeSimpleField(
        "flagPersistent",
        flagPersistent,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 3));

    // Simple Field (flagExtendedFlags)
    writeSimpleField(
        "flagExtendedFlags",
        flagExtendedFlags,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagInitOnReset)
    writeSimpleField(
        "flagInitOnReset",
        flagInitOnReset,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagStatic)
    writeSimpleField(
        "flagStatic",
        flagStatic,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagAttributes)
    writeSimpleField(
        "flagAttributes",
        flagAttributes,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (flagContextMask)
    writeSimpleField(
        "flagContextMask",
        flagContextMask,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (int) 0x0000,
        writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (nameLength) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int nameLength = (int) (STR_LEN(getName()));
    writeImplicitField("nameLength", nameLength, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (dataTypeNameLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int dataTypeNameLength = (int) (STR_LEN(getDataTypeName()));
    writeImplicitField("dataTypeNameLength", dataTypeNameLength, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (commentLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int commentLength = (int) (STR_LEN(getComment()));
    writeImplicitField("commentLength", commentLength, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (name)
    writeSimpleField(
        "name",
        name,
        writeString(writeBuffer, (nameLength) * (8)),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Const Field (nameTerminator)
    writeConstField("nameTerminator", NAMETERMINATOR, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (dataTypeName)
    writeSimpleField(
        "dataTypeName",
        dataTypeName,
        writeString(writeBuffer, (dataTypeNameLength) * (8)),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Const Field (dataTypeNameTerminator)
    writeConstField(
        "dataTypeNameTerminator", DATATYPENAMETERMINATOR, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (comment)
    writeSimpleField(
        "comment",
        comment,
        writeString(writeBuffer, (commentLength) * (8)),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Const Field (commentTerminator)
    writeConstField("commentTerminator", COMMENTTERMINATOR, writeUnsignedShort(writeBuffer, 8));

    // Array Field (rest)
    writeByteArrayField("rest", rest, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("AdsSymbolTableEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AdsSymbolTableEntry _value = this;

    // Simple field (entryLength)
    lengthInBits += 32;

    // Simple field (group)
    lengthInBits += 32;

    // Simple field (offset)
    lengthInBits += 32;

    // Simple field (size)
    lengthInBits += 32;

    // Simple field (dataType)
    lengthInBits += 32;

    // Simple field (flagMethodDeref)
    lengthInBits += 1;

    // Simple field (flagItfMethodAccess)
    lengthInBits += 1;

    // Simple field (flagReadOnly)
    lengthInBits += 1;

    // Simple field (flagTComInterfacePointer)
    lengthInBits += 1;

    // Simple field (flagTypeGuid)
    lengthInBits += 1;

    // Simple field (flagReferenceTo)
    lengthInBits += 1;

    // Simple field (flagBitValue)
    lengthInBits += 1;

    // Simple field (flagPersistent)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 3;

    // Simple field (flagExtendedFlags)
    lengthInBits += 1;

    // Simple field (flagInitOnReset)
    lengthInBits += 1;

    // Simple field (flagStatic)
    lengthInBits += 1;

    // Simple field (flagAttributes)
    lengthInBits += 1;

    // Simple field (flagContextMask)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Implicit Field (nameLength)
    lengthInBits += 16;

    // Implicit Field (dataTypeNameLength)
    lengthInBits += 16;

    // Implicit Field (commentLength)
    lengthInBits += 16;

    // Simple field (name)
    lengthInBits += (STR_LEN(getName())) * (8);

    // Const Field (nameTerminator)
    lengthInBits += 8;

    // Simple field (dataTypeName)
    lengthInBits += (STR_LEN(getDataTypeName())) * (8);

    // Const Field (dataTypeNameTerminator)
    lengthInBits += 8;

    // Simple field (comment)
    lengthInBits += (STR_LEN(getComment())) * (8);

    // Const Field (commentTerminator)
    lengthInBits += 8;

    // Array field
    if (rest != null) {
      lengthInBits += 8 * rest.length;
    }

    return lengthInBits;
  }

  public static AdsSymbolTableEntry staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AdsSymbolTableEntry staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AdsSymbolTableEntry");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long entryLength =
        readSimpleField(
            "entryLength",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long group =
        readSimpleField(
            "group",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long offset =
        readSimpleField(
            "offset",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long size =
        readSimpleField(
            "size",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long dataType =
        readSimpleField(
            "dataType",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagMethodDeref =
        readSimpleField(
            "flagMethodDeref",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagItfMethodAccess =
        readSimpleField(
            "flagItfMethodAccess",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagReadOnly =
        readSimpleField(
            "flagReadOnly",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagTComInterfacePointer =
        readSimpleField(
            "flagTComInterfacePointer",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagTypeGuid =
        readSimpleField(
            "flagTypeGuid",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagReferenceTo =
        readSimpleField(
            "flagReferenceTo",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagBitValue =
        readSimpleField(
            "flagBitValue",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagPersistent =
        readSimpleField(
            "flagPersistent",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Byte reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedByte(readBuffer, 3),
            (byte) 0x00,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagExtendedFlags =
        readSimpleField(
            "flagExtendedFlags",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagInitOnReset =
        readSimpleField(
            "flagInitOnReset",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagStatic =
        readSimpleField(
            "flagStatic",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagAttributes =
        readSimpleField(
            "flagAttributes",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean flagContextMask =
        readSimpleField(
            "flagContextMask",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Integer reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedInt(readBuffer, 16),
            (int) 0x0000,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    int nameLength =
        readImplicitField(
            "nameLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    int dataTypeNameLength =
        readImplicitField(
            "dataTypeNameLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    int commentLength =
        readImplicitField(
            "commentLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    String name =
        readSimpleField(
            "name",
            readString(readBuffer, (nameLength) * (8)),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    short nameTerminator =
        readConstField(
            "nameTerminator",
            readUnsignedShort(readBuffer, 8),
            AdsSymbolTableEntry.NAMETERMINATOR,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    String dataTypeName =
        readSimpleField(
            "dataTypeName",
            readString(readBuffer, (dataTypeNameLength) * (8)),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    short dataTypeNameTerminator =
        readConstField(
            "dataTypeNameTerminator",
            readUnsignedShort(readBuffer, 8),
            AdsSymbolTableEntry.DATATYPENAMETERMINATOR,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    String comment =
        readSimpleField(
            "comment",
            readString(readBuffer, (commentLength) * (8)),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    short commentTerminator =
        readConstField(
            "commentTerminator",
            readUnsignedShort(readBuffer, 8),
            AdsSymbolTableEntry.COMMENTTERMINATOR,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    byte[] rest =
        readBuffer.readByteArray(
            "rest",
            Math.toIntExact((entryLength) - ((positionAware.getPos() - startPos))),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("AdsSymbolTableEntry");
    // Create the instance
    AdsSymbolTableEntry _adsSymbolTableEntry;
    _adsSymbolTableEntry =
        new AdsSymbolTableEntry(
            entryLength,
            group,
            offset,
            size,
            dataType,
            flagMethodDeref,
            flagItfMethodAccess,
            flagReadOnly,
            flagTComInterfacePointer,
            flagTypeGuid,
            flagReferenceTo,
            flagBitValue,
            flagPersistent,
            flagExtendedFlags,
            flagInitOnReset,
            flagStatic,
            flagAttributes,
            flagContextMask,
            name,
            dataTypeName,
            comment,
            rest);
    _adsSymbolTableEntry.reservedField0 = reservedField0;
    _adsSymbolTableEntry.reservedField1 = reservedField1;
    return _adsSymbolTableEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsSymbolTableEntry)) {
      return false;
    }
    AdsSymbolTableEntry that = (AdsSymbolTableEntry) o;
    return (getEntryLength() == that.getEntryLength())
        && (getGroup() == that.getGroup())
        && (getOffset() == that.getOffset())
        && (getSize() == that.getSize())
        && (getDataType() == that.getDataType())
        && (getFlagMethodDeref() == that.getFlagMethodDeref())
        && (getFlagItfMethodAccess() == that.getFlagItfMethodAccess())
        && (getFlagReadOnly() == that.getFlagReadOnly())
        && (getFlagTComInterfacePointer() == that.getFlagTComInterfacePointer())
        && (getFlagTypeGuid() == that.getFlagTypeGuid())
        && (getFlagReferenceTo() == that.getFlagReferenceTo())
        && (getFlagBitValue() == that.getFlagBitValue())
        && (getFlagPersistent() == that.getFlagPersistent())
        && (getFlagExtendedFlags() == that.getFlagExtendedFlags())
        && (getFlagInitOnReset() == that.getFlagInitOnReset())
        && (getFlagStatic() == that.getFlagStatic())
        && (getFlagAttributes() == that.getFlagAttributes())
        && (getFlagContextMask() == that.getFlagContextMask())
        && (getName() == that.getName())
        && (getDataTypeName() == that.getDataTypeName())
        && (getComment() == that.getComment())
        && (getRest() == that.getRest())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getEntryLength(),
        getGroup(),
        getOffset(),
        getSize(),
        getDataType(),
        getFlagMethodDeref(),
        getFlagItfMethodAccess(),
        getFlagReadOnly(),
        getFlagTComInterfacePointer(),
        getFlagTypeGuid(),
        getFlagReferenceTo(),
        getFlagBitValue(),
        getFlagPersistent(),
        getFlagExtendedFlags(),
        getFlagInitOnReset(),
        getFlagStatic(),
        getFlagAttributes(),
        getFlagContextMask(),
        getName(),
        getDataTypeName(),
        getComment(),
        getRest());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
