/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsStampHeader implements Message {

  // Properties.
  protected final BigInteger timestamp;
  protected final long samples;
  protected final List<AdsNotificationSample> adsNotificationSamples;

  public AdsStampHeader(
      BigInteger timestamp, long samples, List<AdsNotificationSample> adsNotificationSamples) {
    super();
    this.timestamp = timestamp;
    this.samples = samples;
    this.adsNotificationSamples = adsNotificationSamples;
  }

  public BigInteger getTimestamp() {
    return timestamp;
  }

  public long getSamples() {
    return samples;
  }

  public List<AdsNotificationSample> getAdsNotificationSamples() {
    return adsNotificationSamples;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsStampHeader");

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeUnsignedBigInteger(writeBuffer, 64));

    // Simple Field (samples)
    writeSimpleField("samples", samples, writeUnsignedLong(writeBuffer, 32));

    // Array Field (adsNotificationSamples)
    writeComplexTypeArrayField("adsNotificationSamples", adsNotificationSamples, writeBuffer);

    writeBuffer.popContext("AdsStampHeader");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AdsStampHeader _value = this;

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (samples)
    lengthInBits += 32;

    // Array field
    if (adsNotificationSamples != null) {
      int i = 0;
      for (AdsNotificationSample element : adsNotificationSamples) {
        boolean last = ++i >= adsNotificationSamples.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static AdsStampHeader staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AdsStampHeader staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AdsStampHeader");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    BigInteger timestamp = readSimpleField("timestamp", readUnsignedBigInteger(readBuffer, 64));

    long samples = readSimpleField("samples", readUnsignedLong(readBuffer, 32));

    List<AdsNotificationSample> adsNotificationSamples =
        readCountArrayField(
            "adsNotificationSamples",
            new DataReaderComplexDefault<>(
                () -> AdsNotificationSample.staticParse(readBuffer), readBuffer),
            samples);

    readBuffer.closeContext("AdsStampHeader");
    // Create the instance
    AdsStampHeader _adsStampHeader;
    _adsStampHeader = new AdsStampHeader(timestamp, samples, adsNotificationSamples);
    return _adsStampHeader;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsStampHeader)) {
      return false;
    }
    AdsStampHeader that = (AdsStampHeader) o;
    return (getTimestamp() == that.getTimestamp())
        && (getSamples() == that.getSamples())
        && (getAdsNotificationSamples() == that.getAdsNotificationSamples())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTimestamp(), getSamples(), getAdsNotificationSamples());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
