/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsDiscoveryBlockAmsNetId extends AdsDiscoveryBlock implements Message {

  // Accessors for discriminator values.
  public AdsDiscoveryBlockType getBlockType() {
    return AdsDiscoveryBlockType.AMS_NET_ID;
  }

  // Constant values.
  public static final Integer AMSNETIDLENGTH = 0x0006;

  // Properties.
  protected final AmsNetId amsNetId;

  public AdsDiscoveryBlockAmsNetId(AmsNetId amsNetId) {
    super();
    this.amsNetId = amsNetId;
  }

  public AmsNetId getAmsNetId() {
    return amsNetId;
  }

  public int getAmsNetIdLength() {
    return AMSNETIDLENGTH;
  }

  @Override
  protected void serializeAdsDiscoveryBlockChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsDiscoveryBlockAmsNetId");

    // Const Field (amsNetIdLength)
    writeConstField("amsNetIdLength", AMSNETIDLENGTH, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (amsNetId)
    writeSimpleField("amsNetId", amsNetId, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("AdsDiscoveryBlockAmsNetId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsDiscoveryBlockAmsNetId _value = this;

    // Const Field (amsNetIdLength)
    lengthInBits += 16;

    // Simple field (amsNetId)
    lengthInBits += amsNetId.getLengthInBits();

    return lengthInBits;
  }

  public static AdsDiscoveryBlockAmsNetIdBuilder staticParseBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AdsDiscoveryBlockAmsNetId");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int amsNetIdLength =
        readConstField(
            "amsNetIdLength",
            readUnsignedInt(readBuffer, 16),
            AdsDiscoveryBlockAmsNetId.AMSNETIDLENGTH);

    AmsNetId amsNetId =
        readSimpleField(
            "amsNetId",
            new DataReaderComplexDefault<>(() -> AmsNetId.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AdsDiscoveryBlockAmsNetId");
    // Create the instance
    return new AdsDiscoveryBlockAmsNetIdBuilder(amsNetId);
  }

  public static class AdsDiscoveryBlockAmsNetIdBuilder
      implements AdsDiscoveryBlock.AdsDiscoveryBlockBuilder {
    private final AmsNetId amsNetId;

    public AdsDiscoveryBlockAmsNetIdBuilder(AmsNetId amsNetId) {

      this.amsNetId = amsNetId;
    }

    public AdsDiscoveryBlockAmsNetId build() {
      AdsDiscoveryBlockAmsNetId adsDiscoveryBlockAmsNetId = new AdsDiscoveryBlockAmsNetId(amsNetId);
      return adsDiscoveryBlockAmsNetId;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsDiscoveryBlockAmsNetId)) {
      return false;
    }
    AdsDiscoveryBlockAmsNetId that = (AdsDiscoveryBlockAmsNetId) o;
    return (getAmsNetId() == that.getAmsNetId()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAmsNetId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
