/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsDiscovery implements Message {

  // Constant values.
  public static final Long HEADER = 0x71146603L;

  // Properties.
  protected final long requestId;
  protected final Operation operation;
  protected final AmsNetId amsNetId;
  protected final AdsPortNumbers portNumber;
  protected final List<AdsDiscoveryBlock> blocks;

  public AdsDiscovery(
      long requestId,
      Operation operation,
      AmsNetId amsNetId,
      AdsPortNumbers portNumber,
      List<AdsDiscoveryBlock> blocks) {
    super();
    this.requestId = requestId;
    this.operation = operation;
    this.amsNetId = amsNetId;
    this.portNumber = portNumber;
    this.blocks = blocks;
  }

  public long getRequestId() {
    return requestId;
  }

  public Operation getOperation() {
    return operation;
  }

  public AmsNetId getAmsNetId() {
    return amsNetId;
  }

  public AdsPortNumbers getPortNumber() {
    return portNumber;
  }

  public List<AdsDiscoveryBlock> getBlocks() {
    return blocks;
  }

  public long getHeader() {
    return HEADER;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsDiscovery");

    // Const Field (header)
    writeConstField("header", HEADER, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (requestId)
    writeSimpleField(
        "requestId",
        requestId,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (operation)
    writeSimpleEnumField(
        "operation",
        "Operation",
        operation,
        new DataWriterEnumDefault<>(
            Operation::getValue, Operation::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (amsNetId)
    writeSimpleField(
        "amsNetId",
        amsNetId,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (portNumber)
    writeSimpleEnumField(
        "portNumber",
        "AdsPortNumbers",
        portNumber,
        new DataWriterEnumDefault<>(
            AdsPortNumbers::getValue, AdsPortNumbers::name, writeUnsignedInt(writeBuffer, 16)));

    // Implicit Field (numBlocks) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    long numBlocks = (long) (COUNT(getBlocks()));
    writeImplicitField("numBlocks", numBlocks, writeUnsignedLong(writeBuffer, 32));

    // Array Field (blocks)
    writeComplexTypeArrayField("blocks", blocks, writeBuffer);

    writeBuffer.popContext("AdsDiscovery");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AdsDiscovery _value = this;

    // Const Field (header)
    lengthInBits += 32;

    // Simple field (requestId)
    lengthInBits += 32;

    // Simple field (operation)
    lengthInBits += 32;

    // Simple field (amsNetId)
    lengthInBits += amsNetId.getLengthInBits();

    // Simple field (portNumber)
    lengthInBits += 16;

    // Implicit Field (numBlocks)
    lengthInBits += 32;

    // Array field
    if (blocks != null) {
      int i = 0;
      for (AdsDiscoveryBlock element : blocks) {
        boolean last = ++i >= blocks.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static AdsDiscovery staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AdsDiscovery staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AdsDiscovery");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long header =
        readConstField(
            "header",
            readUnsignedLong(readBuffer, 32),
            AdsDiscovery.HEADER,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long requestId =
        readSimpleField(
            "requestId",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Operation operation =
        readEnumField(
            "operation",
            "Operation",
            new DataReaderEnumDefault<>(Operation::enumForValue, readUnsignedLong(readBuffer, 32)),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    AmsNetId amsNetId =
        readSimpleField(
            "amsNetId",
            new DataReaderComplexDefault<>(() -> AmsNetId.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    AdsPortNumbers portNumber =
        readEnumField(
            "portNumber",
            "AdsPortNumbers",
            new DataReaderEnumDefault<>(
                AdsPortNumbers::enumForValue, readUnsignedInt(readBuffer, 16)),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long numBlocks =
        readImplicitField(
            "numBlocks",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    List<AdsDiscoveryBlock> blocks =
        readCountArrayField(
            "blocks",
            new DataReaderComplexDefault<>(
                () -> AdsDiscoveryBlock.staticParse(readBuffer), readBuffer),
            numBlocks,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("AdsDiscovery");
    // Create the instance
    AdsDiscovery _adsDiscovery;
    _adsDiscovery = new AdsDiscovery(requestId, operation, amsNetId, portNumber, blocks);
    return _adsDiscovery;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsDiscovery)) {
      return false;
    }
    AdsDiscovery that = (AdsDiscovery) o;
    return (getRequestId() == that.getRequestId())
        && (getOperation() == that.getOperation())
        && (getAmsNetId() == that.getAmsNetId())
        && (getPortNumber() == that.getPortNumber())
        && (getBlocks() == that.getBlocks())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getRequestId(), getOperation(), getAmsNetId(), getPortNumber(), getBlocks());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
