/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.abeth.configuration.AbEthConfiguration;
import org.apache.plc4x.java.abeth.protocol.AbEthProtocolLogic;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.tag.AbEthTag;
import org.apache.plc4x.java.abeth.tag.AbEthTagHandler;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class AbEthDriver
extends GeneratedDriverBase<CIPEncapsulationPacket> {
    public static final int AB_ETH_PORT = 2222;

    public String getProtocolCode() {
        return "ab-eth";
    }

    public String getProtocolName() {
        return "Allen Bradley ETH";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return AbEthConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "raw";
    }

    protected AbEthTagHandler getTagHandler() {
        return new AbEthTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected ProtocolStackConfigurer<CIPEncapsulationPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(CIPEncapsulationPacket.class, (readBuffer, objectArray) -> CIPEncapsulationPacket.staticParse(readBuffer, objectArray)).withProtocol(AbEthProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public PlcTag prepareTag(String tagAddress) {
        return AbEthTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2) + 28;
            }
            return -1;
        }
    }
}

