/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.abeth.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CIPEncapsulationPacket implements Message {

  // Abstract accessors for discriminator values.
  public abstract Integer getCommandType();

  // Properties.
  protected final long sessionHandle;
  protected final long status;
  protected final List<Short> senderContext;
  protected final long options;
  // Reserved Fields
  private Long reservedField0;

  public CIPEncapsulationPacket(
      long sessionHandle, long status, List<Short> senderContext, long options) {
    super();
    this.sessionHandle = sessionHandle;
    this.status = status;
    this.senderContext = senderContext;
    this.options = options;
  }

  public long getSessionHandle() {
    return sessionHandle;
  }

  public long getStatus() {
    return status;
  }

  public List<Short> getSenderContext() {
    return senderContext;
  }

  public long getOptions() {
    return options;
  }

  protected abstract void serializeCIPEncapsulationPacketChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CIPEncapsulationPacket");

    // Discriminator Field (commandType) (Used as input to a switch field)
    writeDiscriminatorField("commandType", getCommandType(), writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (packetLen) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int packetLen = (int) ((getLengthInBytes()) - (28));
    writeImplicitField("packetLen", packetLen, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (sessionHandle)
    writeSimpleField(
        "sessionHandle",
        sessionHandle,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (status)
    writeSimpleField(
        "status",
        status,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (senderContext)
    writeSimpleTypeArrayField("senderContext", senderContext, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (options)
    writeSimpleField(
        "options",
        options,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (long) 0x00000000,
        writeUnsignedLong(writeBuffer, 32));

    // Switch field (Serialize the sub-type)
    serializeCIPEncapsulationPacketChild(writeBuffer);

    writeBuffer.popContext("CIPEncapsulationPacket");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CIPEncapsulationPacket _value = this;

    // Discriminator Field (commandType)
    lengthInBits += 16;

    // Implicit Field (packetLen)
    lengthInBits += 16;

    // Simple field (sessionHandle)
    lengthInBits += 32;

    // Simple field (status)
    lengthInBits += 32;

    // Array field
    if (senderContext != null) {
      lengthInBits += 8 * senderContext.size();
    }

    // Simple field (options)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 32;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static CIPEncapsulationPacket staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static CIPEncapsulationPacket staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CIPEncapsulationPacket");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int commandType =
        readDiscriminatorField(
            "commandType",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int packetLen =
        readImplicitField(
            "packetLen",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long sessionHandle =
        readSimpleField(
            "sessionHandle",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long status =
        readSimpleField(
            "status",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<Short> senderContext =
        readCountArrayField(
            "senderContext",
            readUnsignedShort(readBuffer, 8),
            8,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long options =
        readSimpleField(
            "options",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Long reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedLong(readBuffer, 32),
            (long) 0x00000000,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CIPEncapsulationPacketBuilder builder = null;
    if (EvaluationHelper.equals(commandType, (int) 0x0101)) {
      builder = CIPEncapsulationConnectionRequest.staticParseBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, (int) 0x0201)) {
      builder = CIPEncapsulationConnectionResponse.staticParseBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, (int) 0x0107)) {
      builder = CIPEncapsulationReadRequest.staticParseBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, (int) 0x0207)) {
      builder = CIPEncapsulationReadResponse.staticParseBuilder(readBuffer, packetLen);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "commandType="
              + commandType
              + "]");
    }

    readBuffer.closeContext("CIPEncapsulationPacket");
    // Create the instance
    CIPEncapsulationPacket _cIPEncapsulationPacket =
        builder.build(sessionHandle, status, senderContext, options);
    _cIPEncapsulationPacket.reservedField0 = reservedField0;
    return _cIPEncapsulationPacket;
  }

  public static interface CIPEncapsulationPacketBuilder {
    CIPEncapsulationPacket build(
        long sessionHandle, long status, List<Short> senderContext, long options);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CIPEncapsulationPacket)) {
      return false;
    }
    CIPEncapsulationPacket that = (CIPEncapsulationPacket) o;
    return (getSessionHandle() == that.getSessionHandle())
        && (getStatus() == that.getStatus())
        && (getSenderContext() == that.getSenderContext())
        && (getOptions() == that.getOptions())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSessionHandle(), getStatus(), getSenderContext(), getOptions());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
