/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool;

import java.util.Objects;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;

public abstract class PoolKey {
    protected final String url;
    protected final PlcAuthentication plcAuthentication;

    public PoolKey(String url, PlcAuthentication plcAuthentication) {
        this.url = url;
        this.plcAuthentication = plcAuthentication;
    }

    public String getUrl() {
        return this.url;
    }

    public PlcAuthentication getPlcAuthentication() {
        return this.plcAuthentication;
    }

    public abstract String getPoolableKey();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolKey)) {
            return false;
        }
        PoolKey poolKey = (PoolKey)o;
        return Objects.equals(this.getPoolableKey(), poolKey.getPoolableKey()) && Objects.equals(this.plcAuthentication, poolKey.plcAuthentication);
    }

    public int hashCode() {
        return Objects.hash(this.getPoolableKey(), this.plcAuthentication);
    }

    public String toString() {
        return "PoolKey{url='" + this.url + '\'' + (this.plcAuthentication != PooledPlcDriverManager.noPlcAuthentication ? ", plcAuthentication=" + this.plcAuthentication : "") + '}';
    }
}

