/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.util.Locale;
import org.apache.pivot.wtk.validation.FloatValidator;

public class FloatRangeValidator
extends FloatValidator {
    private float minValue;
    private float maxValue;

    public FloatRangeValidator() {
        this.minValue = -3.4028235E38f;
        this.maxValue = Float.MAX_VALUE;
    }

    public FloatRangeValidator(Locale locale) {
        super(locale);
        this.minValue = -3.4028235E38f;
        this.maxValue = Float.MAX_VALUE;
    }

    public FloatRangeValidator(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public FloatRangeValidator(Locale locale, float minValue, float maxValue) {
        super(locale);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public float getMinimum() {
        return this.minValue;
    }

    public void setMinimum(float minValue) {
        this.minValue = minValue;
    }

    public float getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(float maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isValid(String text) {
        boolean valid = false;
        if (super.isValid(text)) {
            float f = this.textToObject(text).floatValue();
            valid = f >= this.minValue && f <= this.maxValue;
        }
        return valid;
    }

    private final Float textToObject(String text) {
        return Float.valueOf(this.parseNumber(text).floatValue());
    }
}

