/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URL;
import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.Map;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;

public class ScriptApplication
implements Application {
    private Window window = null;
    public static final String SRC_KEY = "src";
    public static final String RESOURCES_KEY = "resources";
    public static final String STYLESHEET_KEY = "stylesheet";

    @Override
    public void startup(Display display, Map<String, String> properties) throws Exception {
        String src = (String)properties.get((Object)SRC_KEY);
        if (src == null) {
            throw new IllegalArgumentException("src argument is required.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL location = classLoader.getResource(src.substring(1));
        if (location == null) {
            throw new IllegalArgumentException("Cannot find source file \"" + src + "\".");
        }
        Resources resources = properties.containsKey((Object)RESOURCES_KEY) ? new Resources((String)properties.get((Object)RESOURCES_KEY)) : null;
        if (properties.containsKey((Object)STYLESHEET_KEY)) {
            String stylesheet = (String)properties.get((Object)STYLESHEET_KEY);
            if (!stylesheet.startsWith("/")) {
                throw new IllegalArgumentException("Value for stylesheet argument must start with a slash character.");
            }
            ApplicationContext.applyStylesheet(stylesheet);
        }
        BXMLSerializer bxmlSerializer = new BXMLSerializer();
        this.window = (Window)bxmlSerializer.readObject(location, resources);
        this.window.open(display);
    }

    @Override
    public boolean shutdown(boolean optional) {
        if (this.window != null) {
            this.window.close();
        }
        return false;
    }

    @Override
    public void resume() {
    }

    @Override
    public void suspend() {
    }

    public static void main(String[] args) {
        DesktopApplicationContext.main(ScriptApplication.class, args);
    }
}

