/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.File;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.FileBrowserSheetListener;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.WTKListenerList;

public class FileBrowserSheet
extends Sheet {
    private static final String USER_HOME = System.getProperty("user.home");
    private Mode mode;
    private File rootDirectory;
    private FileList selectedFiles = new FileList();
    private Filter<File> disabledFileFilter = null;
    private FileBrowserSheetListenerList fileBrowserSheetListeners = new FileBrowserSheetListenerList();

    public FileBrowserSheet() {
        this(Mode.OPEN);
    }

    public FileBrowserSheet(Mode mode) {
        this(mode, USER_HOME);
    }

    public FileBrowserSheet(String rootFolder) {
        this(Mode.OPEN, rootFolder);
    }

    public FileBrowserSheet(Mode mode, String rootFolder) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (rootFolder == null) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
        this.setRootFolder(rootFolder);
        this.installSkin(FileBrowserSheet.class);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        Mode previousMode = this.mode;
        if (previousMode != mode) {
            this.mode = mode;
            this.fileBrowserSheetListeners.modeChanged(this, previousMode);
        }
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootFolder(String rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException();
        }
        this.rootDirectory = new File(rootFolder);
        if (!this.rootDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
    }

    public void setRootDirectory(File rootDirectory) {
        if (rootDirectory == null || !rootDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (rootDirectory.exists()) {
            File previousRootDirectory = this.rootDirectory;
            if (!rootDirectory.equals(previousRootDirectory)) {
                this.rootDirectory = rootDirectory;
                this.selectedFiles.clear();
                this.fileBrowserSheetListeners.rootDirectoryChanged(this, previousRootDirectory);
            }
        } else {
            this.setRootDirectory(rootDirectory.getParentFile());
        }
    }

    public File getSelectedFile() {
        if (this.mode == Mode.OPEN_MULTIPLE) {
            throw new IllegalStateException("File browser sheet is not in single-select mode.");
        }
        return this.selectedFiles.getLength() == 0 ? null : (File)this.selectedFiles.get(0);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.clearSelection();
        } else {
            if (file.isAbsolute()) {
                this.setRootDirectory(file.getParentFile());
            }
            this.setSelectedFiles((Sequence<File>)new ArrayList((Object[])new File[]{file}));
        }
    }

    public ImmutableList<File> getSelectedFiles() {
        return new ImmutableList((List)this.selectedFiles);
    }

    public Sequence<File> setSelectedFiles(Sequence<File> selectedFiles) {
        if (selectedFiles == null) {
            throw new IllegalArgumentException("selectedFiles is null.");
        }
        if (this.mode != Mode.OPEN_MULTIPLE && selectedFiles.getLength() > 1) {
            throw new IllegalArgumentException("Multi-select is not enabled.");
        }
        ImmutableList<File> previousSelectedFiles = this.getSelectedFiles();
        FileList fileList = new FileList();
        int n = selectedFiles.getLength();
        for (int i = 0; i < n; ++i) {
            File file = (File)selectedFiles.get(i);
            if (file == null) {
                throw new IllegalArgumentException("file is null.");
            }
            if (!file.isAbsolute()) {
                file = new File(this.rootDirectory, file.getPath());
            }
            if (!file.getParentFile().equals(this.rootDirectory)) {
                throw new IllegalArgumentException();
            }
            fileList.add(file);
        }
        this.selectedFiles = fileList;
        this.fileBrowserSheetListeners.selectedFilesChanged(this, (Sequence<File>)previousSelectedFiles);
        return this.getSelectedFiles();
    }

    public void clearSelection() {
        this.setSelectedFiles((Sequence<File>)new ArrayList());
    }

    public Filter<File> getDisabledFileFilter() {
        return this.disabledFileFilter;
    }

    public void setDisabledFileFilter(Filter<File> disabledFileFilter) {
        Filter<File> previousDisabledFileFilter = this.disabledFileFilter;
        if (previousDisabledFileFilter != disabledFileFilter) {
            this.disabledFileFilter = disabledFileFilter;
            this.fileBrowserSheetListeners.disabledFileFilterChanged(this, previousDisabledFileFilter);
        }
    }

    public ListenerList<FileBrowserSheetListener> getFileBrowserSheetListeners() {
        return this.fileBrowserSheetListeners;
    }

    private static class FileBrowserSheetListenerList
    extends WTKListenerList<FileBrowserSheetListener>
    implements FileBrowserSheetListener {
        private FileBrowserSheetListenerList() {
        }

        @Override
        public void modeChanged(FileBrowserSheet fileBrowserSheet, Mode previousMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserSheetListener listener = (FileBrowserSheetListener)i$.next();
                listener.modeChanged(fileBrowserSheet, previousMode);
            }
        }

        @Override
        public void rootDirectoryChanged(FileBrowserSheet fileBrowserSheet, File previousRootDirectory) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserSheetListener listener = (FileBrowserSheetListener)i$.next();
                listener.rootDirectoryChanged(fileBrowserSheet, previousRootDirectory);
            }
        }

        @Override
        public void selectedFilesChanged(FileBrowserSheet fileBrowserSheet, Sequence<File> previousSelectedFiles) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserSheetListener listener = (FileBrowserSheetListener)i$.next();
                listener.selectedFilesChanged(fileBrowserSheet, previousSelectedFiles);
            }
        }

        @Override
        public void disabledFileFilterChanged(FileBrowserSheet fileBrowserSheet, Filter<File> previousDisabledFileFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserSheetListener listener = (FileBrowserSheetListener)i$.next();
                listener.disabledFileFilterChanged(fileBrowserSheet, previousDisabledFileFilter);
            }
        }
    }

    public static enum Mode {
        OPEN,
        OPEN_MULTIPLE,
        SAVE_AS,
        SAVE_TO;

    }
}

