/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTooltipSkin
extends WindowSkin {
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener(){

        public boolean mouseMove(Container container, int x, int y) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseUp(Container container, Mouse.Button button, int x, int y) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            TerraTooltipSkin.this.fade = false;
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }
    };
    private ComponentKeyListener displayKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            TerraTooltipSkin.this.fade = false;
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }
    };
    private Transition closeTransition = null;
    private DropShadowDecorator dropShadowDecorator = null;
    private boolean fade = true;
    private Color borderColor;
    private Insets padding;
    private int closeTransitionDuration = 500;
    private int closeTransitionRate = 30;
    private static final int DEFAULT_CLOSE_TRANSITION_DURATION = 500;
    private static final int DEFAULT_CLOSE_TRANSITION_RATE = 30;

    public TerraTooltipSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(19));
        this.borderColor = Color.BLACK;
        this.padding = new Insets(2);
    }

    public void install(Component component) {
        super.install(component);
        Tooltip tooltip = (Tooltip)component;
        this.dropShadowDecorator = new DropShadowDecorator(5, 2, 2);
        tooltip.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Tooltip tooltip = (Tooltip)this.getComponent();
        Component content = tooltip.getContent();
        if (height != -1) {
            height -= this.padding.top + this.padding.bottom + 2;
        }
        if (content != null) {
            preferredWidth = content.getPreferredWidth(height);
        }
        return preferredWidth += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Tooltip tooltip = (Tooltip)this.getComponent();
        Component content = tooltip.getContent();
        if (width != -1) {
            width -= this.padding.left + this.padding.right + 2;
        }
        if (content != null) {
            preferredHeight = content.getPreferredHeight(width);
        }
        return preferredHeight += this.padding.top + this.padding.bottom + 2;
    }

    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        Tooltip tooltip = (Tooltip)this.getComponent();
        Component content = tooltip.getContent();
        if (content != null) {
            Dimensions contentSize = content.getPreferredSize();
            preferredWidth = contentSize.width;
            preferredHeight = contentSize.height;
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right + 2, preferredHeight += this.padding.top + this.padding.bottom + 2);
    }

    public void layout() {
        Tooltip tooltip = (Tooltip)this.getComponent();
        Component content = tooltip.getContent();
        if (content != null) {
            int contentWidth = Math.max(this.getWidth() - (this.padding.left + this.padding.right + 2), 0);
            int contentHeight = Math.max(this.getHeight() - (this.padding.top + this.padding.bottom + 2), 0);
            content.setSize(contentWidth, contentHeight);
            content.setLocation(this.padding.left + 1, this.padding.top + 1);
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setColor(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
    }

    public int getCloseTransitionDuration() {
        return this.closeTransitionDuration;
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.closeTransitionDuration = closeTransitionDuration;
    }

    public int getCloseTransitionRate() {
        return this.closeTransitionRate;
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.closeTransitionRate = closeTransitionRate;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.getComponentKeyListeners().add((Object)this.displayKeyListener);
    }

    public Vote previewWindowClose(final Window window) {
        Vote vote = Vote.APPROVE;
        if (this.fade) {
            if (this.closeTransition == null) {
                this.closeTransition = new FadeWindowTransition((Component)window, this.closeTransitionDuration, this.closeTransitionRate, this.dropShadowDecorator);
                this.closeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        window.close();
                    }
                });
                vote = Vote.DEFER;
            } else {
                vote = this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
            }
        }
        return vote;
    }

    public void windowCloseVetoed(Window window, Vote reason) {
        super.windowCloseVetoed(window, reason);
        if (reason == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
        }
    }

    public void windowClosed(Window window, Display display, Window owner) {
        super.windowClosed(window, display, owner);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        display.getComponentKeyListeners().remove((Object)this.displayKeyListener);
        this.closeTransition = null;
    }
}

