/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.SheetStateListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.TranslationDecorator;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSheetSkin
extends WindowSkin
implements SheetStateListener {
    private Image resizeImage = new ResizeImage();
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private Point resizeOffset = null;
    private Color borderColor;
    private Insets padding;
    private boolean resizable;
    private SheetPlacement slideSource = SheetPlacement.NORTH;
    private int stateTransitionDuration = 300;
    private int stateTransitionRate = 30;
    private Color bevelColor;
    private OpenTransition openTransition = null;
    private Quadratic easing = new Quadratic();
    private TranslationDecorator translationDecorator = new TranslationDecorator(true);
    private boolean closingResult;
    private boolean doingFinalClose = false;
    private ComponentListener ownerListener = new ComponentListener.Adapter(){

        public void locationChanged(Component component, int previousX, int previousY) {
            TerraSheetSkin.this.alignToOwner();
        }

        public void sizeChanged(Component component, int previousWidth, int previousHeight) {
            TerraSheetSkin.this.alignToOwner();
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener(){

        public boolean mouseMove(Container display, int x, int y) {
            return this.isMouseOverOwnerClientArea(display, x, y);
        }

        public boolean mouseDown(Container display, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            if (this.isMouseOverOwnerClientArea(display, x, y)) {
                Window rootOwner = sheet.getRootOwner();
                rootOwner.moveToFront();
                consumed = true;
                Toolkit.getDefaultToolkit().beep();
            }
            return consumed;
        }

        public boolean mouseUp(Container display, Mouse.Button button, int x, int y) {
            return this.isMouseOverOwnerClientArea(display, x, y);
        }

        public boolean mouseWheel(Container display, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            return this.isMouseOverOwnerClientArea(display, x, y);
        }

        private boolean isMouseOverOwnerClientArea(Container display, int x, int y) {
            boolean mouseOverOwnerClientArea = false;
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            Component descendant = display.getDescendantAt(x, y);
            if (descendant != display) {
                Window window = descendant.getWindow();
                if (sheet.getOwner() == window) {
                    Bounds clientArea = window.getClientArea();
                    Point location = window.mapPointFromAncestor(display, x, y);
                    mouseOverOwnerClientArea = clientArea.contains(location);
                }
            }
            return mouseOverOwnerClientArea;
        }
    };
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int DEFAULT_STATE_TRANSITION_DURATION = 300;
    private static final int DEFAULT_STATE_TRANSITION_RATE = 30;

    public TerraSheetSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        Color backgroundColor = theme.getColor(11);
        backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 235);
        this.setBackgroundColor(backgroundColor);
        this.borderColor = theme.getColor(7);
        this.padding = new Insets(8);
        this.resizable = false;
        this.bevelColor = TerraTheme.darken(backgroundColor);
    }

    public void install(Component component) {
        super.install(component);
        Sheet sheet = (Sheet)component;
        sheet.getSheetStateListeners().add((Object)this);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        sheet.getDecorators().add((Decorator)this.dropShadowDecorator);
        sheet.add((Component)this.resizeHandle);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component content = sheet.getContent();
        if (content != null) {
            if (height != -1) {
                height = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
            }
            preferredWidth = content.getPreferredWidth(height);
        }
        return preferredWidth += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component content = sheet.getContent();
        if (content != null) {
            if (width != -1) {
                width = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
            }
            preferredHeight = content.getPreferredHeight(width);
        }
        return preferredHeight += this.padding.top + this.padding.bottom + 2;
    }

    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component content = sheet.getContent();
        if (content != null) {
            Dimensions preferredContentSize = content.getPreferredSize();
            preferredWidth = preferredContentSize.width;
            preferredHeight = preferredContentSize.height;
        }
        Dimensions preferredSize = new Dimensions(preferredWidth += this.padding.left + this.padding.right + 2, preferredHeight += this.padding.top + this.padding.bottom + 2);
        return preferredSize;
    }

    public void layout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Sheet sheet = (Sheet)this.getComponent();
        this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
        this.resizeHandle.setLocation(width - this.resizeHandle.getWidth() - 2, height - this.resizeHandle.getHeight() - 2);
        this.resizeHandle.setVisible(this.resizable && !sheet.isMaximized() && (sheet.isPreferredWidthSet() || sheet.isPreferredHeightSet()));
        Component content = sheet.getContent();
        if (content != null) {
            content.setLocation(this.padding.left + 1, this.padding.top + 1);
            int contentWidth = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
            int contentHeight = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
            content.setSize(contentWidth, contentHeight);
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
        graphics.setPaint(this.bevelColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)1, (int)(height - 2), (int)(width - 2), (Orientation)Orientation.HORIZONTAL);
    }

    public void sizeChanged(Component component, int previousWidth, int previousHeight) {
        super.sizeChanged(component, previousWidth, previousHeight);
        this.alignToOwner();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            Sheet sheet = (Sheet)this.getComponent();
            Display display = sheet.getDisplay();
            Point location = sheet.mapPointToAncestor((Container)display, x, y);
            location = new Point(Math.min(Math.max(location.x, 0), display.getWidth() - 1), Math.min(Math.max(location.y, 0), display.getHeight() - 1));
            if (this.resizeOffset != null) {
                boolean noPreferredSet;
                int preferredWidth = -1;
                int preferredHeight = -1;
                boolean preferredWidthSet = component.isPreferredWidthSet();
                boolean preferredHeightSet = component.isPreferredHeightSet();
                boolean bl = noPreferredSet = !preferredWidthSet && !preferredHeightSet;
                if (preferredWidthSet || noPreferredSet) {
                    preferredWidth = Math.max(location.x - sheet.getX() + this.resizeOffset.x, 2);
                    preferredWidth = Math.min(preferredWidth, sheet.getMaximumWidth());
                    preferredWidth = Math.max(preferredWidth, sheet.getMinimumWidth());
                }
                if (preferredHeightSet || noPreferredSet) {
                    preferredHeight = Math.max(location.y - sheet.getY() + this.resizeOffset.y, this.resizeHandle.getHeight() + 7);
                    preferredHeight = Math.min(preferredHeight, sheet.getMaximumHeight());
                    preferredHeight = Math.max(preferredHeight, sheet.getMinimumHeight());
                }
                sheet.setPreferredSize(preferredWidth, preferredHeight);
            }
        } else {
            Cursor cursor = null;
            Bounds resizeHandleBounds = this.resizeHandle.getBounds();
            if (this.resizable && resizeHandleBounds.contains(x, y)) {
                boolean preferredWidthSet = component.isPreferredWidthSet();
                boolean preferredHeightSet = component.isPreferredHeightSet();
                cursor = preferredWidthSet && preferredHeightSet ? Cursor.RESIZE_SOUTH_EAST : (preferredWidthSet ? Cursor.RESIZE_EAST : (preferredHeightSet ? Cursor.RESIZE_SOUTH : Cursor.RESIZE_SOUTH_EAST));
            }
            component.setCursor(cursor);
        }
        return consumed;
    }

    public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
        Bounds resizeHandleBounds;
        Sheet sheet = (Sheet)container;
        if (!sheet.isTopMost()) {
            Window owner = sheet.getOwner();
            owner.moveToFront();
        }
        boolean consumed = super.mouseDown(container, button, x, y);
        if (this.resizable && button == Mouse.Button.LEFT && (resizeHandleBounds = this.resizeHandle.getBounds()).contains(x, y)) {
            this.resizeOffset = new Point(this.getWidth() - x, this.getHeight() - y);
            Mouse.capture((Component)container);
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            this.resizeOffset = null;
            Mouse.release();
        }
        return consumed;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        Sheet sheet = (Sheet)this.getComponent();
        if (keyCode == 10) {
            sheet.close(true);
            consumed = true;
        } else if (keyCode == 27) {
            sheet.close(false);
            consumed = true;
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
        this.bevelColor = TerraTheme.darken(backgroundColor);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.invalidateComponent();
    }

    public SheetPlacement getSlideSource() {
        return this.slideSource;
    }

    public void setSlideSource(SheetPlacement slideSource) {
        if (slideSource == null) {
            throw new IllegalArgumentException("slideSource is null.");
        }
        this.slideSource = slideSource;
    }

    public int getStateTransitionDuration() {
        return this.stateTransitionDuration;
    }

    public void setStateTransitionDuration(int stateTransitionDuration) {
        this.stateTransitionDuration = stateTransitionDuration;
    }

    public int getStateTransitionRate() {
        return this.stateTransitionRate;
    }

    public void setStateTransitionRate(int stateTransitionRate) {
        this.stateTransitionRate = stateTransitionRate;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.reenterMouse();
        this.dropShadowDecorator.setShadowOpacity(0.25f);
        this.alignToOwner();
        Window owner = window.getOwner();
        owner.getComponentListeners().add((Object)this.ownerListener);
        this.openTransition = new OpenTransition(false);
        this.openTransition.start(new TransitionListener(){

            public void transitionCompleted(Transition transition) {
                TerraSheetSkin.this.openTransition = null;
            }
        });
        if (!window.requestFocus()) {
            Component.clearFocus();
        }
    }

    public void windowClosed(Window window, Display display, Window owner) {
        super.windowClosed(window, display, owner);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        owner.getComponentListeners().remove((Object)this.ownerListener);
    }

    public Vote previewSheetClose(Sheet sheet, boolean result) {
        Vote vote = Vote.APPROVE;
        Window owner = sheet.getOwner();
        if (!(owner.isClosing() || owner.isClosed() || this.doingFinalClose)) {
            if (this.openTransition == null) {
                this.openTransition = new OpenTransition(true);
                this.closingResult = result;
            } else if (this.openTransition.isRunning()) {
                this.openTransition.reverse();
            }
            vote = this.openTransition != null ? Vote.DEFER : Vote.APPROVE;
        }
        return vote;
    }

    public void sheetCloseVetoed(final Sheet sheet, Vote reason) {
        if (reason == Vote.DENY && this.openTransition != null) {
            this.openTransition.stop();
            this.openTransition = null;
        } else if (reason == Vote.DEFER && this.openTransition != null && !this.openTransition.isRunning()) {
            this.openTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    TerraSheetSkin.this.openTransition = null;
                    TerraSheetSkin.this.doingFinalClose = true;
                    sheet.close(TerraSheetSkin.this.closingResult);
                    TerraSheetSkin.this.doingFinalClose = false;
                }
            });
        }
    }

    public void sheetClosed(Sheet sheet) {
    }

    public void alignToOwner() {
        Sheet sheet = (Sheet)this.getComponent();
        Window owner = sheet.getOwner();
        if (owner != null) {
            Bounds clientArea = owner.getClientArea();
            Point location = owner.mapPointToAncestor((Container)owner.getDisplay(), clientArea.x, clientArea.y);
            int x = location.x;
            int y = location.y;
            switch (this.slideSource) {
                case NORTH: {
                    x = location.x + (clientArea.width - this.getWidth()) / 2;
                    y = location.y;
                    break;
                }
                case SOUTH: {
                    x = location.x + (clientArea.width - this.getWidth()) / 2;
                    y = location.y + (clientArea.height - this.getHeight());
                    break;
                }
                case WEST: {
                    x = location.x;
                    y = location.y + (clientArea.height - this.getHeight()) / 2;
                    break;
                }
                case EAST: {
                    x = location.x + (clientArea.width - this.getWidth());
                    y = location.y + (clientArea.height - this.getHeight()) / 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("slideSource is null or an unexpected value");
                }
            }
            sheet.setLocation(x, y);
        }
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics) {
            graphics.setPaint(new Color(0, 0, 0, 64));
            graphics.fillRect(3, 0, 2, 1);
            graphics.fillRect(0, 3, 2, 1);
            graphics.fillRect(3, 3, 2, 1);
            graphics.setPaint(new Color(TerraSheetSkin.this.borderColor.getRed(), TerraSheetSkin.this.borderColor.getGreen(), TerraSheetSkin.this.borderColor.getBlue(), 64));
            graphics.fillRect(3, 1, 2, 1);
            graphics.fillRect(0, 4, 2, 1);
            graphics.fillRect(3, 4, 2, 1);
        }
    }

    public class OpenTransition
    extends Transition {
        private int dx;
        private int dy;

        public OpenTransition(boolean reversed) {
            super(TerraSheetSkin.this.stateTransitionDuration, TerraSheetSkin.this.stateTransitionRate, false, reversed);
            this.dx = 0;
            this.dy = 0;
        }

        public void start(TransitionListener transitionListener) {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            sheet.getDecorators().add((Decorator)TerraSheetSkin.this.translationDecorator);
            this.dx = 0;
            this.dy = 0;
            super.start(transitionListener);
        }

        public void stop() {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            sheet.getDecorators().remove((Decorator)TerraSheetSkin.this.translationDecorator);
            super.stop();
        }

        public void update() {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            float scale = this.isReversed() ? TerraSheetSkin.this.easing.easeIn((float)this.getElapsedTime(), 1.0f, -1.0f, (float)this.getDuration()) : TerraSheetSkin.this.easing.easeOut((float)this.getElapsedTime(), 1.0f, -1.0f, (float)this.getDuration());
            Display display = sheet.getDisplay();
            if (display != null) {
                Bounds decoratedBounds = sheet.getDecoratedBounds();
                display.repaint(decoratedBounds.x, decoratedBounds.y, decoratedBounds.width + this.dx, decoratedBounds.height + this.dy);
                Dimensions size = sheet.getPreferredSize();
                switch (TerraSheetSkin.this.slideSource) {
                    case NORTH: {
                        this.dy = -((int)((float)size.height * scale));
                        break;
                    }
                    case EAST: {
                        this.dx = (int)((float)size.width * scale);
                        break;
                    }
                    case SOUTH: {
                        this.dy = (int)((float)size.height * scale);
                        break;
                    }
                    case WEST: {
                        this.dx = -((int)((float)size.width * scale));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("slideSource is null or an unexpected value");
                    }
                }
                TerraSheetSkin.this.translationDecorator.setX(this.dx);
                TerraSheetSkin.this.translationDecorator.setY(this.dy);
                display.repaint(decoratedBounds.x, decoratedBounds.y, decoratedBounds.width + this.dx, decoratedBounds.height + this.dy);
            }
        }
    }

    public static enum SheetPlacement {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

