/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Meter;
import org.apache.pivot.wtk.MeterListener;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMeterSkin
extends ComponentSkin
implements MeterListener {
    private Color fillColor;
    private Color gridColor;
    private float gridFrequency;
    private Font font;
    private Color textColor;
    private Color textFillColor;
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 12;

    public TerraMeterSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.fillColor = theme.getColor(16);
        this.gridColor = theme.getColor(10);
        this.gridFrequency = 0.25f;
        this.font = theme.getFont().deriveFont(1);
        this.textColor = theme.getColor(1);
        this.textFillColor = theme.getColor(4);
    }

    public void install(Component component) {
        super.install(component);
        Meter meter = (Meter)component;
        meter.getMeterListeners().add((Object)this);
    }

    public boolean isFocusable() {
        return false;
    }

    public int getPreferredWidth(int height) {
        int preferredWidth;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            String text = meter.getText();
            if (text != null && text.length() > 0) {
                FontRenderContext fontRenderContext = Platform.getFontRenderContext();
                Rectangle2D stringBounds = this.font.getStringBounds(text, fontRenderContext);
                preferredWidth = (int)Math.ceil(stringBounds.getWidth()) + 2;
            } else {
                preferredWidth = 0;
            }
            preferredWidth = Math.max(preferredWidth, 100);
        } else {
            preferredWidth = this.getPreferredHeight(-1);
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            preferredHeight = this.getPreferredWidth(width);
        } else {
            String text = meter.getText();
            if (text != null && text.length() > 0) {
                FontRenderContext fontRenderContext = Platform.getFontRenderContext();
                LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
                preferredHeight = (int)Math.ceil(lm.getHeight()) + 2;
            } else {
                preferredHeight = 0;
            }
            preferredHeight = Math.max(preferredHeight, 12);
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        Meter meter = (Meter)this.getComponent();
        String text = meter.getText();
        int preferredWidth = 0;
        int preferredHeight = 0;
        if (text != null && text.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D stringBounds = this.font.getStringBounds(text, fontRenderContext);
            preferredWidth = (int)Math.ceil(stringBounds.getWidth()) + 2;
            LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
            preferredHeight = (int)Math.ceil(lm.getHeight()) + 2;
        }
        preferredWidth = Math.max(preferredWidth, 100);
        preferredHeight = Math.max(preferredHeight, 12);
        Dimensions preferredSize = meter.getOrientation() == Orientation.HORIZONTAL ? new Dimensions(preferredWidth, preferredHeight) : new Dimensions(preferredHeight, preferredWidth);
        return preferredSize;
    }

    public int getBaseline(int width, int height) {
        String text;
        int baseline = -1;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL && (text = meter.getText()) != null && text.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
            float ascent = lm.getAscent();
            float textHeight = lm.getHeight();
            baseline = Math.round(((float)height - textHeight) / 2.0f + ascent);
        }
        return baseline;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        Meter meter = (Meter)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            this.drawMeter(meter, graphics, width, height);
        } else {
            graphics.rotate(-1.5707963267948966);
            graphics.translate(-height, 0);
            this.drawMeter(meter, graphics, height, width);
        }
    }

    private void drawMeter(Meter meter, Graphics2D graphics, int width, int height) {
        int meterStop = (int)(meter.getPercentage() * (double)width);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, TerraTheme.brighten(this.fillColor), 0.0f, height, TerraTheme.darken(this.fillColor)));
        graphics.fillRect(0, 0, meterStop, height);
        graphics.setPaint(this.gridColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
        int nLines = (int)Math.ceil(1.0f / this.gridFrequency) - 1;
        float gridSeparation = (float)width * this.gridFrequency;
        for (int i = 0; i < nLines; ++i) {
            int gridX = (int)((float)(i + 1) * gridSeparation);
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)gridX, (int)0, (int)height, (Orientation)Orientation.VERTICAL);
        }
        String text = meter.getText();
        if (text != null && text.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
            float ascent = lm.getAscent();
            Rectangle2D stringBounds = this.font.getStringBounds(text, fontRenderContext);
            float textWidth = (float)stringBounds.getWidth();
            float textHeight = (float)stringBounds.getHeight();
            float textX = ((float)width - textWidth) / 2.0f;
            float textY = ((float)height - textHeight) / 2.0f;
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.getAntiAliasingHint());
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.getFractionalMetricsHint());
            Shape clip = graphics.getClip();
            graphics.clipRect(0, 0, meterStop, height);
            graphics.setPaint(this.textFillColor);
            graphics.setFont(this.font);
            graphics.drawString(meter.getText(), textX, textY + ascent);
            graphics.setClip(clip);
            graphics.clipRect(meterStop, 0, width, height);
            graphics.setPaint(this.textColor);
            graphics.setFont(this.font);
            graphics.drawString(meter.getText(), textX, textY + ascent);
        }
    }

    public Color getColor() {
        return this.fillColor;
    }

    public void setColor(Color color) {
        this.fillColor = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
        this.repaintComponent();
    }

    public final void setGridColor(String gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.setGridColor(GraphicsUtilities.decodeColor((String)gridColor));
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.repaintComponent();
    }

    public final void setTextColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setTextColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public void setTextFillColor(Color color) {
        this.textFillColor = color;
        this.repaintComponent();
    }

    public final void setTextFillColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setTextFillColor(GraphicsUtilities.decodeColor((String)color));
    }

    public float getGridFrequency() {
        return this.gridFrequency;
    }

    public void setGridFrequency(float gridFrequency) {
        if (gridFrequency <= 0.0f || gridFrequency > 1.0f) {
            throw new IllegalArgumentException("gridFrequency must be > 0 and <= 1");
        }
        this.gridFrequency = gridFrequency;
        this.repaintComponent();
    }

    public final void setGridFrequency(Number gridFrequency) {
        if (gridFrequency == null) {
            throw new IllegalArgumentException("gridFrequency is null.");
        }
        this.setGridFrequency(gridFrequency.floatValue());
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMeterSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public void percentageChanged(Meter meter, double previousPercentage) {
        this.repaintComponent();
    }

    public void textChanged(Meter meter, String previousText) {
        this.invalidateComponent();
    }

    public void orientationChanged(Meter meter) {
        this.invalidateComponent();
    }
}

