/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Expander;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ExpanderSkin;
import org.apache.pivot.wtk.skin.terra.TerraLinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraExpanderSkin
extends ExpanderSkin
implements ButtonPressListener {
    private Image collapseImage = new CollapseImage();
    private Image expandImage = new ExpandImage();
    private TablePane titleBarTablePane = null;
    private BoxPane titleBoxPane = null;
    private BoxPane buttonBoxPane = null;
    private Label titleLabel = new Label();
    private ShadeButton shadeButton = null;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color titleBarColor;
    private Color shadeButtonColor;
    private Color disabledShadeButtonColor;
    private Color borderColor;
    private Insets padding;
    private int expandDuration = 250;
    private int expandRate = 30;
    private Color titleBarBevelColor;
    private ExpandTransition expandTransition = null;
    private ClipDecorator clipDecorator = new ClipDecorator();
    private ComponentMouseButtonListener titleBarMouseListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            Expander expander;
            boolean consumed = false;
            if (count == 2 && (expander = (Expander)TerraExpanderSkin.this.getComponent()).isCollapsible()) {
                expander.setExpanded(!expander.isExpanded());
                consumed = true;
            }
            return consumed;
        }
    };
    private static final int DEFAULT_EXPAND_DURATION = 250;
    private static final int DEFAULT_EXPAND_RATE = 30;

    public TerraExpanderSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(4));
        this.titleBarBackgroundColor = theme.getColor(10);
        this.titleBarBorderColor = theme.getColor(7);
        this.titleBarColor = theme.getColor(12);
        this.shadeButtonColor = theme.getColor(12);
        this.disabledShadeButtonColor = theme.getColor(7);
        this.borderColor = theme.getColor(7);
        this.padding = new Insets(4);
        this.titleBarBevelColor = TerraTheme.brighten(this.titleBarBackgroundColor);
        this.titleBarTablePane = new TablePane();
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(3));
        this.titleBarTablePane.getStyles().put("horizontalSpacing", (Object)3);
        TablePane.Row titleRow = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(titleRow);
        this.titleBoxPane = new BoxPane(Orientation.HORIZONTAL);
        this.titleBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.buttonBoxPane = new BoxPane(Orientation.HORIZONTAL);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        titleRow.add((Component)this.titleBoxPane);
        titleRow.add((Component)this.buttonBoxPane);
        this.titleLabel.getStyles().put("color", (Object)this.titleBarColor);
        Font titleFont = theme.getFont().deriveFont(1);
        this.titleLabel.getStyles().put("font", (Object)titleFont);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBarTablePane.getComponentMouseButtonListeners().add((Object)this.titleBarMouseListener);
    }

    public void install(Component component) {
        super.install(component);
        Expander expander = (Expander)component;
        expander.add((Component)this.titleBarTablePane);
        Image buttonData = expander.isExpanded() ? this.collapseImage : this.expandImage;
        this.shadeButton = new ShadeButton(buttonData);
        this.buttonBoxPane.add((Component)this.shadeButton);
        this.shadeButton.getButtonPressListeners().add((Object)this);
        this.titleChanged(expander, null);
        this.collapsibleChanged(expander);
        this.enabledChanged((Component)expander);
    }

    public int getPreferredWidth(int height) {
        Expander expander = (Expander)this.getComponent();
        Component content = expander.getContent();
        int preferredWidth = this.titleBarTablePane.getPreferredWidth(-1);
        if (content != null) {
            int contentHeight = -1;
            if (height >= 0) {
                int reservedHeight = 2 + this.padding.top + this.padding.bottom + this.titleBarTablePane.getPreferredHeight(-1);
                if (expander.isExpanded()) {
                    ++reservedHeight;
                }
                contentHeight = Math.max(height - reservedHeight, 0);
            }
            preferredWidth = Math.max(content.getPreferredWidth(contentHeight) + (this.padding.left + this.padding.right), preferredWidth);
        }
        return preferredWidth += 2;
    }

    public int getPreferredHeight(int width) {
        Expander expander = (Expander)this.getComponent();
        Component content = expander.getContent();
        int preferredHeight = this.titleBarTablePane.getPreferredHeight(-1);
        if (content != null && (expander.isExpanded() || this.expandTransition != null)) {
            ++preferredHeight;
            int contentWidth = -1;
            if (width >= 0) {
                contentWidth = Math.max(width - (2 + this.padding.left + this.padding.right), 0);
            }
            if (this.expandTransition == null) {
                preferredHeight += this.padding.top + this.padding.bottom + content.getPreferredHeight(contentWidth);
            } else {
                float scale = this.expandTransition.getScale();
                preferredHeight += (int)(scale * (float)(this.padding.top + this.padding.bottom + content.getPreferredHeight(contentWidth)));
            }
        }
        return preferredHeight += 2;
    }

    public Dimensions getPreferredSize() {
        Expander expander = (Expander)this.getComponent();
        Component content = expander.getContent();
        Dimensions titleBarSize = this.titleBarTablePane.getPreferredSize();
        int preferredWidth = titleBarSize.width;
        int preferredHeight = titleBarSize.height;
        if (content != null) {
            Dimensions contentSize = content.getPreferredSize();
            preferredWidth = Math.max(contentSize.width + (this.padding.left + this.padding.right), preferredWidth);
            if (expander.isExpanded() || this.expandTransition != null) {
                ++preferredHeight;
                if (this.expandTransition == null) {
                    preferredHeight += this.padding.top + this.padding.bottom + contentSize.height;
                } else {
                    float scale = this.expandTransition.getScale();
                    preferredHeight += (int)(scale * (float)(this.padding.top + this.padding.bottom + contentSize.height));
                }
            }
        }
        return new Dimensions(preferredWidth += 2, preferredHeight += 2);
    }

    public int getBaseline(int width, int height) {
        int titleBarHeight;
        int titleBarWidth;
        Expander expander = (Expander)this.getComponent();
        Component content = expander.getContent();
        int baseline = -1;
        if (content != null && (baseline = this.titleBarTablePane.getBaseline(titleBarWidth = Math.max(width - 2, 0), titleBarHeight = this.titleBarTablePane.getPreferredHeight(-1))) != -1) {
            ++baseline;
        }
        return baseline;
    }

    public void layout() {
        Expander expander = (Expander)this.getComponent();
        Component content = expander.getContent();
        int width = this.getWidth();
        int height = this.getHeight();
        int titleBarHeight = this.titleBarTablePane.getPreferredHeight(-1);
        this.titleBarTablePane.setSize(Math.max(width - 2, 0), titleBarHeight);
        this.titleBarTablePane.setLocation(1, 1);
        if (content != null) {
            int contentWidth = Math.max(width - (2 + this.padding.left + this.padding.right), 0);
            int contentHeight = Math.max(height - (3 + this.padding.top + this.padding.bottom + titleBarHeight), 0);
            this.clipDecorator.setSize(contentWidth, contentHeight);
            content.setSize(contentWidth, content.getPreferredHeight(contentWidth));
            int contentX = 1 + this.padding.left;
            int contentY = 2 + this.padding.top + titleBarHeight;
            content.setLocation(contentX, contentY);
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        int titleBarX = this.titleBarTablePane.getX();
        int titleBarY = this.titleBarTablePane.getY();
        int titleBarWidth = this.titleBarTablePane.getWidth();
        int titleBarHeight = this.titleBarTablePane.getHeight();
        graphics.setPaint(this.titleBarBorderColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)0, (int)(1 + titleBarHeight), (int)width, (Orientation)Orientation.HORIZONTAL);
        graphics.setPaint(new GradientPaint(titleBarX + titleBarWidth / 2, titleBarY, this.titleBarBevelColor, titleBarX + titleBarWidth / 2, titleBarY + titleBarHeight, this.titleBarBackgroundColor));
        graphics.fillRect(titleBarX, titleBarY, titleBarWidth, titleBarHeight);
        graphics.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
    }

    public Font getTitleBarFont() {
        return (Font)this.titleLabel.getStyles().get("font");
    }

    public void setTitleBarFont(Font titleBarFont) {
        this.titleLabel.getStyles().put("font", (Object)titleBarFont);
    }

    public final void setTitleBarFont(String titleBarFont) {
        if (titleBarFont == null) {
            throw new IllegalArgumentException("titleBarFont is null.");
        }
        this.setTitleBarFont(TerraExpanderSkin.decodeFont((String)titleBarFont));
    }

    public final void setTitleBarFont(Dictionary<String, ?> titleBarFont) {
        if (titleBarFont == null) {
            throw new IllegalArgumentException("titleBarFont is null.");
        }
        this.setTitleBarFont(Theme.deriveFont(titleBarFont));
    }

    public Color getTitleBarColor() {
        return this.titleBarColor;
    }

    public void setTitleBarColor(Color titleBarColor) {
        this.titleBarColor = titleBarColor;
        this.titleLabel.getStyles().put("color", (Object)titleBarColor);
    }

    public final void setTitleBarColor(String titleBarColor) {
        if (titleBarColor == null) {
            throw new IllegalArgumentException("titleBarColor is null.");
        }
        this.setTitleBarColor(GraphicsUtilities.decodeColor((String)titleBarColor));
    }

    public Color getTitleBarBackgroundColor() {
        return this.titleBarBackgroundColor;
    }

    public void setTitleBarBackgroundColor(Color titleBarBackgroundColor) {
        this.titleBarBackgroundColor = titleBarBackgroundColor;
        this.titleBarBevelColor = TerraTheme.brighten(titleBarBackgroundColor);
        this.repaintComponent();
    }

    public final void setTitleBarBackgroundColor(String titleBarBackgroundColor) {
        if (titleBarBackgroundColor == null) {
            throw new IllegalArgumentException("titleBarBackgroundColor is null.");
        }
        this.setTitleBarBackgroundColor(GraphicsUtilities.decodeColor((String)titleBarBackgroundColor));
    }

    public Color getTitleBarBorderColor() {
        return this.titleBarBorderColor;
    }

    public void setTitleBarBorderColor(Color titleBarBorderColor) {
        this.titleBarBorderColor = titleBarBorderColor;
        this.repaintComponent();
    }

    public final void setTitleBarBorderColor(String titleBarBorderColor) {
        if (titleBarBorderColor == null) {
            throw new IllegalArgumentException("titleBarBorderColor is null.");
        }
        this.setTitleBarBorderColor(GraphicsUtilities.decodeColor((String)titleBarBorderColor));
    }

    public Color getShadeButtonColor() {
        return this.shadeButtonColor;
    }

    public void setShadeButtonColor(Color shadeButtonColor) {
        this.shadeButtonColor = shadeButtonColor;
        this.repaintComponent();
    }

    public final void setShadeButtonColor(String shadeButtonColor) {
        if (shadeButtonColor == null) {
            throw new IllegalArgumentException("shadeButtonColor is null.");
        }
        this.setShadeButtonColor(GraphicsUtilities.decodeColor((String)shadeButtonColor));
    }

    public Color getDisabledShadeButtonColor() {
        return this.disabledShadeButtonColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public int getExpandDuration() {
        return this.expandDuration;
    }

    public void setExpandDuration(int expandDuration) {
        this.expandDuration = expandDuration;
    }

    public int getExpandRate() {
        return this.expandRate;
    }

    public void setExpandRate(int expandRate) {
        this.expandRate = expandRate;
    }

    public void buttonPressed(Button button) {
        Expander expander = (Expander)this.getComponent();
        if (expander.isCollapsible()) {
            expander.setExpanded(!expander.isExpanded());
        }
    }

    public void enabledChanged(Component component) {
        if (component.isEnabled()) {
            this.titleLabel.getStyles().put("color", (Object)this.titleBarColor);
        } else {
            this.titleLabel.getStyles().put("color", (Object)this.disabledShadeButtonColor);
        }
    }

    public void titleChanged(Expander expander, String previousTitle) {
        String title = expander.getTitle();
        this.titleLabel.setVisible(title != null);
        this.titleLabel.setText(title != null ? title : "");
    }

    public void collapsibleChanged(Expander expander) {
        this.buttonBoxPane.setVisible(expander.isCollapsible());
    }

    public Vote previewExpandedChange(final Expander expander) {
        if (expander.isShowing() && this.expandTransition == null && expander.getContent() != null) {
            final boolean expanded = expander.isExpanded();
            this.shadeButton.setButtonData(expanded ? this.collapseImage : this.expandImage);
            this.expandTransition = new ExpandTransition(expanded);
            this.expandTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    expander.setExpanded(!expanded);
                    TerraExpanderSkin.this.expandTransition = null;
                }
            });
        }
        Vote vote = this.expandTransition == null || !this.expandTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    public void expandedChangeVetoed(Expander expander, Vote reason) {
        if (reason == Vote.DENY && this.expandTransition != null) {
            this.expandTransition.stop();
            this.expandTransition = null;
            this.shadeButton.setButtonData(expander.isExpanded() ? this.collapseImage : this.expandImage);
            this.invalidateComponent();
        }
    }

    public void expandedChanged(Expander expander) {
        this.shadeButton.setButtonData(expander.isExpanded() ? this.collapseImage : this.expandImage);
        this.invalidateComponent();
    }

    public void contentChanged(Expander expander, Component previousContent) {
        if (this.expandTransition != null) {
            this.expandTransition.end();
        }
        this.invalidateComponent();
    }

    protected class ExpandImage
    extends ButtonImage {
        protected ExpandImage() {
        }

        public void paint(Graphics2D graphics) {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            graphics.setStroke(new BasicStroke(0.0f));
            if (expander.isEnabled()) {
                graphics.setPaint(TerraExpanderSkin.this.shadeButtonColor);
            } else {
                graphics.setPaint(TerraExpanderSkin.this.disabledShadeButtonColor);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int[] xPoints = new int[]{3, 6, 9};
            int[] yPoints = new int[]{3, 9, 3};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected class CollapseImage
    extends ButtonImage {
        protected CollapseImage() {
        }

        public void paint(Graphics2D graphics) {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            graphics.setStroke(new BasicStroke(0.0f));
            if (expander.isEnabled()) {
                graphics.setPaint(TerraExpanderSkin.this.shadeButtonColor);
            } else {
                graphics.setPaint(TerraExpanderSkin.this.disabledShadeButtonColor);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int[] xPoints = new int[]{3, 6, 9};
            int[] yPoints = new int[]{9, 3, 9};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected abstract class ButtonImage
    extends Image {
        protected ButtonImage() {
        }

        public int getWidth() {
            return 11;
        }

        public int getHeight() {
            return 11;
        }
    }

    public class ShadeButtonSkin
    extends TerraLinkButtonSkin {
        public boolean isFocusable() {
            return false;
        }
    }

    public class ShadeButton
    extends LinkButton {
        public ShadeButton() {
            this(null);
        }

        public ShadeButton(Object buttonData) {
            super(buttonData);
            this.setSkin((Skin)new ShadeButtonSkin());
            this.setDataRenderer((Button.DataRenderer)new ButtonDataRenderer());
        }
    }

    public class ExpandTransition
    extends Transition {
        private Easing easing;

        public ExpandTransition(boolean reversed) {
            super(TerraExpanderSkin.this.expandDuration, TerraExpanderSkin.this.expandRate, false, reversed);
            this.easing = new Quadratic();
        }

        public float getScale() {
            int elapsedTime = this.getElapsedTime();
            int duration = this.getDuration();
            float scale = this.isReversed() ? this.easing.easeIn((float)elapsedTime, 0.0f, 1.0f, (float)duration) : this.easing.easeOut((float)elapsedTime, 0.0f, 1.0f, (float)duration);
            return scale;
        }

        public void start(TransitionListener transitionListener) {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            Component content = expander.getContent();
            content.getDecorators().add((Decorator)TerraExpanderSkin.this.clipDecorator);
            expander.setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            Component content = expander.getContent();
            content.getDecorators().remove((Decorator)TerraExpanderSkin.this.clipDecorator);
            expander.setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraExpanderSkin.this.invalidateComponent();
        }
    }
}

