/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.skin.ColorChooserSkin;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class TerraColorChooserSkin
extends ColorChooserSkin {
    private TablePane tablePane = new TablePane();
    private SaturationValueChooser saturationValueChooser = new SaturationValueChooser();
    private HueChooser hueChooser = new HueChooser();
    private BufferedImage saturationValueImage = null;
    private BufferedImage hueSpectrumImage = null;
    private boolean updating = false;

    public TerraColorChooserSkin() {
        this.tablePane.getStyles().put("horizontalSpacing", (Object)6);
        this.tablePane.getColumns().add(new TablePane.Column(31, true));
        this.tablePane.getColumns().add(new TablePane.Column(4, true));
        TablePane.Row row = new TablePane.Row(1, true);
        this.tablePane.getRows().add(row);
        row.add((Component)this.saturationValueChooser);
        row.add((Component)this.hueChooser);
    }

    public void install(Component component) {
        super.install(component);
        ColorChooser colorChooser = (ColorChooser)component;
        colorChooser.add((Component)this.tablePane);
        this.selectedColorChanged(colorChooser, null);
    }

    public int getPreferredWidth(int height) {
        return this.tablePane.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        return this.tablePane.getPreferredHeight(width);
    }

    public Dimensions getPreferredSize() {
        return this.tablePane.getPreferredSize();
    }

    public void layout() {
        this.tablePane.setSize(this.getWidth(), this.getHeight());
        this.tablePane.setLocation(0, 0);
        this.saturationValueImage = null;
        this.hueSpectrumImage = null;
    }

    public int getSpacing() {
        return (Integer)this.tablePane.getStyles().get("horizontalSpacing");
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.tablePane.getStyles().put("horizontalSpacing", (Object)spacing);
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.tablePane.getStyles().put("horizontalSpacing", (Object)spacing);
    }

    public void selectedColorChanged(ColorChooser colorChooser, Color previousSelectedColor) {
        this.saturationValueImage = null;
        if (!this.updating) {
            Color color = colorChooser.getSelectedColor();
            float hue = 0.0f;
            float saturation = 0.0f;
            float value = 0.0f;
            if (color != null) {
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                hue = hsb[0];
                saturation = hsb[1];
                value = hsb[2];
            }
            this.hueChooser.setHue(hue);
            this.saturationValueChooser.setSaturation(saturation);
            this.saturationValueChooser.setValue(value);
        }
        this.repaintComponent();
    }

    private class SaturationValueChooserSkin
    extends ComponentSkin {
        private boolean capture = false;

        private SaturationValueChooserSkin() {
        }

        public int getPreferredWidth(int height) {
            return 140;
        }

        public int getPreferredHeight(int width) {
            return 185;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            float hue = TerraColorChooserSkin.this.hueChooser.getHue();
            if (TerraColorChooserSkin.this.saturationValueImage == null) {
                TerraColorChooserSkin.this.saturationValueImage = new BufferedImage(width, height, 2);
                Graphics2D saturationValueImageGraphics = TerraColorChooserSkin.this.saturationValueImage.createGraphics();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Color color = Color.getHSBColor(hue, 1.0f - (float)y / (float)height, (float)x / (float)width);
                        saturationValueImageGraphics.setColor(color);
                        saturationValueImageGraphics.fillRect(x, y, 1, 1);
                    }
                }
                saturationValueImageGraphics.dispose();
            }
            graphics.drawImage((Image)TerraColorChooserSkin.this.saturationValueImage, 0, 0, null);
            if (!this.getComponent().getWindow().isClosing()) {
                float saturation = TerraColorChooserSkin.this.saturationValueChooser.getSaturation();
                float value = TerraColorChooserSkin.this.saturationValueChooser.getValue();
                graphics.setColor(Color.WHITE);
                graphics.setXORMode(Color.getHSBColor(hue, 0.0f, 0.0f));
                graphics.fillRect(0, Math.min((int)((float)height * (1.0f - saturation)), height - 1), width, 1);
                graphics.fillRect(Math.min((int)((float)width * value), width - 1), 0, 1, height);
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if (this.capture && Mouse.getCapturer() != component) {
                Mouse.capture((Component)component);
            }
            if (Mouse.getCapturer() == component) {
                this.setSelectedColor(x, y);
            }
            return consumed;
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            if (Mouse.getCapturer() != component) {
                this.capture = false;
            }
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                this.setSelectedColor(x, y);
                this.capture = true;
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                this.capture = false;
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                }
            }
            return consumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectedColor(int x, int y) {
            ColorChooser colorChooser = (ColorChooser)TerraColorChooserSkin.this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            float hue = TerraColorChooserSkin.this.hueChooser.getHue();
            float saturation = 1.0f - (float)Math.min(Math.max(y, 0), height - 1) / (float)height;
            float value = (float)Math.min(Math.max(x, 0), width - 1) / (float)width;
            TerraColorChooserSkin.this.saturationValueChooser.setSaturation(saturation);
            TerraColorChooserSkin.this.saturationValueChooser.setValue(value);
            TerraColorChooserSkin.this.updating = true;
            try {
                colorChooser.setSelectedColor(Color.getHSBColor(hue, saturation, value));
            }
            finally {
                TerraColorChooserSkin.this.updating = false;
            }
        }
    }

    private class SaturationValueChooser
    extends Component {
        private float saturation = 0.0f;
        private float value = 0.0f;

        public SaturationValueChooser() {
            this.setSkin((Skin)new SaturationValueChooserSkin());
        }

        public float getSaturation() {
            return this.saturation;
        }

        public void setSaturation(float saturation) {
            this.saturation = saturation;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }
    }

    private class HueChooserSkin
    extends ComponentSkin {
        private boolean capture = false;

        private HueChooserSkin() {
        }

        public int getPreferredWidth(int height) {
            return 18;
        }

        public int getPreferredHeight(int width) {
            return 185;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (TerraColorChooserSkin.this.hueSpectrumImage == null) {
                TerraColorChooserSkin.this.hueSpectrumImage = new BufferedImage(width, height, 2);
                Graphics2D hueSpectrumImageGraphics = TerraColorChooserSkin.this.hueSpectrumImage.createGraphics();
                for (int y = 0; y < height; ++y) {
                    Color color = Color.getHSBColor(1.0f - (float)y / (float)height, 1.0f, 1.0f);
                    hueSpectrumImageGraphics.setColor(color);
                    hueSpectrumImageGraphics.fillRect(0, y, width, 1);
                }
                hueSpectrumImageGraphics.dispose();
            }
            graphics.drawImage((Image)TerraColorChooserSkin.this.hueSpectrumImage, 0, 0, null);
            float hue = TerraColorChooserSkin.this.hueChooser.getHue();
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, Math.min((int)((float)height * (1.0f - hue)), height - 1), width, 1);
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if (this.capture && Mouse.getCapturer() != component) {
                Mouse.capture((Component)component);
            }
            if (Mouse.getCapturer() == component) {
                this.setSelectedColor(y);
            }
            return consumed;
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            if (Mouse.getCapturer() != component) {
                this.capture = false;
            }
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                this.setSelectedColor(y);
                this.capture = true;
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                this.capture = false;
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                }
            }
            return consumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectedColor(int y) {
            ColorChooser colorChooser = (ColorChooser)TerraColorChooserSkin.this.getComponent();
            int height = this.getHeight();
            float hue = 1.0f - (float)Math.min(Math.max(y, 0), height - 1) / (float)height;
            float saturation = TerraColorChooserSkin.this.saturationValueChooser.getSaturation();
            float value = TerraColorChooserSkin.this.saturationValueChooser.getValue();
            TerraColorChooserSkin.this.hueChooser.setHue(hue);
            TerraColorChooserSkin.this.updating = true;
            try {
                colorChooser.setSelectedColor(Color.getHSBColor(hue, saturation, value));
            }
            finally {
                TerraColorChooserSkin.this.updating = false;
            }
        }
    }

    private class HueChooser
    extends Component {
        private float hue = 0.0f;

        public HueChooser() {
            this.setSkin((Skin)new HueChooserSkin());
        }

        public float getHue() {
            return this.hue;
        }

        public void setHue(float hue) {
            this.hue = hue;
        }
    }
}

