/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.CheckboxSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraCheckboxSkin
extends CheckboxSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private int spacing;
    private Color buttonColor;
    private Color buttonBorderColor;
    private Color buttonSelectionColor;
    private Color disabledButtonColor;
    private Color disabledButtonBorderColor;
    private Color disabledButtonSelectionColor;
    private static final int CHECKBOX_SIZE = 14;
    private static final int CHECKMARK_SIZE = 10;

    public TerraCheckboxSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.spacing = 3;
        this.buttonColor = theme.getColor(4);
        this.buttonBorderColor = theme.getColor(7);
        this.buttonSelectionColor = theme.getColor(15);
        this.disabledButtonColor = theme.getColor(3);
        this.disabledButtonBorderColor = theme.getColor(7);
        this.disabledButtonSelectionColor = theme.getColor(7);
    }

    public int getPreferredWidth(int height) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        int preferredWidth = 14;
        Object buttonData = checkbox.getButtonData();
        if (buttonData != null) {
            dataRenderer.render(buttonData, (Button)checkbox, false);
            preferredWidth += dataRenderer.getPreferredWidth(height) + this.spacing * 2;
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        int preferredHeight = 14;
        Object buttonData = checkbox.getButtonData();
        if (buttonData != null) {
            if (width != -1) {
                width = Math.max(width - (14 + this.spacing), 0);
            }
            dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
            preferredHeight = Math.max(preferredHeight, dataRenderer.getPreferredHeight(width));
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
        int preferredWidth = 14;
        int preferredHeight = 14;
        Object buttonData = checkbox.getButtonData();
        if (buttonData != null) {
            dataRenderer.render(buttonData, (Button)checkbox, false);
            preferredWidth += dataRenderer.getPreferredWidth(-1) + this.spacing * 2;
            preferredHeight = Math.max(preferredHeight, dataRenderer.getPreferredHeight(-1));
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        int baseline = -1;
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
        int clientWidth = Math.max(width - (14 + this.spacing), 0);
        baseline = dataRenderer.getBaseline(clientWidth, height);
        return baseline;
    }

    public void paint(Graphics2D graphics) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int offset = (height - 14) / 2;
        graphics.translate(0, offset);
        this.paintButton(graphics, checkbox.isEnabled(), checkbox.getState());
        graphics.translate(0, -offset);
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        Object buttonData = checkbox.getButtonData();
        dataRenderer.render(buttonData, (Button)checkbox, false);
        dataRenderer.setSize(Math.max(width - (14 + this.spacing * 2), 0), height);
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(14 + this.spacing, 0);
        contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        if (checkbox.isFocused()) {
            if (buttonData == null) {
                Color focusColor = new Color(this.buttonSelectionColor.getRed(), this.buttonSelectionColor.getGreen(), this.buttonSelectionColor.getBlue(), 68);
                graphics.setColor(focusColor);
                graphics.fillRect(0, 0, 14, 14);
            } else {
                BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
                graphics.setStroke(dashStroke);
                graphics.setColor(this.buttonBorderColor);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle2D.Double focusRectangle = new Rectangle2D.Double(15.0, 0.5, dataRenderer.getWidth() + this.spacing * 2 - 2, dataRenderer.getHeight() - 1);
                graphics.draw(focusRectangle);
            }
        }
    }

    private void paintButton(Graphics2D graphics, boolean enabled, Button.State state) {
        Color buttonSelectionColorLocal;
        Color buttonBorderColorLocal;
        Paint buttonPaint;
        if (enabled) {
            buttonPaint = new GradientPaint(7.0f, 0.0f, TerraTheme.darken(this.buttonColor), 7.0f, 14.0f, this.buttonColor);
            buttonBorderColorLocal = this.buttonBorderColor;
            buttonSelectionColorLocal = this.buttonSelectionColor;
        } else {
            buttonPaint = this.disabledButtonColor;
            buttonBorderColorLocal = this.disabledButtonBorderColor;
            buttonSelectionColorLocal = this.disabledButtonSelectionColor;
        }
        graphics.setPaint(buttonPaint);
        graphics.fillRect(0, 0, 14, 14);
        graphics.setPaint(buttonBorderColorLocal);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)14, (int)14);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (state == Button.State.SELECTED) {
            graphics.setColor(buttonSelectionColorLocal);
            graphics.setStroke(new BasicStroke(2.5f));
            int n = 5;
            int m = 2;
            int offsetX = (14 - (n + m)) / 2;
            int offsetY = (14 - n) / 2;
            graphics.drawLine(offsetX, n - m + offsetY, m + offsetX, n + offsetY);
            graphics.drawLine(m + offsetX, n + offsetY, m + n + offsetX, offsetY);
        } else if (state == Button.State.MIXED) {
            graphics.setColor(buttonSelectionColorLocal);
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)4, (int)6, (int)6, (Orientation)Orientation.HORIZONTAL, (int)2);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraCheckboxSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }
}

