/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ActivityIndicatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraActivityIndicatorSkin
extends ActivityIndicatorSkin {
    private Color[] colors;
    private Color backgroundColor;
    private int angle = 0;
    private ApplicationContext.ScheduledCallback updateCallback = null;

    public TerraActivityIndicatorSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(2));
        this.backgroundColor = null;
    }

    public int getPreferredWidth(int height) {
        return 128;
    }

    public int getPreferredHeight(int width) {
        return 128;
    }

    public void paint(Graphics2D graphics) {
        ActivityIndicator activityIndicator = (ActivityIndicator)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        if (activityIndicator.isActive()) {
            float scale;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (width > height) {
                graphics.translate((width - height) / 2, 0);
                scale = (float)height / 128.0f;
                graphics.scale(scale, scale);
            } else {
                graphics.translate(0, (height - width) / 2);
                scale = (float)width / 128.0f;
                graphics.scale(scale, scale);
            }
            graphics.translate(64, 64);
            graphics.rotate(Math.PI / 180 * (double)this.angle);
            double increment = 0.5235987755982988;
            for (int i = 0; i < 12; ++i) {
                graphics.setColor(this.colors[i]);
                graphics.fillRoundRect(24, -4, 32, 8, 8, 8);
                graphics.rotate(0.5235987755982988);
            }
        }
    }

    public Color getColor() {
        return this.colors[0];
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.colors = new Color[12];
        for (int i = 0; i < 12; ++i) {
            float alpha = 255.0f * (float)i / 12.0f;
            this.colors[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)alpha);
        }
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public void activeChanged(ActivityIndicator activityIndicator) {
        if (activityIndicator.isActive()) {
            this.updateCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    TerraActivityIndicatorSkin.this.angle = (TerraActivityIndicatorSkin.this.angle + 30) % 360;
                    TerraActivityIndicatorSkin.this.repaintComponent();
                }
            }, (long)100L);
        } else {
            this.updateCallback.cancel();
            this.updateCallback = null;
            this.repaintComponent();
        }
    }
}

