/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.apache.pivot.web.Query;
import org.apache.pivot.web.QueryException;

public class PostQuery
extends Query<URL> {
    private Object value = null;
    public static final Query.Method METHOD = Query.Method.POST;

    public PostQuery(String hostname, String path) {
        this(hostname, -1, path, false);
    }

    public PostQuery(String hostname, int port, String path, boolean secure) {
        this(hostname, port, path, secure, DEFAULT_EXECUTOR_SERVICE);
    }

    public PostQuery(String hostname, int port, String path, boolean secure, ExecutorService executorService) {
        super(hostname, port, path, secure, executorService);
    }

    @Override
    public Query.Method getMethod() {
        return METHOD;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public URL execute() throws QueryException {
        String location;
        URL valueLocation = null;
        this.execute(METHOD, this.value);
        if (this.getStatus() == 201 && (location = this.getResponseHeaders().get("Location")) != null) {
            try {
                valueLocation = new URL(this.getLocation(), location);
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception);
            }
        }
        return valueLocation;
    }
}

