/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;

public final class QueryDictionary
implements Dictionary<String, String>,
Iterable<String> {
    private boolean caseSensitiveKeys;
    private HashMap<String, ArrayList<String>> map = new HashMap();

    public QueryDictionary(boolean caseSensitiveKeys) {
        this.caseSensitiveKeys = caseSensitiveKeys;
    }

    public String get(String key) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) != null && list.getLength() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public String get(String key, int index) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return (String)list.get(index);
    }

    public String put(String key, String value) {
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        ArrayList list = new ArrayList();
        list.add((Object)value);
        ArrayList previous = (ArrayList)this.map.put((Object)key, (Object)list);
        if (previous != null && previous.getLength() > 0) {
            return (String)previous.get(0);
        }
        return null;
    }

    public int add(String key, String value) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) == null) {
            this.put(key, value);
            return 0;
        }
        list.add((Object)value);
        return list.getLength() - 1;
    }

    public void insert(String key, String value, int index) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        list.insert((Object)value, index);
    }

    public String remove(String key) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.remove((Object)key)) != null && list.getLength() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public String remove(String key, int index) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return (String)list.get(index);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(String key) {
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        return this.map.containsKey((Object)key);
    }

    public int getLength(String key) {
        ArrayList list;
        if (!this.caseSensitiveKeys) {
            key = key.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)key)) == null) {
            return 0;
        }
        return list.getLength();
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.iterator();
    }
}

