/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class NonAggregationGroupByToDistinctQueryRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        boolean hasAggregation = false;
        for (Expression select : pinotQuery.getSelectList()) {
            if (!CalciteSqlParser.isAggregateExpression(select)) continue;
            hasAggregation = true;
        }
        if (pinotQuery.getOrderByList() != null) {
            for (Expression orderBy : pinotQuery.getOrderByList()) {
                if (!CalciteSqlParser.isAggregateExpression(orderBy)) continue;
                hasAggregation = true;
            }
        }
        if (!hasAggregation && pinotQuery.getGroupByListSize() > 0) {
            Set<String> selectIdentifiers = CalciteSqlParser.extractIdentifiers(pinotQuery.getSelectList(), true);
            Set<String> groupByIdentifiers = CalciteSqlParser.extractIdentifiers(pinotQuery.getGroupByList(), true);
            if (groupByIdentifiers.containsAll(selectIdentifiers)) {
                Expression distinctExpression = RequestUtils.getFunctionExpression("distinct");
                for (Expression select : pinotQuery.getSelectList()) {
                    distinctExpression.getFunctionCall().addToOperands(select);
                }
                pinotQuery.setSelectList(Arrays.asList(distinctExpression));
                pinotQuery.setGroupByList(Collections.emptyList());
            } else {
                selectIdentifiers.removeAll(groupByIdentifiers);
                throw new SqlCompilationException(String.format("For non-aggregation group by query, all the identifiers in select clause should be in groupBys. Found identifier: %s", Arrays.toString(selectIdentifiers.toArray(new String[0]))));
            }
        }
        return pinotQuery;
    }
}

