/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.SegmentName;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LLCSegmentName
extends SegmentName
implements Comparable {
    private static final String DATE_FORMAT = "yyyyMMdd'T'HHmm'Z'";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmm'Z'").withZoneUTC();
    private final String _tableName;
    private final int _partitionGroupId;
    private final int _sequenceNumber;
    private final String _creationTime;
    private final String _segmentName;

    public LLCSegmentName(String segmentName) {
        String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)"__");
        Preconditions.checkArgument((parts.length == 4 ? 1 : 0) != 0, (String)"Invalid LLC segment name: %s", (Object)segmentName);
        this._tableName = parts[0];
        this._partitionGroupId = Integer.parseInt(parts[1]);
        this._sequenceNumber = Integer.parseInt(parts[2]);
        this._creationTime = parts[3];
        this._segmentName = segmentName;
    }

    public LLCSegmentName(String tableName, int partitionGroupId, int sequenceNumber, long msSinceEpoch) {
        if (!this.isValidComponentName(tableName)) {
            throw new RuntimeException("Invalid table name " + tableName);
        }
        this._tableName = tableName;
        this._partitionGroupId = partitionGroupId;
        this._sequenceNumber = sequenceNumber;
        this._creationTime = DATE_FORMATTER.print(msSinceEpoch);
        this._segmentName = tableName + "__" + partitionGroupId + "__" + sequenceNumber + "__" + this._creationTime;
    }

    private LLCSegmentName(String tableName, int partitionGroupId, int sequenceNumber, String creationTime, String segmentName) {
        this._tableName = tableName;
        this._partitionGroupId = partitionGroupId;
        this._sequenceNumber = sequenceNumber;
        this._creationTime = creationTime;
        this._segmentName = segmentName;
    }

    @Nullable
    public static LLCSegmentName of(String segmentName) {
        String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)"__");
        if (parts.length != 4) {
            return null;
        }
        return new LLCSegmentName(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), parts[3], segmentName);
    }

    public static int getSequenceNumber(String segmentName) {
        return Integer.parseInt(StringUtils.splitByWholeSeparator((String)segmentName, (String)"__")[2]);
    }

    @Override
    public SegmentName.RealtimeSegmentType getSegmentType() {
        return SegmentName.RealtimeSegmentType.LLC;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public int getPartitionGroupId() {
        return this._partitionGroupId;
    }

    @Override
    public String getPartitionRange() {
        return Integer.toString(this.getPartitionGroupId());
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public String getCreationTime() {
        return this._creationTime;
    }

    public long getCreationTimeMs() {
        DateTime dateTime = DATE_FORMATTER.parseDateTime(this._creationTime);
        return dateTime.getMillis();
    }

    @Override
    public String getSegmentName() {
        return this._segmentName;
    }

    @Override
    public String getSequenceNumberStr() {
        return Integer.toString(this._sequenceNumber);
    }

    public int compareTo(Object o) {
        LLCSegmentName other = (LLCSegmentName)o;
        if (!this.getTableName().equals(other.getTableName())) {
            throw new RuntimeException("Cannot compare segment names " + this.getSegmentName() + " and " + other.getSegmentName());
        }
        if (this.getPartitionGroupId() > other.getPartitionGroupId()) {
            return 1;
        }
        if (this.getPartitionGroupId() < other.getPartitionGroupId()) {
            return -1;
        }
        if (this.getSequenceNumber() > other.getSequenceNumber()) {
            return 1;
        }
        if (this.getSequenceNumber() < other.getSequenceNumber()) {
            return -1;
        }
        if (!this.getCreationTime().equals(other.getCreationTime())) {
            throw new RuntimeException("Cannot compare segment names " + this.getSegmentName() + " and " + other.getSegmentName());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLCSegmentName that = (LLCSegmentName)o;
        return this._segmentName.equals(that._segmentName);
    }

    public int hashCode() {
        return Objects.hash(this._segmentName);
    }

    public String toString() {
        return this.getSegmentName();
    }
}

