/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import javax.annotation.Nullable;
import org.apache.helix.AccessOption;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.zookeeper.data.Stat;

public final class MinionTaskMetadataUtils {
    private MinionTaskMetadataUtils() {
    }

    @Nullable
    public static ZNRecord fetchTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(tableNameWithType, taskType);
        if (propertyStore.exists(newPath, AccessOption.PERSISTENT)) {
            return MinionTaskMetadataUtils.fetchTaskMetadata(propertyStore, newPath);
        }
        return MinionTaskMetadataUtils.fetchTaskMetadata(propertyStore, ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, tableNameWithType));
    }

    @Nullable
    private static ZNRecord fetchTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String path) {
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    public static void deleteTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(tableNameWithType, taskType);
        String oldPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, tableNameWithType);
        boolean newPathDeleted = propertyStore.remove(newPath, AccessOption.PERSISTENT);
        boolean oldPathDeleted = propertyStore.remove(oldPath, AccessOption.PERSISTENT);
        if (!newPathDeleted || !oldPathDeleted) {
            throw new ZkException("Failed to delete task metadata: " + taskType + ", " + tableNameWithType);
        }
    }

    public static void persistTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, BaseTaskMetadata taskMetadata, int expectedVersion) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskMetadata.getTableNameWithType(), taskType);
        String oldPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, taskMetadata.getTableNameWithType());
        if (propertyStore.exists(newPath, AccessOption.PERSISTENT) || !propertyStore.exists(oldPath, AccessOption.PERSISTENT)) {
            MinionTaskMetadataUtils.persistTaskMetadata(newPath, propertyStore, taskType, taskMetadata, expectedVersion);
        } else {
            MinionTaskMetadataUtils.persistTaskMetadata(oldPath, propertyStore, taskType, taskMetadata, expectedVersion);
        }
    }

    private static void persistTaskMetadata(String path, HelixPropertyStore<ZNRecord> propertyStore, String taskType, BaseTaskMetadata taskMetadata, int expectedVersion) {
        if (!propertyStore.set(path, (Object)taskMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to persist minion metadata for task: " + taskType + " and metadata: " + taskMetadata);
        }
    }
}

