/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentPartitionMetadata {
    public static final int INVALID_NUM_PARTITIONS = -1;
    private final Map<String, ColumnPartitionMetadata> _columnPartitionMap;

    public SegmentPartitionMetadata(@Nonnull @JsonProperty(value="columnPartitionMap") Map<String, ColumnPartitionMetadata> columnPartitionMap) {
        Preconditions.checkNotNull(columnPartitionMap);
        this._columnPartitionMap = columnPartitionMap;
    }

    public Map<String, ColumnPartitionMetadata> getColumnPartitionMap() {
        return this._columnPartitionMap;
    }

    @Nullable
    public String getFunctionName(@Nonnull String column) {
        ColumnPartitionMetadata columnPartitionMetadata = this._columnPartitionMap.get(column);
        return columnPartitionMetadata != null ? columnPartitionMetadata.getFunctionName() : null;
    }

    public static SegmentPartitionMetadata fromJsonString(String jsonString) throws IOException {
        return (SegmentPartitionMetadata)JsonUtils.stringToObject((String)jsonString, SegmentPartitionMetadata.class);
    }

    public String toJsonString() throws IOException {
        return JsonUtils.objectToString((Object)this);
    }

    public int getNumPartitions(String column) {
        ColumnPartitionMetadata columnPartitionMetadata = this._columnPartitionMap.get(column);
        return columnPartitionMetadata != null ? columnPartitionMetadata.getNumPartitions() : -1;
    }

    public Set<Integer> getPartitions(String column) {
        ColumnPartitionMetadata columnPartitionMetadata = this._columnPartitionMap.get(column);
        return columnPartitionMetadata != null ? columnPartitionMetadata.getPartitions() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPartitionMetadata that = (SegmentPartitionMetadata)o;
        return this._columnPartitionMap.equals(that._columnPartitionMap);
    }

    public int hashCode() {
        return this._columnPartitionMap != null ? this._columnPartitionMap.hashCode() : 0;
    }
}

