/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.helix.model.Message;

public class TableDeletionMessage
extends Message {
    public static final String DELETE_TABLE_MSG_SUB_TYPE = "DELETE_TABLE";

    public TableDeletionMessage(@Nonnull String tableNameWithType) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableNameWithType);
        this.setMsgSubType(DELETE_TABLE_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
    }

    public TableDeletionMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument((boolean)msgSubType.equals(DELETE_TABLE_MSG_SUB_TYPE), (Object)("Invalid message sub type: " + msgSubType + " for TableDeletionMessage"));
    }
}

