/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.assignment;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixManager;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class InstancePartitionsUtils {
    public static final char TYPE_SUFFIX_SEPARATOR = '_';

    private InstancePartitionsUtils() {
    }

    public static String getInstancePartitionsName(String tableName, String instancePartitionsType) {
        return TableNameBuilder.extractRawTableName((String)tableName) + '_' + instancePartitionsType;
    }

    public static InstancePartitions fetchOrComputeInstancePartitions(HelixManager helixManager, TableConfig tableConfig, InstancePartitionsType instancePartitionsType) {
        String tableNameWithType = tableConfig.getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        if (TableConfigUtils.hasPreConfiguredInstancePartitions(tableConfig, instancePartitionsType)) {
            return InstancePartitionsUtils.fetchInstancePartitionsWithRename((HelixPropertyStore<ZNRecord>)helixManager.getHelixPropertyStore(), (String)tableConfig.getInstancePartitionsMap().get(instancePartitionsType), instancePartitionsType.getInstancePartitionsName(rawTableName));
        }
        ZkHelixPropertyStore propertyStore = helixManager.getHelixPropertyStore();
        InstancePartitions instancePartitions = InstancePartitionsUtils.fetchInstancePartitions((HelixPropertyStore<ZNRecord>)propertyStore, InstancePartitionsUtils.getInstancePartitionsName(tableNameWithType, instancePartitionsType.toString()));
        if (instancePartitions != null) {
            return instancePartitions;
        }
        return InstancePartitionsUtils.computeDefaultInstancePartitions(helixManager, tableConfig, instancePartitionsType);
    }

    @Nullable
    public static InstancePartitions fetchInstancePartitions(HelixPropertyStore<ZNRecord> propertyStore, String instancePartitionsName) {
        String path = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(instancePartitionsName);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, null, AccessOption.PERSISTENT);
        return znRecord != null ? InstancePartitions.fromZNRecord(znRecord) : null;
    }

    public static InstancePartitions fetchInstancePartitionsWithRename(HelixPropertyStore<ZNRecord> propertyStore, String instancePartitionsName, String newName) {
        InstancePartitions instancePartitions = InstancePartitionsUtils.fetchInstancePartitions(propertyStore, instancePartitionsName);
        Preconditions.checkNotNull((Object)instancePartitions, (Object)String.format("Couldn't find instance-partitions with name=%s. Cannot rename to %s", instancePartitionsName, newName));
        return instancePartitions.withName(newName);
    }

    public static InstancePartitions computeDefaultInstancePartitions(HelixManager helixManager, TableConfig tableConfig, InstancePartitionsType instancePartitionsType) {
        String serverTag;
        TenantConfig tenantConfig = tableConfig.getTenantConfig();
        switch (instancePartitionsType) {
            case OFFLINE: {
                serverTag = TagNameUtils.extractOfflineServerTag(tenantConfig);
                break;
            }
            case CONSUMING: {
                serverTag = TagNameUtils.extractConsumingServerTag(tenantConfig);
                break;
            }
            case COMPLETED: {
                serverTag = TagNameUtils.extractCompletedServerTag(tenantConfig);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return InstancePartitionsUtils.computeDefaultInstancePartitionsForTag(helixManager, tableConfig.getTableName(), instancePartitionsType.toString(), serverTag);
    }

    public static InstancePartitions computeDefaultInstancePartitionsForTag(HelixManager helixManager, String tableNameWithType, String instancePartitionsType, String serverTag) {
        List<String> instances = HelixHelper.getInstancesWithTag(helixManager, serverTag);
        int numInstances = instances.size();
        Preconditions.checkState((numInstances > 0 ? 1 : 0) != 0, (String)"No instance found with tag: %s", (Object)serverTag);
        instances.sort(null);
        Collections.rotate(instances, -(Math.abs(tableNameWithType.hashCode()) % numInstances));
        InstancePartitions instancePartitions = new InstancePartitions(InstancePartitionsUtils.getInstancePartitionsName(tableNameWithType, instancePartitionsType));
        instancePartitions.setInstances(0, 0, instances);
        return instancePartitions;
    }

    public static void persistInstancePartitions(HelixPropertyStore<ZNRecord> propertyStore, InstancePartitions instancePartitions) {
        String path = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(instancePartitions.getInstancePartitionsName());
        if (!propertyStore.set(path, (Object)instancePartitions.toZNRecord(), AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to persist instance partitions: " + instancePartitions);
        }
    }

    public static void removeInstancePartitions(HelixPropertyStore<ZNRecord> propertyStore, String instancePartitionsName) {
        String path = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(instancePartitionsName);
        if (!propertyStore.remove(path, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to remove instance partitions: " + instancePartitionsName);
        }
    }
}

