/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.assignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstancePartitions {
    private static final char PARTITION_REPLICA_GROUP_SEPARATOR = '_';
    private final String _instancePartitionsName;
    private final Map<String, List<String>> _partitionToInstancesMap;
    private int _numPartitions;
    private int _numReplicaGroups;

    public InstancePartitions(String instancePartitionsName) {
        this._instancePartitionsName = instancePartitionsName;
        this._partitionToInstancesMap = new TreeMap<String, List<String>>();
    }

    @JsonCreator
    private InstancePartitions(@JsonProperty(value="instancePartitionsName", required=true) String instancePartitionsName, @JsonProperty(value="partitionToInstancesMap", required=true) Map<String, List<String>> partitionToInstancesMap) {
        this._instancePartitionsName = instancePartitionsName;
        this._partitionToInstancesMap = partitionToInstancesMap;
        for (String key : partitionToInstancesMap.keySet()) {
            int separatorIndex = key.indexOf(95);
            int partitionId = Integer.parseInt(key.substring(0, separatorIndex));
            int replicaGroupId = Integer.parseInt(key.substring(separatorIndex + 1));
            this._numPartitions = Integer.max(this._numPartitions, partitionId + 1);
            this._numReplicaGroups = Integer.max(this._numReplicaGroups, replicaGroupId + 1);
        }
    }

    @JsonProperty
    public String getInstancePartitionsName() {
        return this._instancePartitionsName;
    }

    @JsonProperty
    public Map<String, List<String>> getPartitionToInstancesMap() {
        return this._partitionToInstancesMap;
    }

    @JsonIgnore
    public int getNumPartitions() {
        return this._numPartitions;
    }

    @JsonIgnore
    public int getNumReplicaGroups() {
        return this._numReplicaGroups;
    }

    public List<String> getInstances(int partitionId, int replicaGroupId) {
        return this._partitionToInstancesMap.get(Integer.toString(partitionId) + '_' + replicaGroupId);
    }

    public void setInstances(int partitionId, int replicaGroupId, List<String> instances) {
        String key = Integer.toString(partitionId) + '_' + replicaGroupId;
        this._partitionToInstancesMap.put(key, instances);
        this._numPartitions = Integer.max(this._numPartitions, partitionId + 1);
        this._numReplicaGroups = Integer.max(this._numReplicaGroups, replicaGroupId + 1);
    }

    public static InstancePartitions fromZNRecord(ZNRecord znRecord) {
        return new InstancePartitions(znRecord.getId(), znRecord.getListFields());
    }

    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._instancePartitionsName);
        znRecord.setListFields(this._partitionToInstancesMap);
        return znRecord;
    }

    public InstancePartitions withName(String newName) {
        return new InstancePartitions(newName, this.getPartitionToInstancesMap());
    }

    public String toJsonString() {
        try {
            return JsonUtils.objectToString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.toJsonString();
    }
}

