/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.common.request.context.predicate;

import org.apache.pinot.common.request.context.ExpressionContext;


/**
 * Abstract predicate with left-hand side expression
 */
public abstract class BasePredicate implements Predicate {

  protected ExpressionContext _lhs;

  public BasePredicate(ExpressionContext lhs) {
    _lhs = lhs;
  }

  @Override
  public ExpressionContext getLhs() {
    return _lhs;
  }

  @Override
  public void setLhs(ExpressionContext lhs) {
    _lhs = lhs;
  }
}
