/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.pattern.RetrySupport$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$LogLevels$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.RestartSettings;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogicWithLogging;
import org.apache.pekko.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug!B\u000f\u001f\u0003\u0013I\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AQ\u000b\u0001B\u0001B\u0003%a\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0004c\u0001\u0001\u0007I\u0011A2\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\"1a\u000e\u0001Q!\n\u0011Dqa\u001c\u0001A\u0002\u0013\u0005\u0001\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0001>\t\rq\u0004\u0001\u0015)\u0003r\u0011\u001di\b\u00011A\u0005\u0002yD\u0001b \u0001A\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003W\u0011\u001d\t9\u0001\u0001C)\u0003\u0013Aq!!\t\u0001\r#\t\u0019\u0003C\u0004\u0002&\u00011\t\"a\t\t\r\u0005\u001d\u0002\u0001\"\u0003\u007f\u0011\u001d\tI\u0003\u0001C\u000b\u0003WAq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u0013\u0005M\u0005!%A\u0005\n\u0005U\u0005bBAV\u0001\u0011U\u0011Q\u0016\u0005\b\u0003\u000b\u0004AQCAd\u0011\u001d\tI\r\u0001C\u000b\u0003GAq!a3\u0001\t#\ni\rC\u0004\u0002T\u0002!\t%a\t\u0003/I+7\u000f^1si^KG\u000f\u001b\"bG.|gM\u001a'pO&\u001c'BA\u0010!\u0003!\u00198-\u00197bINd'BA\u0011#\u0003\u0019\u0019HO]3b[*\u00111\u0005J\u0001\u0006a\u0016\\7n\u001c\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005)\u00125C\u0001\u0001,!\tas&D\u0001.\u0015\tq\u0003%A\u0003ti\u0006<W-\u0003\u00021[\tyB+[7fe\u001e\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000e<\u0016\u000e\u001e5M_\u001e<\u0017N\\4\u0002\t9\fW.\u001a\t\u0003gqr!\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]B\u0013A\u0002\u001fs_>$hHC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004(\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e9\u0003\u0015\u0019\b.\u00199f!\t\t%\t\u0004\u0001\u0005\u000b\r\u0003!\u0019\u0001#\u0003\u0003M\u000b\"!R%\u0011\u0005\u0019;U\"\u0001\u001d\n\u0005!C$a\u0002(pi\"Lgn\u001a\t\u0003\u0015.k\u0011\u0001I\u0005\u0003\u0019\u0002\u0012Qa\u00155ba\u0016\f1#\u001b8iKJLG/\u001a3BiR\u0014\u0018NY;uKN\u0004\"AS(\n\u0005A\u0003#AC!uiJL'-\u001e;fg\u0006A1/\u001a;uS:<7\u000f\u0005\u0002K'&\u0011A\u000b\t\u0002\u0010%\u0016\u001cH/\u0019:u'\u0016$H/\u001b8hg\u0006qqN\u001c7z\u001f:4\u0015-\u001b7ve\u0016\u001c\bC\u0001$X\u0013\tA\u0006HA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0019YVLX0aCB\u0019A\f\u0001!\u000e\u0003yAQ!\r\u0004A\u0002IBQa\u0010\u0004A\u0002\u0001CQ!\u0014\u0004A\u00029CQ!\u0015\u0004A\u0002ICQ!\u0016\u0004A\u0002Y\u000bAB]3ti\u0006\u0014HoQ8v]R,\u0012\u0001\u001a\t\u0003\r\u0016L!A\u001a\u001d\u0003\u0007%sG/\u0001\tsKN$\u0018M\u001d;D_VtGo\u0018\u0013fcR\u0011\u0011\u000e\u001c\t\u0003\r*L!a\u001b\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b[\"\t\t\u00111\u0001e\u0003\rAH%M\u0001\u000ee\u0016\u001cH/\u0019:u\u0007>,h\u000e\u001e\u0011\u0002\u001bI,7/\u001a;EK\u0006$G.\u001b8f+\u0005\t\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003!!WO]1uS>t'B\u0001<9\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003qN\u0014\u0001\u0002R3bI2Lg.Z\u0001\u0012e\u0016\u001cX\r\u001e#fC\u0012d\u0017N\\3`I\u0015\fHCA5|\u0011\u001di7\"!AA\u0002E\faB]3tKR$U-\u00193mS:,\u0007%A\u0005gS:L7\u000f[5oOV\ta+A\u0007gS:L7\u000f[5oO~#S-\u001d\u000b\u0004S\u0006\r\u0001bB7\u000f\u0003\u0003\u0005\rAV\u0001\u000bM&t\u0017n\u001d5j]\u001e\u0004\u0013!\u00037pON{WO]2f+\t\tY\u0001\r\u0003\u0002\u000e\u0005U\u0001#B\u001a\u0002\u0010\u0005M\u0011bAA\t}\t)1\t\\1tgB\u0019\u0011)!\u0006\u0005\u0017\u0005]\u0001#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0004\u0002\u0004?\u0012:\u0014cA#\u0002\u001cA\u0019a)!\b\n\u0007\u0005}\u0001HA\u0002B]f\f!b\u001d;beR<%/\u00199i)\u0005I\u0017a\u00022bG.|gMZ\u0001\u000fY><w-\u001b8h\u000b:\f'\r\\3e\u00039\u0019'/Z1uKN+(-\u00138mKR,B!!\f\u0002>Q!\u0011qFA!!\u0019\t\t$a\r\u0002<5\t\u0001!\u0003\u0003\u00026\u0005]\"\u0001D*vENKgn[%oY\u0016$\u0018bAA\u001d[\tyqI]1qQN#\u0018mZ3M_\u001eL7\rE\u0002B\u0003{!q!a\u0010\u0015\u0005\u0004\tIBA\u0001U\u0011\u001d\t\u0019\u0005\u0006a\u0001\u0003\u000b\n1a\\;u!\u0015Q\u0015qIA\u001e\u0013\r\tI\u0005\t\u0002\u0007\u001fV$H.\u001a;\u0002\u00111|w\rT3wK2$B!a\u0014\u0002dA!\u0011\u0011KA/\u001d\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,E\u0005)QM^3oi&!\u00111LA+\u0003\u001daunZ4j]\u001eLA!a\u0018\u0002b\tAAj\\4MKZ,GN\u0003\u0003\u0002\\\u0005U\u0003bBA3+\u0001\u0007\u0011qJ\u0001\f[&tGj\\4MKZ,G.A\u0003m_\u001eLE\u000fF\u0004j\u0003W\ny'!%\t\r\u00055d\u00031\u00013\u0003\u001diWm]:bO\u0016Dq!!\u001d\u0017\u0001\u0004\t\u0019(A\u0002fq\u000e\u0004b!!\u001e\u0002|\u0005}TBAA<\u0015\r\tIHI\u0001\u0005kRLG.\u0003\u0003\u0002~\u0005]$!C(qi&|gNV1m!\u0011\t\t)a#\u000f\t\u0005\r\u0015q\u0011\b\u0004k\u0005\u0015\u0015\"A\u001d\n\u0007\u0005%\u0005(A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0015q\u0012\u0002\n)\"\u0014xn^1cY\u0016T1!!#9\u0011%\t)G\u0006I\u0001\u0002\u0004\ty%A\bm_\u001eLE\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9J\u000b\u0003\u0002P\u0005e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0006(\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\r\u0014X-\u0019;f'V\u0014w*\u001e;mKR,B!a,\u0002:R!\u0011\u0011WA^!\u0019\t\t$a-\u00028&!\u0011QWA\u001c\u0005=\u0019VOY*pkJ\u001cWmT;uY\u0016$\bcA!\u0002:\u00129\u0011q\b\rC\u0002\u0005e\u0001bBA_1\u0001\u0007\u0011qX\u0001\u0003S:\u0004RASAa\u0003oK1!a1!\u0005\u0015Ie\u000e\\3u\u0003Ii\u0017\r\u001f*fgR\f'\u000f^:SK\u0006\u001c\u0007.\u001a3\u0015\u0003Y\u000bAc]2iK\u0012,H.\u001a*fgR\f'\u000f\u001e+j[\u0016\u0014\u0018aB8o)&lWM\u001d\u000b\u0004S\u0006=\u0007bBAi7\u0001\u0007\u00111D\u0001\ti&lWM]&fs\u0006A\u0001O]3Ti\u0006\u0014H\u000f")
public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final Attributes inheritedAttributes;
    public final RestartSettings org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings;
    public final boolean org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    @Override
    public Class<?> logSource() {
        return RestartWithBackoffLogic.class;
    }

    public abstract void startGraph();

    public abstract void backoff();

    private boolean loggingEnabled() {
        Option option = this.inheritedAttributes.get(ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
        if (option instanceof Some) {
            return ((Attributes.LogLevels)((Some)option).value()).onFailure() != Attributes$LogLevels$.MODULE$.Off();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringBuilder(24).append("RestartWithBackoff").append(this.name).append(".subIn").toString());
        sinkIn.setHandler(new InHandler(this, out, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPush() {
                this.$outer.push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.complete(this.out$1);
                    return;
                }
                String string = new StringBuilder(38).append("Restarting stream due to completion [").append(this.$outer.restartCount() + 1).append("]").toString();
                OptionVal$.MODULE$.None();
                this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(string, null, Logging$.MODULE$.InfoLevel());
                this.$outer.scheduleRestartTimer();
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || !BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.restartOn().apply((Object)ex))) {
                    this.$outer.fail(this.out$1, ex);
                    return;
                }
                if (this.$outer == null) {
                    throw null;
                }
                this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(new StringBuilder(37).append("Restarting stream due to failure [").append(this.$outer.restartCount() + 1).append("]: ").append(ex).toString(), ex, Logging$.MODULE$.ErrorLevel());
                this.$outer.scheduleRestartTimer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.sinkIn$1 = sinkIn$1;
            }
        });
        this.setHandler(out, new OutHandler(this, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                this.sinkIn$1.pull();
            }

            public void onDownstreamFinish(Throwable cause) {
                this.$outer.finishing_$eq(true);
                this.sinkIn$1.cancel(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sinkIn$1 = sinkIn$1;
            }
        });
        return sinkIn;
    }

    private int logLevel(int minLogLevel) {
        int level;
        int n = level = this.restartCount() >= this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().criticalLogLevelAfter() ? this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().criticalLogLevel() : this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().logLevel();
        if (Logging.LogLevel$.MODULE$.$greater$eq$extension(level, minLogLevel) || level == Logging$.MODULE$.OffLevel()) {
            return level;
        }
        return minLogLevel;
    }

    public void org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(String message, Throwable exc, int minLogLevel) {
        if (this.loggingEnabled()) {
            int n = this.logLevel(minLogLevel);
            if (Logging$.MODULE$.ErrorLevel() == n) {
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)exc)) {
                    Throwable e = (Throwable)OptionVal$.MODULE$.get$extension((Object)exc);
                    this.log().error(e, message);
                    return;
                }
                this.log().error(message);
                return;
            }
            if (Logging$.MODULE$.WarningLevel() == n) {
                if (this.log().isWarningEnabled()) {
                    Throwable e;
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)exc) && !((e = (Throwable)OptionVal$.MODULE$.get$extension((Object)exc)) instanceof NoStackTrace)) {
                        this.log().warning(new StringBuilder(0).append(message).append(Logging$.MODULE$.stackTraceFor(e)).toString());
                        return;
                    }
                    this.log().warning(message);
                    return;
                }
                return;
            }
            if (Logging$.MODULE$.InfoLevel() == n) {
                this.log().info(message);
                return;
            }
            if (Logging$.MODULE$.DebugLevel() == n) {
                this.log().debug(message);
                return;
            }
            return;
        }
    }

    public int org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt$default$3() {
        return Logging$.MODULE$.ErrorLevel();
    }

    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in) {
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringBuilder(25).append("RestartWithBackoff").append(this.name).append(".subOut").toString());
        sourceOut.setHandler(new OutHandler(this, in, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                if (this.$outer.isAvailable(this.in$1)) {
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                    return;
                }
                if (!this.$outer.hasBeenPulled(this.in$1)) {
                    this.$outer.pull(this.in$1);
                    return;
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures || !BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.restartOn().apply((Object)cause))) {
                    this.$outer.cancel(this.in$1, cause);
                    return;
                }
                this.$outer.scheduleRestartTimer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = sourceOut$1;
            }
        });
        this.setHandler(in, new InHandler(this, sourceOut, in){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;
            private final Inlet in$1;

            public void onPush() {
                if (this.sourceOut$1.isAvailable()) {
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.fail(ex);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceOut$1 = sourceOut$1;
                this.in$1 = in$1;
            }
        });
        return sourceOut;
    }

    public final boolean maxRestartsReached() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", (Object)this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestartsWithin().toCoarsest());
            this.restartCount_$eq(0);
        }
        return this.restartCount() == this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestarts();
    }

    public final void scheduleRestartTimer() {
        FiniteDuration restartDelay = RetrySupport$.MODULE$.calculateDelay(this.restartCount(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.minBackoff(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxBackoff(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.randomFactor());
        this.log().debug("Restarting graph in {}", (Object)restartDelay.toCoarsest());
        this.scheduleOnce((Object)"RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestartsWithin().fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public RestartWithBackoffLogic(String name, S shape, Attributes inheritedAttributes, RestartSettings settings, boolean onlyOnFailures) {
        this.name = name;
        this.inheritedAttributes = inheritedAttributes;
        this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings = settings;
        this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures = onlyOnFailures;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = settings.maxRestartsWithin().fromNow();
        this.finishing = false;
    }
}

