/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import io.netty.buffer.ByteBufAllocator;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.SSLSettings;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u00181\u0001uB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u001d\u0002!\ta\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019A\u0006\u0001)A\u0005+\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006B\u00024\u0001A\u0003%1\fC\u0004h\u0001\t\u0007I\u0011\u00015\t\r1\u0004\u0001\u0015!\u0003j\u0011\u0019i\u0007\u0001)C\u0005]\"9Q\u000f\u0001b\u0001\n\u00031\bBB@\u0001A\u0003%q\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!9\u0011Q\u0001\u0001!\u0002\u0013y\u0007\"CA\u0004\u0001\t\u0007I\u0011AA\u0002\u0011\u001d\tI\u0001\u0001Q\u0001\n=D\u0011\"a\u0003\u0001\u0005\u0004%\t!a\u0001\t\u000f\u00055\u0001\u0001)A\u0005_\"I\u0011q\u0002\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\b\u0003#\u0001\u0001\u0015!\u0003p\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002C\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u00029\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005U\u0001bBA\u000e\u0001\u0001\u0006I\u0001\u001d\u0005\t\u0003;\u0001!\u0019!C\u0001)\"9\u0011q\u0004\u0001!\u0002\u0013)\u0006\u0002CA\u0011\u0001\t\u0007I\u0011\u0001+\t\u000f\u0005\r\u0002\u0001)A\u0005+\"A\u0011Q\u0005\u0001C\u0002\u0013\u0005A\u000bC\u0004\u0002(\u0001\u0001\u000b\u0011B+\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA \u0001\u0001\u0006I!!\f\t\u0011\u0005\u0005\u0003A1A\u0005\u0002iCq!a\u0011\u0001A\u0003%1\f\u0003\u0005\u0002F\u0001\u0011\r\u0011\"\u0001[\u0011\u001d\t9\u0005\u0001Q\u0001\nmC\u0011\"!\u0013\u0001\u0005\u0004%\t!!\u0006\t\u000f\u0005}\u0003\u0001)A\u0005a\"I\u00111\r\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\b\u0003W\u0002\u0001\u0015!\u0003q\u0011%\ty\u0007\u0001b\u0001\n\u0003\t\t\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA:\u0011%\ti\b\u0001b\u0001\n\u0003\t)\u0002C\u0004\u0002\u0000\u0001\u0001\u000b\u0011\u00029\t\u0013\u0005\u0005\u0005A1A\u0005\u0002\u0005U\u0001bBAB\u0001\u0001\u0006I\u0001\u001d\u0005\b\u0003\u000b\u0003A\u0011BAD\u0005YqU\r\u001e;z)J\fgn\u001d9peR\u001cV\r\u001e;j]\u001e\u001c(BA\u00193\u0003\u0015qW\r\u001e;z\u0015\t\u0019D'A\u0005ue\u0006t7\u000f]8si*\u0011QGN\u0001\u0007e\u0016lw\u000e^3\u000b\u0005]B\u0014!\u00029fW.|'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\faaY8oM&<\u0007C\u0001$M\u001b\u00059%B\u0001#I\u0015\tI%*\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0015aA2p[&\u0011Qj\u0012\u0002\u0007\u0007>tg-[4\u0002\rqJg.\u001b;?)\t\u0001&\u000b\u0005\u0002R\u00015\t\u0001\u0007C\u0003E\u0005\u0001\u0007Q)A\u0005F]\u0006\u0014G.Z*tYV\tQ\u000b\u0005\u0002@-&\u0011q\u000b\u0011\u0002\b\u0005>|G.Z1o\u0003))e.\u00192mKN\u001bH\u000eI\u0001\u001b'NcUI\\4j]\u0016\u0004&o\u001c<jI\u0016\u00148\t\\1tg:\u000bW.Z\u000b\u00027B\u0011Al\u0019\b\u0003;\u0006\u0004\"A\u0018!\u000e\u0003}S!\u0001\u0019\u001f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0007)\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012A\u0003m\u00196\u000bT#oO&tW\r\u0015:pm&$WM]\"mCN\u001ch*Y7fA\u0005\u0011Rk]3ESN\u0004\u0018\r^2iKJ4uN]%p+\u0005I\u0007cA k7&\u00111\u000e\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002'U\u001bX\rR5ta\u0006$8\r[3s\r>\u0014\u0018j\u001c\u0011\u0002\u0015=\u0004H/[8o'&TX\r\u0006\u0002pgB\u0019qH\u001b9\u0011\u0005}\n\u0018B\u0001:A\u0005\rIe\u000e\u001e\u0005\u0006i&\u0001\raW\u0001\u0002g\u0006\t2i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\u0016\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u0011\u0011,(/\u0019;j_:T!\u0001 !\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002\u007fs\nqa)\u001b8ji\u0016$UO]1uS>t\u0017AE\"p]:,7\r^5p]RKW.Z8vi\u0002\n\u0001d\u0016:ji\u0016\u0014UO\u001a4fe\"Kw\r[,bi\u0016\u0014X*\u0019:l+\u0005y\u0017!G,sSR,')\u001e4gKJD\u0015n\u001a5XCR,'/T1sW\u0002\nqc\u0016:ji\u0016\u0014UO\u001a4fe2{woV1uKJl\u0015M]6\u00021]\u0013\u0018\u000e^3Ck\u001a4WM\u001d'po^\u000bG/\u001a:NCJ\\\u0007%\u0001\bTK:$')\u001e4gKJ\u001c\u0016N_3\u0002\u001fM+g\u000e\u001a\"vM\u001a,'oU5{K\u0002\n\u0011CU3dK&4XMQ;gM\u0016\u00148+\u001b>f\u0003I\u0011VmY3jm\u0016\u0014UO\u001a4feNK'0\u001a\u0011\u0002\u00195\u000b\u0007P\u0012:b[\u0016\u001c\u0016N_3\u0016\u0003A\fQ\"T1y\rJ\fW.Z*ju\u0016\u0004\u0013a\u0002\"bG.dwnZ\u0001\t\u0005\u0006\u001c7\u000e\\8hA\u0005QAk\u00199O_\u0012,G.Y=\u0002\u0017Q\u001b\u0007OT8eK2\f\u0017\u0010I\u0001\r)\u000e\u00048*Z3qC2Lg/Z\u0001\u000e)\u000e\u00048*Z3qC2Lg/\u001a\u0011\u0002\u0019Q\u001b\u0007OU3vg\u0016\fE\r\u001a:\u0002\u001bQ\u001b\u0007OU3vg\u0016\fE\r\u001a:!\u0003A\u0011\u0015\u0010^3Ck\u001a\fE\u000e\\8dCR|'/\u0006\u0002\u0002.A!\u0011qFA\u001e\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012A\u00022vM\u001a,'OC\u00022\u0003oQ!!!\u000f\u0002\u0005%|\u0017\u0002BA\u001f\u0003c\u0011\u0001CQ=uK\n+h-\u00117m_\u000e\fGo\u001c:\u0002#\tKH/\u001a\"vM\u0006cGn\\2bi>\u0014\b%\u0001\u0005I_N$h.Y7f\u0003%Aun\u001d;oC6,\u0007%\u0001\u0007CS:$\u0007j\\:u]\u0006lW-A\u0007CS:$\u0007j\\:u]\u0006lW\rI\u0001\r!>\u0014HoU3mK\u000e$xN\u001d\u0015\fI\u00055\u00131KA+\u00033\nY\u0006E\u0002@\u0003\u001fJ1!!\u0015A\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\t\t9&A\u001aX\u0003Js\u0015JT$;AQC\u0017n\u001d\u0011tQ>,H\u000e\u001a\u0011p]2L\bEY3!kN,G\r\t2zAA\u0014xNZ3tg&|g.\u00197t]\u0005)1/\u001b8dK\u0006\u0012\u0011QL\u0001\t\u0003.\\\u0017\r\t\u001a/a\u0005i\u0001k\u001c:u'\u0016dWm\u0019;pe\u0002B3\"JA'\u0003'\n)&!\u0017\u0002\\\u0005\u0001\")\u001b8e!>\u0014HoU3mK\u000e$xN\u001d\u0015\fM\u00055\u00131KA+\u00033\n9'\t\u0002\u0002j\u0005A\u0011i[6bAIrC'A\tCS:$\u0007k\u001c:u'\u0016dWm\u0019;pe\u0002B3bJA'\u0003'\n)&!\u0017\u0002h\u0005Y1k\u001d7TKR$\u0018N\\4t+\t\t\u0019\b\u0005\u0003@U\u0006U\u0004cA)\u0002x%\u0019\u0011\u0011\u0010\u0019\u0003\u0017M\u001bFjU3ui&twm]\u0001\r'Nd7+\u001a;uS:<7\u000fI\u0001\u001b'\u0016\u0014h/\u001a:T_\u000e\\W\r^,pe.,'\u000fU8pYNK'0Z\u0001\u001c'\u0016\u0014h/\u001a:T_\u000e\\W\r^,pe.,'\u000fU8pYNK'0\u001a\u0011\u00025\rc\u0017.\u001a8u'>\u001c7.\u001a;X_J\\WM\u001d)p_2\u001c\u0016N_3\u00027\rc\u0017.\u001a8u'>\u001c7.\u001a;X_J\\WM\u001d)p_2\u001c\u0016N_3!\u0003)\u0019w.\u001c9vi\u0016<\u0006k\u0015\u000b\u0004a\u0006%\u0005\"\u0002#/\u0001\u0004)\u0005f\u0003\u0001\u0002N\u0005M\u0013QRA-\u0003#\u000b#!a$\u0002U\rc\u0017m]:jG\u0002\u0012X-\\8uS:<\u0007%[:!I\u0016\u0004(/Z2bi\u0016$G\u0006I;tK\u0002\n%\u000f^3ss\u0006\u0012\u00111S\u0001\u000b\u0003.\\\u0017\r\t\u001a/m9\u0002\u0004")
public class NettyTransportSettings {
    private final Config config;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final ByteBufAllocator ByteBufAllocator;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                return None$.MODULE$;
            }
        }
        if (n < 0) {
            throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public ByteBufAllocator ByteBufAllocator() {
        return this.ByteBufAllocator;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    public static final /* synthetic */ boolean $anonfun$MaxFrameSize$1(int x$1) {
        return x$1 >= 32000;
    }

    /*
     * WARNING - void declaration
     */
    public NettyTransportSettings(Config config) {
        int n;
        String string;
        String string2;
        boolean bl;
        void requiring$extension_msg;
        Some some;
        block22: {
            String string3;
            block21: {
                this.config = config;
                this.EnableSsl = config.getBoolean("enable-ssl");
                this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
                string3 = config.getString("use-dispatcher-for-io");
                switch (string3 == null ? 0 : string3.hashCode()) {
                    case 0: {
                        if ("".equals(string3) || string3 == null) {
                            break;
                        }
                        break block21;
                    }
                    default: {
                        break block21;
                    }
                }
                some = None$.MODULE$;
                break block22;
            }
            some = new Some((Object)string3);
        }
        this.UseDispatcherForIo = some;
        String getMillisDuration$extension_path = "connection-timeout";
        Object var9_3 = null;
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getDuration$extension(config, getMillisDuration$extension_path, TimeUnit.MILLISECONDS);
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = this.optionSize("receive-buffer-size");
        Function0 & Serializable intersect = (Function0 & Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes";
        int requiring$extension_$this = (int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"));
        Predef$.MODULE$.require(NettyTransportSettings.$anonfun$MaxFrameSize$1(requiring$extension_$this), (Function0)requiring$extension_msg);
        intersect = null;
        this.MaxFrameSize = requiring$extension_$this;
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string4 = config.getString("tcp-reuse-addr");
        switch (string4 == null ? 0 : string4.hashCode()) {
            case 795167265: {
                if ("off-for-windows".equals(string4)) {
                    if (!Helpers$.MODULE$.isWindows()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
            default: {
                bl = config.getBoolean("tcp-reuse-addr");
            }
        }
        this.TcpReuseAddr = bl;
        this.ByteBufAllocator = NettyTransport$.MODULE$.deriveByteBufAllocator(config.getString("bytebuf-allocator-type"));
        String string5 = config.getString("hostname");
        switch (string5 == null ? 0 : string5.hashCode()) {
            case 0: {
                if ("".equals(string5)) {
                    string2 = InetAddress.getLocalHost().getHostAddress();
                    break;
                }
            }
            default: {
                string2 = string5;
            }
        }
        this.Hostname = string2;
        String string6 = config.getString("bind-hostname");
        switch (string6 == null ? 0 : string6.hashCode()) {
            case 0: {
                if ("".equals(string6)) {
                    string = this.Hostname();
                    break;
                }
            }
            default: {
                string = string6;
            }
        }
        this.BindHostname = string;
        this.PortSelector = config.getInt("port");
        String string7 = config.getString("bind-port");
        switch (string7 == null ? 0 : string7.hashCode()) {
            case 0: {
                if ("".equals(string7)) {
                    n = this.PortSelector();
                    break;
                }
            }
            default: {
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string7));
            }
        }
        this.BindPortSelector = n;
        this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
    }
}

