/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015rAB\u001e=\u0011\u0003q\u0004J\u0002\u0004Ky!\u0005ah\u0013\u0005\u0006%\u0006!\t\u0001\u0016\u0005\b+\u0006\u0011\r\u0011\"\u0001W\u0011\u0019Q\u0016\u0001)A\u0005/\")1,\u0001C\u00019\"91/\u0001b\u0001\n\u0003!\bbBA\u0001\u0003\u0001\u0006I!\u001e\u0005\b\u0003\u0007\tA\u0011AA\u0003\u0011\u001d\t\u0019!\u0001C\u0001\u0003'Bq!!\u0018\u0002\t\u0003\tyFB\u0003Ky\u0001\t\t\b\u0003\u0006\u0002|-\u0011)\u0019!C\u0001\u0003{B!\"!\"\f\u0005\u0003\u0005\u000b\u0011BA@\u0011)\t9i\u0003BC\u0002\u0013\u0005\u0011\u0011\u0012\u0005\u000b\u0003#[!\u0011!Q\u0001\n\u0005-\u0005B\u0002*\f\t\u0003\t\u0019\n\u0003\u0004S\u0017\u0011\u0005\u00111\u0014\u0005\n\u0003o[!\u0019!C\u0002\u0003sCq!a/\fA\u0003%1\rC\u0005\u0002,-\u0011\r\u0011\"\u0011\u0002>\"A\u0011qX\u0006!\u0002\u0013\ti\u0003\u0003\u0004\u0002B.!\tE\u0016\u0005\f\u0003\u0007\\\u0001\u0019!a\u0001\n\u0013\t)\rC\u0006\u0002H.\u0001\r\u00111A\u0005\n\u0005%\u0007bCAh\u0017\u0001\u0007\t\u0011)Q\u0005\u0003\u001bA1\"!7\f\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\\"Y\u0011Q\\\u0006A\u0002\u0003\u0007I\u0011BAp\u0011)\t\u0019o\u0003a\u0001\u0002\u0003\u0006Ka\u001b\u0005\n\u0003O\\!\u0019!C\u0005\u0003SD\u0001\"a>\fA\u0003%\u00111\u001e\u0005\b\u0003s\\A\u0011BA~\u0011%\u00119a\u0003b\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u0018-\u0001\u000b\u0011\u0002B\u0006\u0011%\u0011Ib\u0003b\u0001\n\u0013\u0011Y\u0002\u0003\u0005\u0003\u001e-\u0001\u000b\u0011BA\u007f\u0011%\u0011yb\u0003b\u0001\n\u0013\u0011Y\u0002\u0003\u0005\u0003\"-\u0001\u000b\u0011BA\u007f\u0011%\u0011\u0019c\u0003b\u0001\n\u0013\u0011Y\u0002\u0003\u0005\u0003&-\u0001\u000b\u0011BA\u007f\u0011\u001d\u00119c\u0003C\u0005\u0005SA\u0011Ba\r\f\u0005\u0004%IA!\u000e\t\u0011\te3\u0002)A\u0005\u0005oA\u0011Ba\u0017\f\u0005\u0004%IA!\u0018\t\u0011\t=4\u0002)A\u0005\u0005?BqA!\u001d\f\t\u0013\u0011\u0019\bC\u0005\u0003\u0010.\u0011\r\u0011\"\u0003\u0003\u0012\"A!QU\u0006!\u0002\u0013\u0011\u0019\nC\u0004\u0003(.!IA!+\t\u0013\t=6B1A\u0005\n\tE\u0006\u0002\u0003B`\u0017\u0001\u0006IAa-\t\u000f\t\u00057\u0002\"\u0003\u0003D\"9!QZ\u0006\u0005B\t=\u0007b\u0002Bk\u0017\u0011\u0005!q\u001b\u0005\b\u0005O\\A\u0011\tBu\u0011!\u0011\u0019p\u0003C\u0001\u0005\u0006\u0015\u0007b\u0002B{\u0017\u0011%!q\u001f\u0005\b\u0005{\\A\u0011\tB\u0000\u0011\u001d\u0019Ya\u0003C!\u0007\u001b\taBT3uif$&/\u00198ta>\u0014HO\u0003\u0002>}\u0005)a.\u001a;us*\u0011q\bQ\u0001\niJ\fgn\u001d9peRT!!\u0011\"\u0002\rI,Wn\u001c;f\u0015\t\u0019E)A\u0003qK.\\wN\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<\u0007CA%\u0002\u001b\u0005a$A\u0004(fiRLHK]1ogB|'\u000f^\n\u0003\u00031\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003!\u000baC\u0012:b[\u0016dUM\\4uQ\u001aKW\r\u001c3MK:<G\u000f[\u000b\u0002/B\u0011Q\nW\u0005\u00033:\u00131!\u00138u\u0003]1%/Y7f\u0019\u0016tw\r\u001e5GS\u0016dG\rT3oORD\u0007%A\u0007he\u0006\u001cWMZ;m\u00072|7/\u001a\u000b\u0003;&$\"AX1\u0011\u00055{\u0016B\u00011O\u0005\u0011)f.\u001b;\t\u000b\t,\u00019A2\u0002\u0005\u0015\u001c\u0007C\u00013h\u001b\u0005)'B\u00014O\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Q\u0016\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b),\u0001\u0019A6\u0002\u000f\rD\u0017M\u001c8fYB\u0011A.]\u0007\u0002[*\u0011!N\u001c\u0006\u0003{=T\u0011\u0001]\u0001\u0003S>L!A]7\u0003\u000f\rC\u0017M\u001c8fY\u0006yQO\\5rk\u0016LEmQ8v]R,'/F\u0001v!\t1h0D\u0001x\u0015\tA\u00180\u0001\u0004bi>l\u0017n\u0019\u0006\u0003MjT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\tyxOA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0011k:L\u0017/^3JI\u000e{WO\u001c;fe\u0002\n\u0001$\u00193ee\u0016\u001c8O\u0012:p[N{7m[3u\u0003\u0012$'/Z:t)1\t9!!\u0007\u0002*\u0005\r\u0013qIA'!\u0015i\u0015\u0011BA\u0007\u0013\r\tYA\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005C\u0003\u0015\t7\r^8s\u0013\u0011\t9\"!\u0005\u0003\u000f\u0005#GM]3tg\"9\u00111\u0004\u0005A\u0002\u0005u\u0011\u0001B1eIJ\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003Ga\u0018a\u00018fi&!\u0011qEA\u0011\u00055\u0019vnY6fi\u0006#GM]3tg\"9\u00111\u0006\u0005A\u0002\u00055\u0012\u0001E:dQ\u0016lW-\u00133f]RLg-[3s!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003gqUBAA\u001b\u0015\r\t9dU\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mb*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\t\tE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003wq\u0005bBA#\u0011\u0001\u0007\u0011QF\u0001\u000bgf\u001cH/Z7OC6,\u0007bBA%\u0011\u0001\u0007\u00111J\u0001\tQ>\u001cHOT1nKB)Q*!\u0003\u0002.!9\u0011q\n\u0005A\u0002\u0005E\u0013\u0001\u00029peR\u0004B!TA\u0005/RQ\u0011qAA+\u0003/\nI&a\u0017\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e!9\u00111F\u0005A\u0002\u00055\u0002bBA#\u0013\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003Y!WM]5wK\nKH/\u001a\"vM\u0006cGn\\2bi>\u0014H\u0003BA1\u0003[\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003Or\u0017A\u00022vM\u001a,'/\u0003\u0003\u0002l\u0005\u0015$\u0001\u0005\"zi\u0016\u0014UOZ!mY>\u001c\u0017\r^8s\u0011\u001d\tyG\u0003a\u0001\u0003[\tQ\"\u00197m_\u000e\fGo\u001c:UsB,7\u0003B\u0006M\u0003g\u0002B!!\u001e\u0002x5\ta(C\u0002\u0002zy\u0012\u0011\u0002\u0016:b]N\u0004xN\u001d;\u0002\u0011M,G\u000f^5oON,\"!a \u0011\u0007%\u000b\t)C\u0002\u0002\u0004r\u0012aCT3uif$&/\u00198ta>\u0014HoU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\naa]=ti\u0016lWCAAF!\u0011\ty!!$\n\t\u0005=\u0015\u0011\u0003\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!)\u0019\t)*a&\u0002\u001aB\u0011\u0011j\u0003\u0005\b\u0003w\u0002\u0002\u0019AA@\u0011\u001d\t9\t\u0005a\u0001\u0003\u0017#b!!&\u0002\u001e\u0006}\u0005bBAD#\u0001\u0007\u00111\u0012\u0005\b\u0003C\u000b\u0002\u0019AAR\u0003\u0011\u0019wN\u001c4\u0011\t\u0005\u0015\u00161W\u0007\u0003\u0003OSA!!+\u0002,\u000611m\u001c8gS\u001eTA!!,\u00020\u0006AA/\u001f9fg\u00064WM\u0003\u0002\u00022\u0006\u00191m\\7\n\t\u0005U\u0016q\u0015\u0002\u0007\u0007>tg-[4\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A2\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%\u0006\u0002\u0002.\u0005\t2o\u00195f[\u0016LE-\u001a8uS\u001aLWM\u001d\u0011\u0002'5\f\u00070[7v[B\u000b\u0017\u0010\\8bI\nKH/Z:\u0002\u000f\t|WO\u001c3U_V\u0011\u0011QB\u0001\fE>,h\u000e\u001a+p?\u0012*\u0017\u000fF\u0002_\u0003\u0017D\u0011\"!4\u0019\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0013'\u0001\u0005c_VtG\rV8!Q\rI\u00121\u001b\t\u0004\u001b\u0006U\u0017bAAl\u001d\nAao\u001c7bi&dW-A\u0007tKJ4XM]\"iC:tW\r\\\u000b\u0002W\u0006\t2/\u001a:wKJ\u001c\u0005.\u00198oK2|F%Z9\u0015\u0007y\u000b\t\u000f\u0003\u0005\u0002Nn\t\t\u00111\u0001l\u00039\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY\u0002B3\u0001HAj\u0003\rawnZ\u000b\u0003\u0003W\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003c\u0014\u0015!B3wK:$\u0018\u0002BA{\u0003_\u0014A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nAc\u0019:fCR,WI^3oi2{w\u000e]$s_V\u0004H\u0003BA\u007f\u0005\u0007\u00012\u0001\\A\u0000\u0013\r\u0011\t!\u001c\u0002\u000f\u000bZ,g\u000e\u001e'p_B<%o\\;q\u0011\u0019\u0011)a\ba\u0001/\u0006aa\u000e\u00165sK\u0006$7i\\;oi\u0006a1\r[1o]\u0016dwI]8vaV\u0011!1\u0002\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)\u0019!\u0011C7\u0002\u000b\u001d\u0014x.\u001e9\n\t\tU!q\u0002\u0002\u0014\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m\u000fJ|W\u000f]\u0001\u000eG\"\fgN\\3m\u000fJ|W\u000f\u001d\u0011\u0002)\rd\u0017.\u001a8u\u000bZ,g\u000e\u001e'p_B<%o\\;q+\t\ti0A\u000bdY&,g\u000e^#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0011\u00025M,'O^3s\u000bZ,g\u000e\u001e'p_B\u0004\u0016M]3oi\u001e\u0013x.\u001e9\u00027M,'O^3s\u000bZ,g\u000e\u001e'p_B\u0004\u0016M]3oi\u001e\u0013x.\u001e9!\u0003e\u0019XM\u001d<fe\u00163XM\u001c;M_>\u00048\t[5mI\u001e\u0013x.\u001e9\u00025M,'O^3s\u000bZ,g\u000e\u001e'p_B\u001c\u0005.\u001b7e\u000fJ|W\u000f\u001d\u0011\u0002\u00179,w\u000fU5qK2Lg.\u001a\u000b\u0005\u0005W\u0011\t\u0004E\u0002m\u0005[I1Aa\fn\u0005=\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,\u0007\"\u00026)\u0001\u0004Y\u0017AG1tg>\u001c\u0017.\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bK]8nSN,WC\u0001B\u001c!\u0015!'\u0011\bB\u001f\u0013\r\u0011Y$\u001a\u0002\b!J|W.[:f!\u0011\u0011yDa\u0015\u000f\t\t\u0005#q\n\b\u0005\u0005\u0007\u0012iE\u0004\u0003\u0003F\t-c\u0002\u0002B$\u0005\u0013j\u0011\u0001R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0005}\u0002\u0015b\u0001B)}\u0005IAK]1ogB|'\u000f^\u0005\u0005\u0005+\u00129F\u0001\rBgN|7-[1uS>tWI^3oi2K7\u000f^3oKJT1A!\u0015?\u0003m\t7o]8dS\u0006$\u0018n\u001c8MSN$XM\\3s!J|W.[:fA\u0005\t2o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:\u0016\u0005\t}\u0003C\u0002B1\u0005K\u0012I'\u0004\u0002\u0003d)\u00111PQ\u0005\u0005\u0005O\u0012\u0019GA\u0005PaRLwN\u001c,bYB\u0019\u0011Ja\u001b\n\u0007\t5DHA\tT'2+enZ5oKB\u0013xN^5eKJ\f!c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3sA\u0005Q1o\u001d7IC:$G.\u001a:\u0015\t\tU$Q\u0011\t\u0005\u0005o\u0012\t)\u0004\u0002\u0003z)!!1\u0010B?\u0003\r\u00198\u000f\u001c\u0006\u0004\u0005\u007fr\u0017a\u00025b]\u0012dWM]\u0005\u0005\u0005\u0007\u0013IH\u0001\u0006Tg2D\u0015M\u001c3mKJDqAa\".\u0001\u0004\u0011I)\u0001\u0005jg\u000ec\u0017.\u001a8u!\ri%1R\u0005\u0004\u0005\u001bs%a\u0002\"p_2,\u0017M\\\u0001\u001ag\u0016\u0014h/\u001a:QSB,G.\u001b8f\u0013:LG/[1mSj,'/\u0006\u0002\u0003\u0014B)AN!&\u0003\u001a&\u0019!qS7\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*\u0019!qT7\u0002\rM|7m[3u\u0013\u0011\u0011\u0019K!(\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003i\u0019XM\u001d<feBK\u0007/\u001a7j]\u0016Le.\u001b;jC2L'0\u001a:!\u0003e\u0019G.[3oiBK\u0007/\u001a7j]\u0016Le.\u001b;jC2L'0\u001a:\u0015\t\tM%1\u0016\u0005\b\u0005[\u0003\u0004\u0019AA\u0007\u00035\u0011X-\\8uK\u0006#GM]3tg\u0006\u0001\u0012N\u001c2pk:$'i\\8ugR\u0014\u0018\r]\u000b\u0003\u0005g\u0003BA!.\u0003<6\u0011!q\u0017\u0006\u0004\u0005ss\u0017!\u00032p_R\u001cHO]1q\u0013\u0011\u0011iLa.\u0003\u001fM+'O^3s\u0005>|Go\u001d;sCB\f\u0011#\u001b8c_VtGMQ8piN$(/\u00199!\u0003EyW\u000f\u001e2pk:$'i\\8ugR\u0014\u0018\r\u001d\u000b\u0005\u0005\u000b\u0014Y\r\u0005\u0003\u00036\n\u001d\u0017\u0002\u0002Be\u0005o\u0013\u0011BQ8piN$(/\u00199\t\u000f\t56\u00071\u0001\u0002\u000e\u0005\u0001\u0012n\u001d*fgB|gn]5cY\u00164uN\u001d\u000b\u0005\u0005\u0013\u0013\t\u000eC\u0004\u0003TR\u0002\r!!\u0004\u0002\u000f\u0005$GM]3tg\u00061\u0012\r\u001a3sKN\u001cHk\\*pG.,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003Z\n\u0015\b#\u00023\u0003\\\n}\u0017b\u0001BoK\n1a)\u001e;ve\u0016\u0004B!a\b\u0003b&!!1]A\u0011\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u00037)\u0004\u0019AA\u0007\u0003\u0019a\u0017n\u001d;f]V\u0011!1\u001e\t\u0006I\nm'Q\u001e\t\b\u001b\n=\u0018Q\u0002B\u001c\u0013\r\u0011\tP\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0019\t|WO\u001c3BI\u0012\u0014Xm]:\u0002%\u0015DHO]1di\"{7\u000f^!oIB{'\u000f\u001e\u000b\u0005\u0005s\u0014Y\u0010\u0005\u0004N\u0005_\fic\u0016\u0005\b\u00037A\u0004\u0019AA\u0007\u0003%\t7o]8dS\u0006$X\r\u0006\u0003\u0004\u0002\r%\u0001#\u00023\u0003\\\u000e\r\u0001\u0003BA;\u0007\u000bI1aa\u0002?\u0005E\t5o]8dS\u0006$\u0018n\u001c8IC:$G.\u001a\u0005\b\u0005[K\u0004\u0019AA\u0007\u0003!\u0019\b.\u001e;e_^tGCAB\b!\u0015!'1\u001cBEQ-Y11CB\r\u00077\u0019yb!\t\u0011\u00075\u001b)\"C\u0002\u0004\u00189\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f#a!\b\u0002U\rc\u0017m]:jG\u0002\u0012X-\\8uS:<\u0007%[:!I\u0016\u0004(/Z2bi\u0016$G\u0006I;tK\u0002\n%\u000f^3ss\u0006)1/\u001b8dK\u0006\u001211E\u0001\u000b\u0003.\\\u0017\r\t\u001a/m9\u0002\u0004")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter log;
    private final DefaultChannelGroup channelGroup;
    private final EventLoopGroup clientEventLoopGroup;
    private final EventLoopGroup serverEventLoopParentGroup;
    private final EventLoopGroup serverEventLoopChildGroup;
    private final Promise<Transport.AssociationEventListener> associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelInitializer<SocketChannel> serverPipelineInitializer;
    private final ServerBootstrap inboundBootstrap;

    public static ByteBufAllocator deriveByteBufAllocator(String allocatorType) {
        return NettyTransport$.MODULE$.deriveByteBufAllocator(allocatorType);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, (Option<Object>)None$.MODULE$);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName, Option<Object> port) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, port);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext ec) {
        NettyTransport$.MODULE$.gracefulClose(channel, ec);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private EventLoopGroup createEventLoopGroup(int nThreadCount) {
        return (EventLoopGroup)this.settings().UseDispatcherForIo().map(arg_0 -> NettyTransport.$anonfun$createEventLoopGroup$1(this.system().dispatchers(), arg_0)).map((Function1 & Serializable)executor -> new MultiThreadIoEventLoopGroup(0, (Executor)executor, NioIoHandler.newFactory())).getOrElse((Function0 & Serializable)() -> new MultiThreadIoEventLoopGroup(nThreadCount, this.system().threadFactory(), NioIoHandler.newFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private EventLoopGroup clientEventLoopGroup() {
        return this.clientEventLoopGroup;
    }

    private EventLoopGroup serverEventLoopParentGroup() {
        return this.serverEventLoopParentGroup;
    }

    private EventLoopGroup serverEventLoopChildGroup() {
        return this.serverEventLoopChildGroup;
    }

    private ChannelPipeline newPipeline(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("FlushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(256, true));
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    private Promise<Transport.AssociationEventListener> associationListenerPromise() {
        return this.associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    private SslHandler sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider)) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider);
            return NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelInitializer<SocketChannel> serverPipelineInitializer() {
        return this.serverPipelineInitializer;
    }

    private ChannelInitializer<SocketChannel> clientPipelineInitializer(Address remoteAddress) {
        return new ChannelInitializer<SocketChannel>(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(x$1, this.remoteAddress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private ServerBootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private Bootstrap outboundBootstrap(Address remoteAddress) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.clientEventLoopGroup());
        bootstrap.handler((ChannelHandler)new /* invalid duplicate definition of identical inner class */);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer((int)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpNodelay()));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$1(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().SendBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$2(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$4(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$6(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Future$.MODULE$.apply((Function0 & Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple2 tuple2;
            try {
                Address address;
                Channel newServerChannel = this.inboundBootstrap().bind(this.settings().BindHostname(), bindPort).sync().channel();
                newServerChannel.config().setAutoRead(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    address = (Address)((Some)option).value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Address address2 = (Address)((Some)option2).value();
                    this.boundTo_$eq(address2);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.associationListenerPromise().future().foreach((Function1 & Serializable)x$10 -> newServerChannel.config().setAutoRead(true), this.executionContext());
                tuple2 = new Tuple2((Object)address, this.associationListenerPromise());
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    block10: {
                        this.log().error("failed to bind to host:{} port:{}, shutting down Netty transport", (Object)this.settings().BindHostname(), (Object)BoxesRunTime.boxToInteger((int)bindPort));
                        try {
                            this.shutdown();
                        }
                        catch (Throwable throwable2) {
                            if (throwable2 != null && !NonFatal$.MODULE$.unapply(throwable2).isEmpty()) break block10;
                            throw throwable2;
                        }
                    }
                    throw throwable;
                }
                throw throwable;
            }
            return tuple2;
        }));
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    private Tuple2<String, Object> extractHostAndPort(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString());
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isActive()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        Bootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> this.extractHostAndPort(remoteAddress))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$associate$2(check$ifrefutable$1)), this.executionContext()).flatMap((Function1 & Serializable)x$11 -> {
            if (x$11 != null) {
                String host = (String)x$11._1();
                int port = x$11._2$mcI$sp();
                return NettyFutureBridge$.MODULE$.apply(bootstrap.connect(host, port)).flatMap((Function1 & Serializable)channel -> (this.settings().EnableSsl() ? NettyFutureBridge$.MODULE$.apply(((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture()) : Future$.MODULE$.successful(channel)).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.pipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext());
            }
            throw new MatchError(null);
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                if (x1 != null && NonFatal$.MODULE$.apply(x1)) {
                    String msg = x1.getCause() == null ? x1.getMessage() : (x1.getCause().getCause() == null ? new StringBuilder(13).append(x1.getMessage()).append(", caused by: ").append(x1.getCause()).toString() : new StringBuilder(26).append(x1.getMessage()).append(", caused by: ").append(x1.getCause()).append(", caused by: ").append(x1.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(x1.getClass().getName()).append(": ").append(msg).toString(), x1.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof CancellationException) {
                    return true;
                }
                return x1 != null && NonFatal$.MODULE$.apply(x1);
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().close(ChannelMatchers.isServerChannel())).flatMap((Function1 & Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$executionContext$2(Dispatchers eta$0$1$1, String id) {
        return eta$0$1$1.lookup(id);
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$createEventLoopGroup$1(Dispatchers eta$0$1$2, String id) {
        return eta$0$1$2.lookup(id);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(SocketChannel ch) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(false));
        }
        TcpServerHandler handler = new TcpServerHandler(this, (Future<Transport.AssociationEventListener>)this.associationListenerPromise().future(), (LoggingAdapter)this.log());
        pipeline.addLast("ServerHandler", (ChannelHandler)handler);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(SocketChannel ch, Address remoteAddress$1) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(true));
        }
        TcpClientHandler handler = new TcpClientHandler(this, remoteAddress$1, (LoggingAdapter)this.log());
        pipeline.addLast("clienthandler", (ChannelHandler)handler);
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$1(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$2(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$4(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$6(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ boolean $anonfun$associate$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$12) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$12)), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)BoxesRunTime.boxToBoolean((boolean)false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        $this.clientEventLoopGroup().shutdownGracefully();
        $this.serverEventLoopParentGroup().shutdownGracefully();
        $this.serverEventLoopChildGroup().shutdownGracefully();
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().writeAndFlush((Object)Unpooled.EMPTY_BUFFER)).flatMap((Function1 & Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    /*
     * WARNING - void declaration
     */
    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        void var3_3;
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable)() -> {
            String string = ((RARP)ExtensionId.apply$((ExtensionId)RARP$.MODULE$, (ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    return None$.MODULE$;
                }
            }
            return new Some((Object)string);
        }).map(arg_0 -> NettyTransport.$anonfun$executionContext$2(system.dispatchers(), arg_0)).getOrElse((Function0 & Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromClass());
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientEventLoopGroup = this.createEventLoopGroup(settings.ClientSocketWorkerPoolSize() + 1);
        this.serverEventLoopParentGroup = this.createEventLoopGroup(0);
        this.serverEventLoopChildGroup = this.createEventLoopGroup(settings.ServerSocketWorkerPoolSize());
        this.associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get();
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineInitializer = new ChannelInitializer<SocketChannel>(this){
            private final /* synthetic */ NettyTransport $outer;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.serverEventLoopParentGroup(), this.serverEventLoopChildGroup());
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler(this.serverPipelineInitializer());
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(settings.Backlog()));
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpReuseAddr()));
        bootstrap.childOption(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpNodelay()));
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpKeepalive()));
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)settings.ByteBufAllocator());
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)settings.ByteBufAllocator());
        settings.ReceiveBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.SendBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        this.inboundBootstrap = var3_3;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

