/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.MessageSerializer;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.control.NonFatal$;

@InternalApi
public final class MessageSerializer$ {
    public static final MessageSerializer$ MODULE$ = new MessageSerializer$();

    public Object deserialize(ExtendedActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)ExtensionId.apply$((ExtensionId)SerializationExtension$.MODULE$, (ActorSystem)system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    public WireFormats.SerializedMessage serialize(ExtendedActorSystem system, Object message) {
        WireFormats.SerializedMessage serializedMessage;
        Serializer serializer = ((Serialization)ExtensionId.apply$((ExtensionId)SerializationExtension$.MODULE$, (ActorSystem)system)).findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            try {
                if (oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)system.provider().serializationInformation());
                }
                builder.setMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(message)));
                builder.setSerializerId(serializer.identifier());
                String ms = Serializers$.MODULE$.manifestFor(serializer, message);
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
                    builder.setMessageManifest(ByteString.copyFromUtf8((String)ms));
                }
                serializedMessage = builder.build();
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    throw new MessageSerializer.SerializationException(new StringBuilder(58).append("Failed to serialize remote message [").append(message.getClass()).append("] ").append("using serializer [").append(serializer.getClass()).append("].").toString(), throwable);
                }
                throw throwable;
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return serializedMessage;
    }

    public void serializeForArtery(Serialization serialization, OutboundEnvelope outboundEnvelope, HeaderBuilder headerBuilder, EnvelopeBuffer envelope) {
        Object message = outboundEnvelope.message();
        Serializer serializer = serialization.findSerializerFor(message);
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)serialization.serializationInformation());
            }
            headerBuilder.setSerializer(serializer.identifier());
            headerBuilder.setManifest(Serializers$.MODULE$.manifestFor(serializer, message));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            if (serializer instanceof ByteBufferSerializer) {
                ((ByteBufferSerializer)serializer).toBinary(message, envelope.byteBuffer());
            } else {
                envelope.byteBuffer().put(serializer.toBinary(message));
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
    }

    public Object deserializeForArtery(ExtendedActorSystem system, long originUid, Serialization serialization, int serializer, String classManifest, EnvelopeBuffer envelope) {
        return serialization.deserializeByteBuffer(envelope.byteBuffer(), serializer, classManifest);
    }

    private MessageSerializer$() {
    }
}

