/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.NoScopeGiven$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistenceSettings;
import org.apache.pekko.persistence.RecoveryPermitter$;
import org.apache.pekko.persistence.StashOverflowStrategy;
import org.apache.pekko.persistence.StashOverflowStrategyConfigurator;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.EventAdapters$;
import org.apache.pekko.persistence.journal.IdentityEventAdapters$;
import org.apache.pekko.routing.NoRouter$;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.util.Collections;
import org.apache.pekko.util.Reflect$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rex!B-[\u0011\u0003\u0019g!B3[\u0011\u00031\u0007B\u0002@\u0002\t\u0003\u0019I\u0007C\u0004\u0004l\u0005!\te!\u001c\t\u000f\r-\u0014\u0001\"\u0011\u0004x!911D\u0001\u0005\u0002\r\u0005\u0005bBBC\u0003\u0011\u00051q\u0011\u0004\b\u0003[\u000b\u0001IWAX\u0011)\tIm\u0002BK\u0002\u0013\u0005\u00111\u001a\u0005\u000b\u0003'<!\u0011#Q\u0001\n\u00055\u0007BCAk\u000f\tU\r\u0011\"\u0001\u0002X\"Q\u0011Q]\u0004\u0003\u0012\u0003\u0006I!!7\t\u0015\u0005%rA!f\u0001\n\u0003\tY\u0003\u0003\u0006\u0002@\u001d\u0011\t\u0012)A\u0005\u0003[AaA`\u0004\u0005\u0002\u0005\u001d\b\"\u00039\b\u0011\u000b\u0007I\u0011AA\"\u0011%\t\u0019pBA\u0001\n\u0003\t)\u0010C\u0005\u0002~\u001e\t\n\u0011\"\u0001\u0002\u0000\"I!1C\u0004\u0012\u0002\u0013\u0005!Q\u0003\u0005\n\u000539\u0011\u0013!C\u0001\u00057A\u0011Ba\b\b\u0003\u0003%\t%!\u0006\t\u0013\t\u0005r!!A\u0005\u0002\t\r\u0002\"\u0003B\u0016\u000f\u0005\u0005I\u0011\u0001B\u0017\u0011%\u0011IdBA\u0001\n\u0003\u0012Y\u0004C\u0005\u0003J\u001d\t\t\u0011\"\u0001\u0003L!I!QK\u0004\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u00057:\u0011\u0011!C!\u0005;B\u0011Ba\u0018\b\u0003\u0003%\tE!\u0019\t\u0013\t\rt!!A\u0005B\t\u0015tACBE\u0003\u0005\u0005\t\u0012\u0001.\u0004\f\u001aQ\u0011QV\u0001\u0002\u0002#\u0005!l!$\t\rytB\u0011ABS\u0011%\u0011yFHA\u0001\n\u000b\u0012\t\u0007C\u0005\u0004(z\t\t\u0011\"!\u0004*\"I1\u0011\u0017\u0010\u0002\u0002\u0013\u000551\u0017\u0005\n\u0007\u000bt\u0012\u0011!C\u0005\u0007\u000fD\u0011ba4\u0002\u0005\u0004%\t!!\u0006\t\u0011\rE\u0017\u0001)A\u0005\u0003/A\u0011ba5\u0002\u0005\u0004%\t!!\u0006\t\u0011\rU\u0017\u0001)A\u0005\u0003/A\u0001ba6\u0002\t\u0003a6\u0011\u001c\u0005\t\u0007O\fA\u0011\u0001/\u0004j\"91\u0011_\u0001\u0005\n\rMh\u0001B3[\u0001QD\u0001\u0002_\u0016\u0003\u0006\u0004%\t!\u001f\u0005\t{.\u0012\t\u0011)A\u0005u\")ap\u000bC\u0001\u007f\"9\u00111A\u0016\u0005\n\u0005\u0015\u0001\"CA\nW\t\u0007I\u0011BA\u000b\u0011!\t9c\u000bQ\u0001\n\u0005]\u0001\"CA\u0015W\t\u0007I\u0011BA\u0016\u0011!\tyd\u000bQ\u0001\n\u00055\u0002BCA!W\t\u0007I\u0011\u0001/\u0002D!A\u00111J\u0016!\u0002\u0013\t)\u0005\u0003\u0006\u0002\\-B)\u0019!C\u0005\u0003+A!\"!\u0018,\u0011\u000b\u0007I\u0011BA\u000b\u0011)\tyf\u000bEC\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003SZ#\u0019!C\u0001\u0003WB\u0001\"a\u001d,A\u0003%\u0011Q\u000e\u0005\n\u0003kZ#\u0019!C\u0005\u0003oB\u0001B!\u001b,A\u0003%\u0011\u0011\u0010\u0005\b\u0005WZC\u0011\u0002B7\u0011\u001d\u0011ih\u000bC\u0005\u0005\u007fBqA!\",\t\u000b\u00119\tC\u0004\u0003\u0006.\")A!$\t\u0011\t\u00155\u0006\"\u0002]\u0005+C\u0001Ba',\t\u000ba&Q\u0014\u0005\u000b\u0005G[\u0013\u0013!C\u00039\nm\u0001\u0002\u0003BSW\u0011\u0015ALa*\t\u0011\t-6\u0006\"\u0002]\u0005[C!Ba/,#\u0003%)\u0001\u0018B\u000e\u0011!\u0011il\u000bC\u00039\n}\u0006B\u0003BfWE\u0005IQ\u0001/\u0003\u001c!9!QZ\u0016\u0005\n\t=\u0007b\u0002BsW\u0011%!q\u001d\u0005\b\u0005[\\C\u0011\u0002Bx\u0011\u001d\u0011)p\u000bC\u0001\u0005oDqA!@,\t\u0013\u0011yP\u0002\u0004\u0004\u0006-\"1q\u0001\u0005\u000b\u0005wr%\u0011!Q\u0001\n\u0005\r\u0006B\u0003Bk\u001d\n\u0005\t\u0015!\u0003\u0002$\"Q!\u0011\u001c(\u0003\u0002\u0003\u0006I!!\f\t\rytE\u0011AB\u0005\u0011\u0019qh\n\"\u0001\u0004\u0016!911\u0004(\u0005B\ru\u0001bBB\u0011W\u0011\u0015!1\u0005\u0005\b\u0007GYCQAB\u0013\u0011\u001d\u0019Ic\u000bC\u0003\u0007WAqaa\u0011,\t\u000b\u0019)%A\u0006QKJ\u001c\u0018n\u001d;f]\u000e,'BA.]\u0003-\u0001XM]:jgR,gnY3\u000b\u0005us\u0016!\u00029fW.|'BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002e\u00035\t!LA\u0006QKJ\u001c\u0018n\u001d;f]\u000e,7#B\u0001h[\u000e\r\u0004C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'AB!osJ+g\rE\u0002ocNl\u0011a\u001c\u0006\u0003ar\u000bQ!Y2u_JL!A]8\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003I.\u001a2aK4v!\tqg/\u0003\u0002x_\nIQ\t\u001f;f]NLwN\\\u0001\u0007gf\u001cH/Z7\u0016\u0003i\u0004\"A\\>\n\u0005q|'aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M\f\t\u0001C\u0003y]\u0001\u0007!0A\u0002m_\u001e,\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004]\u0003\u0015)g/\u001a8u\u0013\u0011\t\t\"a\u0003\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u00069bj\\*oCB\u001c\bn\u001c;Ti>\u0014X\r\u00157vO&t\u0017\nZ\u000b\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0003mC:<'BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00121\u0004\u0002\u0007'R\u0014\u0018N\\4\u000219{7K\\1qg\"|Go\u0015;pe\u0016\u0004F.^4j]&#\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003[\u0001B!a\f\u0002<5\u0011\u0011\u0011\u0007\u0006\u0005\u0003S\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005e\u0012aA2p[&!\u0011QHA\u0019\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013!\u0005:fG>4XM]=QKJl\u0017\u000e\u001e;feV\u0011\u0011Q\t\t\u0004]\u0006\u001d\u0013bAA%_\nA\u0011i\u0019;peJ+g-\u0001\nsK\u000e|g/\u001a:z!\u0016\u0014X.\u001b;uKJ\u0004\u0003fA\u001b\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002Vq\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI&a\u0015\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u0017I\u00164\u0017-\u001e7u\u0015>,(O\\1m!2,x-\u001b8JI\u00069B-\u001a4bk2$8K\\1qg\"|G\u000f\u00157vO&t\u0017\nZ\u0001%I\u00164\u0017-\u001e7u\u0013:$XM\u001d8bYN#\u0018m\u001d5Pm\u0016\u0014h\r\\8x'R\u0014\u0018\r^3hsV\u0011\u00111\r\t\u0004I\u0006\u0015\u0014bAA45\n)2\u000b^1tQ>3XM\u001d4m_^\u001cFO]1uK\u001eL\u0018\u0001C:fiRLgnZ:\u0016\u0005\u00055\u0004c\u00013\u0002p%\u0019\u0011\u0011\u000f.\u0003'A+'o]5ti\u0016t7-Z*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013!\u00059mk\u001eLg.\u0012=uK:\u001c\u0018n\u001c8JIV\u0011\u0011\u0011\u0010\t\u0007\u0003w\nI)!$\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000ba!\u0019;p[&\u001c'\u0002BAB\u0003\u000b\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9)a\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\u000biHA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!!\ty)!(\u0002$\u0006\u001df\u0002BAI\u00033\u00032!a%j\u001b\t\t)JC\u0002\u0002\u0018\n\fa\u0001\u0010:p_Rt\u0014bAANS\u00061\u0001K]3eK\u001aLA!a(\u0002\"\n\u0019Q*\u00199\u000b\u0007\u0005m\u0015\u000e\u0005\u0003\u0002\u0010\u0006\u0015\u0016\u0002BA\u0013\u0003C\u0003BA\\9\u0002*B\u0019\u00111V\u0004\u000f\u0005\u0011\u0004!\u0001\u0004)mk\u001eLg\u000eS8mI\u0016\u00148cB\u0004hk\u0006E\u0016q\u0017\t\u0004Q\u0006M\u0016bAA[S\n9\u0001K]8ek\u000e$\b\u0003BA]\u0003\u0007tA!a/\u0002@:!\u00111SA_\u0013\u0005Q\u0017bAAaS\u00069\u0001/Y2lC\u001e,\u0017\u0002BAc\u0003\u000f\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1!!1j\u00031\t7\r^8s\r\u0006\u001cGo\u001c:z+\t\ti\rE\u0003i\u0003\u001f\f)%C\u0002\u0002R&\u0014\u0011BR;oGRLwN\u001c\u0019\u0002\u001b\u0005\u001cGo\u001c:GC\u000e$xN]=!\u0003!\tG-\u00199uKJ\u001cXCAAm!\u0011\tY.!9\u000e\u0005\u0005u'bAAp5\u00069!n\\;s]\u0006d\u0017\u0002BAr\u0003;\u0014Q\"\u0012<f]R\fE-\u00199uKJ\u001c\u0018!C1eCB$XM]:!)!\tI/!<\u0002p\u0006E\bcAAv\u000f5\t\u0011\u0001C\u0004\u0002J:\u0001\r!!4\t\u000f\u0005Ug\u00021\u0001\u0002Z\"9\u0011\u0011\u0006\bA\u0002\u00055\u0012\u0001B2paf$\u0002\"!;\u0002x\u0006e\u00181 \u0005\n\u0003\u0013\u0004\u0002\u0013!a\u0001\u0003\u001bD\u0011\"!6\u0011!\u0003\u0005\r!!7\t\u0013\u0005%\u0002\u0003%AA\u0002\u00055\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003QC!!4\u0003\u0004-\u0012!Q\u0001\t\u0005\u0005\u000f\u0011y!\u0004\u0002\u0003\n)!!1\u0002B\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002V%LAA!\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0003\u0016\u0005\u00033\u0014\u0019!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu!\u0006BA\u0017\u0005\u0007\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0013!\rA'qE\u0005\u0004\u0005SI'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0018\u0005k\u00012\u0001\u001bB\u0019\u0013\r\u0011\u0019$\u001b\u0002\u0004\u0003:L\b\"\u0003B\u001c-\u0005\u0005\t\u0019\u0001B\u0013\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\b\t\u0007\u0005\u007f\u0011)Ea\f\u000e\u0005\t\u0005#b\u0001B\"S\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u001d#\u0011\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003N\tM\u0003c\u00015\u0003P%\u0019!\u0011K5\u0003\u000f\t{w\u000e\\3b]\"I!q\u0007\r\u0002\u0002\u0003\u0007!qF\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0018\te\u0003\"\u0003B\u001c3\u0005\u0005\t\u0019\u0001B\u0013\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0013\u0003!!xn\u0015;sS:<GCAA\f\u0003\u0019)\u0017/^1mgR!!Q\nB4\u0011%\u00119\u0004HA\u0001\u0002\u0004\u0011y#\u0001\nqYV<\u0017N\\#yi\u0016t7/[8o\u0013\u0012\u0004\u0013a\b<fe&4\u0017PS8ve:\fG\u000e\u00157vO&t7i\u001c8gS\u001e,\u00050[:ugR1!q\u000eB;\u0005s\u00022\u0001\u001bB9\u0013\r\u0011\u0019(\u001b\u0002\u0005+:LG\u000fC\u0004\u0003xu\u0002\r!!\f\u0002\u0019AdWoZ5o\u0007>tg-[4\t\u000f\tmT\b1\u0001\u0002$\u0006Q1m\u001c8gS\u001e\u0004\u0016\r\u001e5\u0002AY,'/\u001b4z':\f\u0007o\u001d5piBcWoZ5o\u0007>tg-[4Fq&\u001cHo\u001d\u000b\u0007\u0005_\u0012\tIa!\t\u000f\t]d\b1\u0001\u0002.!9!1\u0010 A\u0002\u0005\r\u0016aC1eCB$XM]:G_J$B!!7\u0003\n\"9!1R A\u0002\u0005\r\u0016a\u00046pkJt\u0017\r\u001c)mk\u001eLg.\u00133\u0015\r\u0005e'q\u0012BI\u0011\u001d\u0011Y\t\u0011a\u0001\u0003GCqAa%A\u0001\u0004\ti#A\nk_V\u0014h.\u00197QYV<\u0017N\\\"p]\u001aLw\r\u0006\u0003\u0002Z\n]\u0005b\u0002BM\u0003\u0002\u0007\u0011QI\u0001\u0013U>,(O\\1m!2,x-\u001b8BGR|'/\u0001\tk_V\u0014h.\u00197D_:4\u0017n\u001a$peR1\u0011Q\u0006BP\u0005CCqAa#C\u0001\u0004\t\u0019\u000bC\u0005\u0003\u0014\n\u0003\n\u00111\u0001\u0002.\u0005Q\"n\\;s]\u0006d7i\u001c8gS\u001e4uN\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005I1m\u001c8gS\u001e4uN\u001d\u000b\u0005\u0003[\u0011I\u000bC\u0004\u0003\u001a\u0012\u0003\r!!\u0012\u0002\u0015)|WO\u001d8bY\u001a{'\u000f\u0006\u0004\u0002F\t=&\u0011\u0017\u0005\b\u0005\u0017+\u0005\u0019AAR\u0011%\u0011\u0019*\u0012I\u0001\u0002\u0004\ti\u0003K\u0002F\u0005k\u0003B!!\u0015\u00038&!!\u0011XA*\u0005EIe\u000e^3s]\u0006d7\u000b^1cY\u0016\f\u0005/[\u0001\u0015U>,(O\\1m\r>\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002!Mt\u0017\r]:i_R\u001cFo\u001c:f\r>\u0014HCBA#\u0005\u0003\u0014)\rC\u0004\u0003D\u001e\u0003\r!a)\u0002!Mt\u0017\r]:i_R\u0004F.^4j]&#\u0007\"\u0003Bd\u000fB\u0005\t\u0019AA\u0017\u0003Q\u0019h.\u00199tQ>$\b\u000b\\;hS:\u001cuN\u001c4jO\"\u001aqI!.\u00025Mt\u0017\r]:i_R\u001cFo\u001c:f\r>\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u001fAdWoZ5o\u0011>dG-\u001a:G_J$\u0002\"!+\u0003R\nM'q\u001b\u0005\b\u0005wJ\u0005\u0019AAR\u0011\u001d\u0011).\u0013a\u0001\u0003G\u000bABZ1mY\n\f7m\u001b)bi\"DqA!7J\u0001\u0004\ti#\u0001\tbI\u0012LG/[8oC2\u001cuN\u001c4jO\"\u001a\u0011J!8\u0011\t\t}'\u0011]\u0007\u0003\u0005\u001bIAAa9\u0003\u000e\t9A/Y5me\u0016\u001c\u0017\u0001D2sK\u0006$X\r\u00157vO&tGCBA#\u0005S\u0014Y\u000fC\u0004\u0003|)\u0003\r!a)\t\u000f\t]$\n1\u0001\u0002.\u0005q1M]3bi\u0016\fE-\u00199uKJ\u001cHCBAm\u0005c\u0014\u0019\u0010C\u0004\u0003|-\u0003\r!a)\t\u000f\te7\n1\u0001\u0002.\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012$B!a)\u0003z\"9!1 'A\u0002\u0005\u0015\u0013a\u00049feNL7\u000f^3oi\u0006\u001bGo\u001c:\u0002\u0005%$G\u0003BAR\u0007\u0003Aqaa\u0001N\u0001\u0004\t)%A\u0002sK\u001a\u0014q\u0003\u00157vO&t\u0007j\u001c7eKJ,\u0005\u0010^3og&|g.\u00133\u0014\t9;\u0017q\u0015\u000b\t\u0007\u0017\u0019ya!\u0005\u0004\u0014A\u00191Q\u0002(\u000e\u0003-BqAa\u001fS\u0001\u0004\t\u0019\u000bC\u0004\u0003VJ\u0003\r!a)\t\u000f\te'\u000b1\u0001\u0002.Q111BB\f\u00073AqAa\u001fT\u0001\u0004\t\u0019\u000bC\u0004\u0003VN\u0003\r!a)\u0002\u001f\r\u0014X-\u0019;f\u000bb$XM\\:j_:$B!!+\u0004 !)\u0001\u0010\u0016a\u0001u\u0006qa.^7cKJ|em\u00157jG\u0016\u001c\u0018!F:mS\u000e,gi\u001c:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u000b\u0005\u0005K\u00199\u0003C\u0004\u0003vZ\u0003\r!a)\u0002\u0017Md\u0017nY3SC:<Wm\u001d\u000b\u0005\u0007[\u0019y\u0004\u0005\u0004\u00040\rU2\u0011H\u0007\u0003\u0007cQAaa\r\u0003B\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0007o\u0019\tD\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004B!!/\u0004<%!1QHAd\u0005\u0015\u0011\u0016M\\4f\u0011\u001d\u0019\te\u0016a\u0001\u0005K\taB\\;nE\u0016\u0014xJ\u001a*b]\u001e,7/\u0001\bhKR\u001cF.[2f%\u0006tw-Z:\u0015\t\r\u001d3\u0011\r\t\u0007\u0007\u0013\u001aYea\u0014\u000e\u0005\u0005\u0015\u0015\u0002BB'\u0003\u000b\u0013A\u0001T5tiBA1\u0011KB,\u00077\u001aY&\u0004\u0002\u0004T)\u00191Q\u000b/\u0002\t)\f\u0007/[\u0005\u0005\u00073\u001a\u0019F\u0001\u0003QC&\u0014\b\u0003BA\r\u0007;JAaa\u0018\u0002\u001c\t9\u0011J\u001c;fO\u0016\u0014\bbBB!1\u0002\u0007!Q\u0005\t\u0004]\u000e\u0015\u0014bAB4_\n\u0019R\t\u001f;f]NLwN\\%e!J|g/\u001b3feR\t1-A\u0002hKR$2a]B8\u0011\u0019A8\u00011\u0001\u0004rA\u0019ana\u001d\n\u0007\rUtNA\u0006BGR|'oU=ti\u0016lGcA:\u0004z!1\u0001\u0010\u0002a\u0001\u0007w\u00022A\\B?\u0013\r\u0019yh\u001c\u0002\u001b\u00072\f7o]5d\u0003\u000e$xN]*zgR,W\u000e\u0015:pm&$WM\u001d\u000b\u0004g\u000e\r\u0005\"\u0002=\u0006\u0001\u0004Q\u0018A\u00027p_.,\b/F\u0001d\u00031\u0001F.^4j]\"{G\u000eZ3s!\r\tYOH\n\u0006=\r=51\u0014\t\r\u0007#\u001b9*!4\u0002Z\u00065\u0012\u0011^\u0007\u0003\u0007'S1a!&j\u0003\u001d\u0011XO\u001c;j[\u0016LAa!'\u0004\u0014\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\ru51U\u0007\u0003\u0007?SAa!)\u0002 \u0005\u0011\u0011n\\\u0005\u0005\u0003\u000b\u001cy\n\u0006\u0002\u0004\f\u0006)\u0011\r\u001d9msRA\u0011\u0011^BV\u0007[\u001by\u000bC\u0004\u0002J\u0006\u0002\r!!4\t\u000f\u0005U\u0017\u00051\u0001\u0002Z\"9\u0011\u0011F\u0011A\u0002\u00055\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0007k\u001b\t\rE\u0003i\u0007o\u001bY,C\u0002\u0004:&\u0014aa\u00149uS>t\u0007#\u00035\u0004>\u00065\u0017\u0011\\A\u0017\u0013\r\u0019y,\u001b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r\r'%!AA\u0002\u0005%\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u001a\t\u0005\u00033\u0019Y-\u0003\u0003\u0004N\u0006m!AB(cU\u0016\u001cG/A\rK_V\u0014h.\u00197GC2d'-Y2l\u0007>tg-[4QCRD\u0017A\u0007&pkJt\u0017\r\u001c$bY2\u0014\u0017mY6D_:4\u0017n\u001a)bi\"\u0004\u0013aH*oCB\u001c\bn\u001c;Ti>\u0014XMR1mY\n\f7m[\"p]\u001aLw\rU1uQ\u0006\u00013K\\1qg\"|Go\u0015;pe\u00164\u0015\r\u001c7cC\u000e\\7i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003a1XM]5gsBcWoZ5o\u0007>tg-[4Fq&\u001cHo\u001d\u000b\t\u0005_\u001aYn!8\u0004b\"9\u0011\u0011\u0006\u0015A\u0002\u00055\u0002bBBpQ\u0001\u0007\u00111U\u0001\ta2,x-\u001b8JI\"911\u001d\u0015A\u0002\u0005\r\u0016A\u00039mk\u001eLg\u000eV=qK\"\u001a\u0001&a\u0014\u00027Y,'/\u001b4z!2,x-\u001b8D_:4\u0017nZ%t\t\u00164\u0017N\\3e)\u0019\u0011yga;\u0004n\"91q\\\u0015A\u0002\u0005\r\u0006bBBrS\u0001\u0007\u00111\u0015\u0015\u0004S\u0005=\u0013aB5t\u000b6\u0004H/\u001f\u000b\u0005\u0005\u001b\u001a)\u0010C\u0004\u0004x*\u0002\r!a)\u0002\tQ,\u0007\u0010\u001e")
public class Persistence
implements Extension {
    private String defaultJournalPluginId;
    private String defaultSnapshotPluginId;
    private StashOverflowStrategy defaultInternalStashOverflowStrategy;
    private final ExtendedActorSystem system;
    private String NoSnapshotStorePluginId;
    private final Config config;
    @InternalApi
    private final ActorRef recoveryPermitter;
    private final PersistenceSettings settings;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId;
    private volatile byte bitmap$0;

    public static String SnapshotStoreFallbackConfigPath() {
        return Persistence$.MODULE$.SnapshotStoreFallbackConfigPath();
    }

    public static String JournalFallbackConfigPath() {
        return Persistence$.MODULE$.JournalFallbackConfigPath();
    }

    public static Persistence$ lookup() {
        return Persistence$.MODULE$;
    }

    public static Persistence createExtension(ExtendedActorSystem system) {
        return new Persistence(system);
    }

    public static Persistence get(ClassicActorSystemProvider system) {
        return (Persistence)ExtensionId.get$((ExtensionId)Persistence$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Persistence get(ActorSystem system) {
        return (Persistence)ExtensionId.get$((ExtensionId)Persistence$.MODULE$, (ActorSystem)system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)Persistence$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)Persistence$.MODULE$, (ActorSystem)system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter org$apache$pekko$persistence$Persistence$$log() {
        return Logging$.MODULE$.apply((ActorSystem)this.system(), Persistence.class, LogSource$.MODULE$.fromClass());
    }

    private String NoSnapshotStorePluginId() {
        return this.NoSnapshotStorePluginId;
    }

    private Config config() {
        return this.config;
    }

    public ActorRef recoveryPermitter() {
        return this.recoveryPermitter;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultJournalPluginId$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var1_1;
                String configPath = this.config().getString("journal.plugin");
                Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
                this.verifyJournalPluginConfigExists(ConfigFactory.empty(), configPath);
                this.defaultJournalPluginId = var1_1;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultJournalPluginId;
    }

    private String defaultJournalPluginId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.defaultJournalPluginId$lzycompute();
        }
        return this.defaultJournalPluginId;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultSnapshotPluginId$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String string;
                String configPath = this.config().getString("snapshot-store.plugin");
                if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(configPath)) {
                    this.org$apache$pekko$persistence$Persistence$$log().warning("No default snapshot store configured! To configure a default snapshot-store plugin set the `pekko.persistence.snapshot-store.plugin` key. For details see 'reference.conf'");
                    string = this.NoSnapshotStorePluginId();
                } else {
                    void var1_1;
                    this.verifySnapshotPluginConfigExists(ConfigFactory.empty(), configPath);
                    string = var1_1;
                }
                this.defaultSnapshotPluginId = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.NoSnapshotStorePluginId = null;
        return this.defaultSnapshotPluginId;
    }

    private String defaultSnapshotPluginId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.defaultSnapshotPluginId$lzycompute();
        }
        return this.defaultSnapshotPluginId;
    }

    private StashOverflowStrategy defaultInternalStashOverflowStrategy$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.defaultInternalStashOverflowStrategy = (StashOverflowStrategy)this.system().dynamicAccess().createInstanceFor(this.config().getString("internal-stash-overflow-strategy"), (scala.collection.immutable.Seq)Collections.EmptyImmutableSeq$.MODULE$, ClassTag$.MODULE$.apply(StashOverflowStrategyConfigurator.class)).map((Function1 & Serializable)x$1 -> x$1.create(this.system().settings().config())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public StashOverflowStrategy defaultInternalStashOverflowStrategy() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.defaultInternalStashOverflowStrategy$lzycompute();
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public PersistenceSettings settings() {
        return this.settings;
    }

    private AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId() {
        return this.pluginExtensionId;
    }

    private void verifyJournalPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Journal");
    }

    private void verifySnapshotPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Snapshot store");
    }

    public final EventAdapters adaptersFor(String journalPluginId) {
        return this.adaptersFor(journalPluginId, ConfigFactory.empty());
    }

    public final EventAdapters adaptersFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).adapters();
    }

    public final EventAdapters adaptersFor(ActorRef journalPluginActor) {
        Option option = ((MapOps)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new Serializable(this, journalPluginActor){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$1;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return (B1)((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).adapters();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$1 = journalPluginActor$1;
            }
        });
        if (option instanceof Some) {
            return (EventAdapters)((Some)option).value();
        }
        return IdentityEventAdapters$.MODULE$;
    }

    public final Config journalConfigFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).config();
    }

    public final Config journalConfigFor$default$2() {
        return ConfigFactory.empty();
    }

    public final Config configFor(ActorRef journalPluginActor) {
        Option option = ((MapOps)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new Serializable(this, journalPluginActor){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$2;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return (B1)((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).config();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$2 = journalPluginActor$2;
            }
        });
        if (option instanceof Some) {
            return (Config)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin actor ").append(journalPluginActor).toString());
        }
        throw new MatchError((Object)option);
    }

    @InternalStableApi
    public final ActorRef journalFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).actor();
    }

    public final Config journalFor$default$2() {
        return ConfigFactory.empty();
    }

    @InternalStableApi
    public final ActorRef snapshotStoreFor(String snapshotPluginId, Config snapshotPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(snapshotPluginId) ? this.defaultSnapshotPluginId() : snapshotPluginId;
        this.verifySnapshotPluginConfigExists(snapshotPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.SnapshotStoreFallbackConfigPath(), snapshotPluginConfig).actor();
    }

    public final Config snapshotStoreFor$default$2() {
        return ConfigFactory.empty();
    }

    private PluginHolder pluginHolderFor(String configPath, String fallbackPath, Config additionalConfig) {
        Option option;
        while (true) {
            Map<String, ExtensionId<PluginHolder>> extensionIdMap;
            if ((option = (extensionIdMap = this.pluginExtensionId().get()).get((Object)configPath)) instanceof Some) {
                return (PluginHolder)((ExtensionId)((Some)option).value()).apply((ActorSystem)this.system());
            }
            if (!None$.MODULE$.equals(option)) break;
            PluginHolderExtensionId extensionId = new PluginHolderExtensionId(this, configPath, fallbackPath, additionalConfig);
            this.pluginExtensionId().compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
        }
        throw new MatchError((Object)option);
    }

    public ActorRef org$apache$pekko$persistence$Persistence$$createPlugin(String configPath, Config pluginConfig) {
        .colon.colon colon2;
        String pluginDispatcherId;
        Class pluginClass;
        block7: {
            String pluginClassName = pluginConfig.getString("class");
            if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(pluginClassName)) {
                throw new IllegalArgumentException(new StringBuilder(61).append("Plugin class name must be defined in config property [").append(configPath).append(".class]").toString());
            }
            this.org$apache$pekko$persistence$Persistence$$log().debug(new StringBuilder(16).append("Create plugin: ").append(configPath).append(" ").append(pluginClassName).toString());
            pluginClass = (Class)this.system().dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.Any()).get();
            pluginDispatcherId = pluginConfig.getString("plugin-dispatcher");
            try {
                Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$)));
                colon2 = new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$));
            }
            catch (Throwable throwable) {
                if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                    try {
                        Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$));
                        colon2 = new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$);
                    }
                    catch (Throwable throwable2) {
                        if (throwable2 != null && !NonFatal$.MODULE$.unapply(throwable2).isEmpty()) {
                            colon2 = Nil$.MODULE$;
                            break block7;
                        }
                        throw throwable2;
                    }
                }
                throw throwable;
            }
        }
        .colon.colon pluginActorArgs = colon2;
        String x$2 = "";
        Config x$3 = ConfigFactory.empty();
        NoRouter$ x$4 = NoRouter$.MODULE$;
        NoScopeGiven$ x$5 = NoScopeGiven$.MODULE$;
        String x$6 = "";
        Props pluginActorProps = new Props(Deploy$.MODULE$.apply(x$2, x$3, (RouterConfig)x$4, (Scope)x$5, pluginDispatcherId, x$6), pluginClass, (scala.collection.immutable.Seq)pluginActorArgs);
        return this.system().systemActorOf(pluginActorProps, configPath);
    }

    public EventAdapters org$apache$pekko$persistence$Persistence$$createAdapters(String configPath, Config additionalConfig) {
        Config pluginConfig = additionalConfig.withFallback((ConfigMergeable)this.system().settings().config()).getConfig(configPath);
        return EventAdapters$.MODULE$.apply(this.system(), pluginConfig);
    }

    public String persistenceId(ActorRef persistentActor) {
        return this.id(persistentActor);
    }

    private String id(ActorRef ref) {
        return ref.path().toStringWithoutAddress();
    }

    public final int numberOfSlices() {
        return 1024;
    }

    public final int sliceForPersistenceId(String persistenceId) {
        return package$.MODULE$.abs(persistenceId.hashCode() % 1024);
    }

    public final IndexedSeq<Range> sliceRanges(int numberOfRanges) {
        int rangeSize = 1024 / numberOfRanges;
        Predef$.MODULE$.require(numberOfRanges * rangeSize == 1024, (Function0 & Serializable)() -> new StringBuilder(70).append("numberOfRanges [").append(numberOfRanges).append("] must be a whole number divisor of numberOfSlices [").append(1024).append("].").toString());
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRanges).map((Function1 & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)i) * rangeSize), BoxesRunTime.unboxToInt((Object)i) * rangeSize + rangeSize)).toVector();
    }

    public final java.util.List<Pair<Integer, Integer>> getSliceRanges(int numberOfRanges) {
        return AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)package.JavaConverters$.MODULE$, (Seq)((Seq)this.sliceRanges(numberOfRanges).map((Function1 & Serializable)range -> new Pair((Object)range.min((Ordering)Ordering.Int$.MODULE$), (Object)range.max((Ordering)Ordering.Int$.MODULE$))))).asJava();
    }

    public Persistence(ExtendedActorSystem system) {
        this.system = system;
        this.NoSnapshotStorePluginId = "pekko.persistence.no-snapshot-store";
        this.config = system.settings().config().getConfig("pekko.persistence");
        int maxPermits = this.config().getInt("max-concurrent-recoveries");
        this.recoveryPermitter = system.systemActorOf(RecoveryPermitter$.MODULE$.props(maxPermits), "recoveryPermitter");
        this.settings = new PersistenceSettings(this.config());
        this.pluginExtensionId = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.config().getStringList("journal.auto-start-journals").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting journal plugin `").append(id).append("`").toString());
                if (this.$outer == null) {
                    throw null;
                }
                this.$outer.journalFor(id, ConfigFactory.empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.config().getStringList("snapshot-store.auto-start-snapshot-stores").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting snapshot store `").append(id).append("`").toString());
                if (this.$outer == null) {
                    throw null;
                }
                this.$outer.snapshotStoreFor(id, ConfigFactory.empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class PluginHolder
    implements Extension,
    Product,
    Serializable {
        private ActorRef actor;
        private final Function0<ActorRef> actorFactory;
        private final EventAdapters adapters;
        private final Config config;
        private volatile boolean bitmap$0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function0<ActorRef> actorFactory() {
            return this.actorFactory;
        }

        public EventAdapters adapters() {
            return this.adapters;
        }

        public Config config() {
            return this.config;
        }

        private ActorRef actor$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.actor = (ActorRef)this.actorFactory().apply();
                    this.bitmap$0 = true;
                }
            }
            return this.actor;
        }

        public ActorRef actor() {
            if (!this.bitmap$0) {
                return this.actor$lzycompute();
            }
            return this.actor;
        }

        public PluginHolder copy(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            return new PluginHolder(actorFactory, adapters, config);
        }

        public Function0<ActorRef> copy$default$1() {
            return this.actorFactory();
        }

        public EventAdapters copy$default$2() {
            return this.adapters();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.actorFactory();
                }
                case 1: {
                    return this.adapters();
                }
                case 2: {
                    return this.config();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PluginHolder;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "actorFactory";
                }
                case 1: {
                    return "adapters";
                }
                case 2: {
                    return "config";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PluginHolder)) break block3;
                    PluginHolder pluginHolder = (PluginHolder)x$1;
                    Function0<ActorRef> function0 = this.actorFactory();
                    Function0<ActorRef> function02 = pluginHolder.actorFactory();
                    if (function0 != null ? !function0.equals(function02) : function02 != null) break block3;
                    EventAdapters eventAdapters = this.adapters();
                    EventAdapters eventAdapters2 = pluginHolder.adapters();
                    if (eventAdapters != null ? !eventAdapters.equals(eventAdapters2) : eventAdapters2 != null) break block3;
                    Config config = this.config();
                    Config config2 = pluginHolder.config();
                    if ((config != null ? !config.equals(config2) : config2 != null) || !pluginHolder.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PluginHolder(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            this.actorFactory = actorFactory;
            this.adapters = adapters;
            this.config = config;
            Product.$init$((Product)this);
        }
    }

    private class PluginHolderExtensionId
    implements ExtensionId<PluginHolder> {
        private final String configPath;
        private final String fallbackPath;
        private final Config additionalConfig;
        public final /* synthetic */ Persistence $outer;

        public Extension apply(ActorSystem system) {
            return ExtensionId.apply$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension apply(ClassicActorSystemProvider system) {
            return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public Extension get(ActorSystem system) {
            return ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension get(ClassicActorSystemProvider system) {
            return ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public final int hashCode() {
            return ExtensionId.hashCode$((ExtensionId)this);
        }

        public final boolean equals(Object other) {
            return ExtensionId.equals$((ExtensionId)this, (Object)other);
        }

        public PluginHolder createExtension(ExtendedActorSystem system) {
            Config mergedConfig = this.additionalConfig.withFallback((ConfigMergeable)system.settings().config());
            Predef$.MODULE$.require(!Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(this.configPath) && mergedConfig.hasPath(this.configPath), (Function0 & Serializable)() -> new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append($this.configPath).append("'").toString());
            Config config = mergedConfig.getConfig(this.configPath).withFallback((ConfigMergeable)mergedConfig.getConfig(this.fallbackPath));
            Function0 & Serializable pluginActorFactory = (Function0 & Serializable)() -> this.org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer().org$apache$pekko$persistence$Persistence$$createPlugin($this.configPath, config);
            EventAdapters adapters = this.org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer().org$apache$pekko$persistence$Persistence$$createAdapters(this.configPath, mergedConfig);
            return new PluginHolder((Function0<ActorRef>)pluginActorFactory, adapters, config);
        }

        public /* synthetic */ Persistence org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer() {
            return this.$outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath, Config additionalConfig) {
            this.configPath = configPath;
            this.fallbackPath = fallbackPath;
            this.additionalConfig = additionalConfig;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath) {
            this($outer, configPath, fallbackPath, ConfigFactory.empty());
        }
    }
}

