/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal.leveldb;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.persistence.journal.leveldb.Key;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Key$
implements Serializable {
    public static final Key$ MODULE$ = new Key$();

    public byte[] keyToBytes(Key key) {
        ByteBuffer bb = ByteBuffer.allocate(20);
        bb.putInt(key.persistenceId());
        bb.putLong(key.sequenceNr());
        bb.putInt(key.mappingId());
        return bb.array();
    }

    public Key keyFromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int aid = bb.getInt();
        long snr = bb.getLong();
        int mid = bb.getInt();
        return new Key(aid, snr, mid);
    }

    public Key counterKey(int persistenceId) {
        return new Key(persistenceId, 0L, 0);
    }

    public byte[] counterToBytes(long ctr) {
        return ByteBuffer.allocate(8).putLong(ctr).array();
    }

    public long counterFromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public Key mappingKey(int id) {
        return new Key(1, 0L, id);
    }

    public boolean isMappingKey(Key key) {
        return key.persistenceId() == 1;
    }

    public Key deletionKey(int persistenceId, long sequenceNr) {
        return new Key(persistenceId, sequenceNr, 1);
    }

    public boolean isDeletionKey(Key key) {
        return key.mappingId() == 1;
    }

    public Key apply(int persistenceId, long sequenceNr, int mappingId) {
        return new Key(persistenceId, sequenceNr, mappingId);
    }

    public Option<Tuple3<Object, Object, Object>> unapply(Key x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.persistenceId()), (Object)BoxesRunTime.boxToLong((long)x$0.sequenceNr()), (Object)BoxesRunTime.boxToInteger((int)x$0.mappingId())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Key$.class);
    }

    private Key$() {
    }
}

