/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.persistence.serialization.SnapshotAutoMigration;
import org.apache.pekko.persistence.serialization.SnapshotAutoMigration$;
import org.apache.pekko.persistence.serialization.SnapshotAutoMigration$Akka$;
import org.apache.pekko.persistence.serialization.SnapshotAutoMigration$NoMigration$;
import org.apache.pekko.persistence.serialization.SnapshotAutoMigration$Pekko$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ByteString$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\n\u0014\u0001yA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005Y!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0003J\u0004BB\u001f\u0001A\u0003%!\b\u0003\u0005\u0015\u0001!\u0015\r\u0011\"\u0003?\u0011!\u0011\u0005\u0001#b\u0001\n\u0013\u0019\u0005\"B$\u0001\t\u0003A\u0005\"B)\u0001\t\u0003\u0011\u0006\"B9\u0001\t\u0013\u0011\b\"\u0002>\u0001\t\u0013Y\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\t\u00112K\\1qg\"|GoU3sS\u0006d\u0017N_3s\u0015\t!R#A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003-]\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011\u0001$G\u0001\u0006a\u0016\\7n\u001c\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M!j\u0011a\n\u0006\u0003)]I!!K\u0014\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\u000611/_:uK6,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_]\tQ!Y2u_JL!!\r\u0018\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u00051A(\u001b8jiz\"\"!N\u001c\u0011\u0005Y\u0002Q\"A\n\t\u000b)\u001a\u0001\u0019\u0001\u0017\u0002\u001f%t7\r\\;eK6\u000bg.\u001b4fgR,\u0012A\u000f\t\u0003AmJ!\u0001P\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0012N\\2mk\u0012,W*\u00198jM\u0016\u001cH\u000fI\u000b\u0002\u007fA\u0011a\u0005Q\u0005\u0003\u0003\u001e\u0012QbU3sS\u0006d\u0017N_1uS>t\u0017!E7jOJ\fG/[8o'R\u0014\u0018\r^3hsV\tA\t\u0005\u00027\u000b&\u0011ai\u0005\u0002\u0016':\f\u0007o\u001d5pi\u0006+Ho\\'jOJ\fG/[8o\u0003!!xNQ5oCJLHCA%P!\r\u0001#\nT\u0005\u0003\u0017\u0006\u0012Q!\u0011:sCf\u0004\"\u0001I'\n\u00059\u000b#\u0001\u0002\"zi\u0016DQ\u0001\u0015\u0005A\u0002}\t\u0011a\\\u0001\u000bMJ|WNQ5oCJLHcA\u0010T+\")A+\u0003a\u0001\u0013\u0006)!-\u001f;fg\")a+\u0003a\u0001/\u0006AQ.\u00198jM\u0016\u001cH\u000fE\u0002!1jK!!W\u0011\u0003\r=\u0003H/[8oa\tY\u0006\u000eE\u0002]G\u001at!!X1\u0011\u0005y\u000bS\"A0\u000b\u0005\u0001l\u0012A\u0002\u001fs_>$h(\u0003\u0002cC\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\u000b\rc\u0017m]:\u000b\u0005\t\f\u0003CA4i\u0019\u0001!\u0011\"[+\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#\u0013'\u0005\u0002l]B\u0011\u0001\u0005\\\u0005\u0003[\u0006\u0012qAT8uQ&tw\r\u0005\u0002!_&\u0011\u0001/\t\u0002\u0004\u0003:L\u0018A\u00045fC\u0012,'\u000fV8CS:\f'/\u001f\u000b\u0004\u0013N,\b\"\u0002;\u000b\u0001\u0004y\u0012\u0001C:oCB\u001c\bn\u001c;\t\u000bYT\u0001\u0019A<\u0002%Mt\u0017\r]:i_R\u001cVM]5bY&TXM\u001d\t\u0003MaL!!_\u0014\u0003\u0015M+'/[1mSj,'/\u0001\tiK\u0006$WM\u001d$s_6\u0014\u0015N\\1ssR\u0019A0a\u0003\u0011\u000b\u0001jx0!\u0002\n\u0005y\f#A\u0002+va2,'\u0007E\u0002!\u0003\u0003I1!a\u0001\"\u0005\rIe\u000e\u001e\t\u00049\u0006\u001d\u0011bAA\u0005K\n11\u000b\u001e:j]\u001eDQ\u0001V\u0006A\u0002%\u000b!$\\5he\u0006$X-T1oS\u001a,7\u000f^%g\u001d\u0016\u001cWm]:bef$B!!\u0002\u0002\u0012!1a\u000b\u0004a\u0001\u0003\u000b\t\u0011%\\5he\u0006$X-T1oS\u001a,7\u000f\u001e+p!\u0016\\7n\\%g\u001d\u0016\u001cWm]:bef$B!!\u0002\u0002\u0018!1a+\u0004a\u0001\u0003\u000b\t\u0001c\u001d8baNDw\u000e\u001e+p\u0005&t\u0017M]=\u0015\u0007%\u000bi\u0002C\u0003u\u001d\u0001\u0007q$\u0001\nt]\u0006\u00048\u000f[8u\rJ|WNQ5oCJLHcA\u0010\u0002$!)Ak\u0004a\u0001\u0013\u0006AqO]5uK&sG\u000f\u0006\u0004\u0002*\u0005=\u00121\t\t\u0004A\u0005-\u0012bAA\u0017C\t!QK\\5u\u0011\u001d\t\t\u0004\u0005a\u0001\u0003g\t1a\\;u!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t!![8\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u00028\taq*\u001e;qkR\u001cFO]3b[\"1\u0011Q\t\tA\u0002}\f\u0011![\u0001\be\u0016\fG-\u00138u)\ry\u00181\n\u0005\b\u0003\u001b\n\u0002\u0019AA(\u0003\tIg\u000e\u0005\u0003\u00026\u0005E\u0013\u0002BA*\u0003o\u00111\"\u00138qkR\u001cFO]3b[\u0002")
public class SnapshotSerializer
implements BaseSerializer {
    private Serialization serialization;
    private SnapshotAutoMigration migrationStrategy;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private int identifier;
    private volatile byte bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)ExtensionId.apply$((ExtensionId)SerializationExtension$.MODULE$, (ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private SnapshotAutoMigration migrationStrategy$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.migrationStrategy = SnapshotAutoMigration$.MODULE$.fromString(this.system().settings().config().getString(SnapshotAutoMigration$.MODULE$.ConfigName()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.migrationStrategy;
    }

    private SnapshotAutoMigration migrationStrategy() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.migrationStrategy$lzycompute();
        }
        return this.migrationStrategy;
    }

    public byte[] toBinary(Object o) {
        if (o instanceof Snapshot) {
            Object data = ((Snapshot)o).data();
            return this.snapshotToBinary(data);
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, snapshotSerializer.identifier());
        String ms = this.migrateManifestIfNecessary(Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshot));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            out.write(ms.getBytes(ByteString$.MODULE$.UTF_8()));
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException("Replaying snapshot from akka 2.3.x version is not supported any more");
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = this.migrateManifestToPekkoIfNecessary(new String(manifestBytes, ByteString$.MODULE$.UTF_8()));
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private String migrateManifestIfNecessary(String manifest) {
        SnapshotAutoMigration snapshotAutoMigration = this.migrationStrategy();
        if (SnapshotAutoMigration$NoMigration$.MODULE$.equals(snapshotAutoMigration)) {
            return manifest;
        }
        if (SnapshotAutoMigration$Pekko$.MODULE$.equals(snapshotAutoMigration)) {
            if (manifest.startsWith("akka")) {
                return manifest.replaceFirst("akka", "org.apache.pekko");
            }
            return manifest;
        }
        if (SnapshotAutoMigration$Akka$.MODULE$.equals(snapshotAutoMigration)) {
            if (manifest.startsWith("org.apache.pekko")) {
                return manifest.replaceFirst("org.apache.pekko", "akka");
            }
            return manifest;
        }
        throw new MatchError((Object)snapshotAutoMigration);
    }

    private String migrateManifestToPekkoIfNecessary(String manifest) {
        SnapshotAutoMigration snapshotAutoMigration = this.migrationStrategy();
        if (SnapshotAutoMigration$NoMigration$.MODULE$.equals(snapshotAutoMigration)) {
            return manifest;
        }
        if (manifest.startsWith("akka")) {
            return manifest.replaceFirst("akka", "org.apache.pekko");
        }
        return manifest;
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            byArray = this.serialize$1(snapshot);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private Object snapshotFromBinary(byte[] bytes) {
        void var7_7;
        void var6_6;
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), 4, headerLength + 4);
        byte[] snapshotBytes = (byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps(bytes), headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int serializerId = tuple2._1$mcI$sp();
        String manifest = (String)tuple2._2();
        return this.serialization().deserialize(snapshotBytes, (int)var6_6, (String)var7_7).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
        Statics.releaseFence();
    }
}

