/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.persistence.journal.EventAdapter;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.IdentityEventAdapters$;
import org.apache.pekko.persistence.journal.NoopReadEventAdapter;
import org.apache.pekko.persistence.journal.NoopWriteEventAdapter;
import org.apache.pekko.persistence.journal.ReadEventAdapter;
import org.apache.pekko.persistence.journal.WriteEventAdapter;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

public final class EventAdapters$ {
    public static final EventAdapters$ MODULE$ = new EventAdapters$();

    public EventAdapters apply(ExtendedActorSystem system, Config config) {
        scala.collection.immutable.Map<String, String> adapters = this.configToMap(config, "event-adapters");
        scala.collection.immutable.Map<String, Seq<String>> adapterBindings = this.configToListMap(config, "event-adapter-bindings");
        if (adapters.isEmpty() && adapterBindings.isEmpty()) {
            return IdentityEventAdapters$.MODULE$;
        }
        return this.apply(system, adapters, adapterBindings);
    }

    private EventAdapters apply(ExtendedActorSystem system, scala.collection.immutable.Map<String, String> adapters, scala.collection.immutable.Map<String, Seq<String>> adapterBindings) {
        Set adapterNames = adapters.keys().toSet();
        adapterBindings.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)EventAdapters$.$anonfun$apply$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            EventAdapters$.$anonfun$apply$2(adapterNames, adapters, x$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map handlers = (scala.collection.immutable.Map)adapters.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)EventAdapters$.$anonfun$apply$5(check$ifrefutable$2))).map((Function1 & Serializable)x$3 -> {
            if (x$3 != null) {
                String k = (String)x$3._1();
                String v = (String)x$3._2();
                if (k != null && v != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), MODULE$.instantiateAdapter(v, system).get());
                }
            }
            throw new MatchError(x$3);
        });
        scala.collection.immutable.Map bs = (scala.collection.immutable.Map)adapterBindings.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)EventAdapters$.$anonfun$apply$7(check$ifrefutable$3))).map((Function1 & Serializable)x$4 -> {
            if (x$4 != null) {
                String k = (String)x$4._1();
                Seq as = (Seq)x$4._2();
                if (k != null && as != null) {
                    if (as.size() == 1) {
                        return new Tuple2(system.dynamicAccess().getClassFor(k, ClassTag$.MODULE$.Any()).get(), handlers.apply(as.head()));
                    }
                    return new Tuple2(system.dynamicAccess().getClassFor(k, ClassTag$.MODULE$.Any()).get(), (Object)new NoopWriteEventAdapter(new EventAdapters.CombinedReadEventAdapter((Seq<EventAdapter>)((Seq)as.map((Function1)handlers)))));
                }
            }
            throw new MatchError(x$4);
        });
        Seq bindings = this.sort((Iterable)bs);
        ConcurrentHashMap backing = (ConcurrentHashMap)bindings.foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 != null) {
                Class c = (Class)x1$1._1();
                EventAdapter s = (EventAdapter)x1$1._2();
                x0$1.put(c, s);
                return x0$1;
            }
            throw new MatchError((Object)tuple2);
        });
        return new EventAdapters(backing, bindings, Logging$.MODULE$.apply((ActorSystem)system, EventAdapters.class, LogSource$.MODULE$.fromClass()));
    }

    public Try<EventAdapter> instantiateAdapter(String adapterFQN, ExtendedActorSystem system) {
        Class clazz = (Class)system.dynamicAccess().getClassFor(adapterFQN, ClassTag$.MODULE$.Any()).get();
        if (EventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(EventAdapter.class));
        }
        if (WriteEventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(WriteEventAdapter.class)).map((Function1 & Serializable)writeEventAdapter -> new NoopReadEventAdapter((WriteEventAdapter)writeEventAdapter));
        }
        if (ReadEventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(ReadEventAdapter.class)).map((Function1 & Serializable)readEventAdapter -> new NoopWriteEventAdapter((ReadEventAdapter)readEventAdapter));
        }
        throw new IllegalArgumentException(new StringBuilder(58).append("Configured ").append(adapterFQN).append(" does not implement any EventAdapter interface!").toString());
    }

    private <T> Try<T> instantiate(String fqn, ExtendedActorSystem system, ClassTag<T> evidence$1) {
        return system.dynamicAccess().createInstanceFor(fqn, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)system), (List)Nil$.MODULE$), evidence$1).recoverWith((PartialFunction)new Serializable(system, fqn, evidence$1){
            private static final long serialVersionUID = 0L;
            private final ExtendedActorSystem system$2;
            private final String fqn$2;
            private final ClassTag evidence$1$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof NoSuchMethodException) {
                    return (B1)this.system$2.dynamicAccess().createInstanceFor(this.fqn$2, (Seq)Nil$.MODULE$, this.evidence$1$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof NoSuchMethodException;
            }
            {
                this.system$2 = system$2;
                this.fqn$2 = fqn$2;
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    private <T> Seq<Tuple2<Class<?>, T>> sort(Iterable<Tuple2<Class<?>, T>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)EventAdapters$.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append(ca);
                    break;
                }
                default: {
                    buf.insert(n, ca);
                }
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private final scala.collection.immutable.Map<String, String> configToMap(Config config, String path) {
        if (config.hasPath(path)) {
            return (scala.collection.immutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Map)config.getConfig(path).root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                }
                throw new MatchError(null);
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    private final scala.collection.immutable.Map<String, Seq<String>> configToListMap(Config config, String path) {
        if (config.hasPath(path)) {
            return (scala.collection.immutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Map)config.getConfig(path).root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ArrayList arrayList;
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    if (v instanceof ArrayList && (arrayList = (ArrayList)v) instanceof ArrayList) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (java.util.List)arrayList).asScala().map((Function1 & Serializable)x$8 -> x$8.toString())).toList());
                    }
                }
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new .colon.colon((Object)v.toString(), (List)Nil$.MODULE$));
                }
                throw new MatchError(null);
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$apply$2(Set adapterNames$1, scala.collection.immutable.Map adapters$1, Tuple2 x$2) {
        if (x$2 != null) {
            String fqn = (String)x$2._1();
            Seq boundToAdapters = (Seq)x$2._2();
            boundToAdapters.foreach((Function1 & Serializable)boundAdapter -> {
                Predef$.MODULE$.require(adapterNames$1.apply((Object)boundAdapter.toString()), (Function0 & Serializable)() -> new StringBuilder(70).append(fqn$1).append(" was bound to undefined event-adapter: ").append(boundAdapter).append(" (bindings: ").append(boundToAdapters$1.mkString("[", ", ", "]")).append(", known adapters: ").append(adapters$1.keys().mkString()).append(")").toString());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            String k = (String)check$ifrefutable$2._1();
            String v = (String)check$ifrefutable$2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(Tuple2 check$ifrefutable$3) {
        if (check$ifrefutable$3 != null) {
            String k = (String)check$ifrefutable$3._1();
            Seq as = (Seq)check$ifrefutable$3._2();
            if (k != null && as != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    private EventAdapters$() {
    }
}

