/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.management.cluster.bootstrap.BootstrapLogMarker$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.JoinDecision;
import org.apache.pekko.management.cluster.bootstrap.JoinOtherSeedNodes;
import org.apache.pekko.management.cluster.bootstrap.JoinSelf$;
import org.apache.pekko.management.cluster.bootstrap.KeepProbing$;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesInformation;
import org.apache.pekko.management.cluster.bootstrap.SelfAwareJoinDecider;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005a4AAC\u0006\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015y\u0004\u0001\"\u0005A\u0011\u0015\u0001\u0006\u0001\"\u0005R\u0011\u00159\u0006\u0001\"\u0005Y\u0011\u0015Q\u0006\u0001\"\u0005\\\u0011\u0015!\u0007\u0001\"\u0005f\u0005aaun^3ti\u0006#GM]3tg*{\u0017N\u001c#fG&$WM\u001d\u0006\u0003\u00195\t\u0011BY8piN$(/\u00199\u000b\u00059y\u0011aB2mkN$XM\u001d\u0006\u0003!E\t!\"\\1oC\u001e,W.\u001a8u\u0015\t\u00112#A\u0003qK.\\wN\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003)M+GNZ!xCJ,'j\\5o\t\u0016\u001c\u0017\u000eZ3s\u0003\u0019\u0019\u0018p\u001d;f[B\u0011qDI\u0007\u0002A)\u0011\u0011%E\u0001\u0006C\u000e$xN]\u0005\u0003G\u0001\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006A1/\u001a;uS:<7\u000f\u0005\u0002\u001bM%\u0011qe\u0003\u0002\u0019\u00072,8\u000f^3s\u0005>|Go\u001d;sCB\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"A\u0007\u0001\t\u000bu\u0019\u0001\u0019\u0001\u0010\t\u000b\u0011\u001a\u0001\u0019A\u0013\u0002\r\u0011,7-\u001b3f)\ty#\bE\u00021k]j\u0011!\r\u0006\u0003eM\n!bY8oGV\u0014(/\u001a8u\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c2\u0005\u00191U\u000f^;sKB\u0011!\u0004O\u0005\u0003s-\u0011ABS8j]\u0012+7-[:j_:DQa\u000f\u0003A\u0002q\nA!\u001b8g_B\u0011!$P\u0005\u0003}-\u0011AcU3fI:{G-Z:J]\u001a|'/\\1uS>t\u0017A\u00056pS:|E\u000f[3s'\u0016,GMT8eKN$\"!Q(\u0011\u0007\tKEJ\u0004\u0002D\u000fB\u0011AiM\u0007\u0002\u000b*\u0011aiF\u0001\u0007yI|w\u000e\u001e \n\u0005!\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n\u00191+\u001a;\u000b\u0005!\u001b\u0004CA\u0010N\u0013\tq\u0005EA\u0004BI\u0012\u0014Xm]:\t\u000bm*\u0001\u0019\u0001\u001f\u0002-!\f7/\u00128pk\u001eD7i\u001c8uC\u000e$\bk\\5oiN$\"A\u0015,\u0011\u0005M#V\"A\u001a\n\u0005U\u001b$a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u0019\u0001\r\u0001P\u0001\u0013SN\u0004\u0016m\u001d;Ti\u0006\u0014G.Z'be\u001eLg\u000e\u0006\u0002S3\")1h\u0002a\u0001y\u0005!\u0014n]\"p]\u001aL'/\\3e\u0007>lW.\u001e8jG\u0006$\u0018n\u001c8XSRD\u0017\t\u001c7D_:$\u0018m\u0019;Q_&tGo\u001d*fcVL'/\u001a3\u0015\u0005Ic\u0006\"B\u001e\t\u0001\u0004a\u0004F\u0001/_!\ty&-D\u0001a\u0015\t\t\u0017#\u0001\u0003vi&d\u0017BA2a\u0005\u0019)h.^:fI\u0006IBn\\<fgR\fE\r\u001a:fgN\u001cuN\u001c;bGR\u0004v.\u001b8u)\t1w\u000fE\u0002TO&L!\u0001[\u001a\u0003\r=\u0003H/[8o!\tQGO\u0004\u0002lc:\u0011An\u001c\b\u0003[:l\u0011aE\u0005\u0003%MI!\u0001]\t\u0002\u0013\u0011L7oY8wKJL\u0018B\u0001:t\u0003A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018P\u0003\u0002q#%\u0011QO\u001e\u0002\u000f%\u0016\u001cx\u000e\u001c<fIR\u000b'oZ3u\u0015\t\u00118\u000fC\u0003<\u0013\u0001\u0007A\b")
public class LowestAddressJoinDecider
extends SelfAwareJoinDecider {
    private final ClusterBootstrapSettings settings;

    @Override
    public Future<JoinDecision> decide(SeedNodesInformation info) {
        Set contactPointsWithoutSeedNodesObservations;
        if (info.hasSeedNodes()) {
            Set<Address> seeds = this.joinOtherSeedNodes(info);
            if (seeds.isEmpty()) {
                return KeepProbing$.MODULE$.asCompletedFuture();
            }
            return new JoinOtherSeedNodes(seeds).asCompletedFuture();
        }
        if (!this.hasEnoughContactPoints(info)) {
            this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Discovered [{}] contact points, confirmed [{}], which is less than the required [{}], retrying", (Object)BoxesRunTime.boxToInteger((int)info.contactPoints().size()), (Object)BoxesRunTime.boxToInteger((int)info.seedNodesObservations().size()), (Object)BoxesRunTime.boxToInteger((int)this.settings.contactPointDiscovery().requiredContactPointsNr()));
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        if (!this.isPastStableMargin(info)) {
            this.log().debug(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Contact points observations have changed more recently than the stable-margin [{}], changed at [{}], not joining myself. This process will be retried.", (Object)this.settings.contactPointDiscovery().stableMargin(), (Object)info.contactPointsChangedAt());
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        Set set = contactPointsWithoutSeedNodesObservations = this.isConfirmedCommunicationWithAllContactPointsRequired(info) ? (Set)info.contactPoints().$minus$minus((IterableOnce)info.seedNodesObservations().map((Function1 & Serializable)x$1 -> x$1.contactPoint())) : Predef$.MODULE$.Set().empty();
        if (contactPointsWithoutSeedNodesObservations.isEmpty()) {
            Option<ServiceDiscovery.ResolvedTarget> lowestAddress = this.lowestAddressContactPoint(info);
            if (lowestAddress.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)this.canJoinSelf(x$2, info))) && this.settings.newClusterEnabled()) {
                return JoinSelf$.MODULE$.asCompletedFuture();
            }
            if (this.settings.newClusterEnabled()) {
                if (this.log().isInfoEnabled()) {
                    this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is NOT the lowest address out of the discovered endpoints in this deployment, thus NOT joining self. Expecting node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse((Function0 & Serializable)() -> ""), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
                }
            } else if (this.log().isWarningEnabled()) {
                this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is configured with new-cluster-enabled=off, thus NOT joining self. Expecting existing cluster or node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse((Function0 & Serializable)() -> ""), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
            }
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        if (this.log().isInfoEnabled()) {
            this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins but missing seed node information from some contact points [{}] (out of [{}])", (Object)((IterableOnceOps)contactPointsWithoutSeedNodesObservations.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
        }
        return KeepProbing$.MODULE$.asCompletedFuture();
    }

    public Set<Address> joinOtherSeedNodes(SeedNodesInformation info) {
        return (Set)info.allSeedNodes().take(5);
    }

    public boolean hasEnoughContactPoints(SeedNodesInformation info) {
        return info.seedNodesObservations().size() >= this.settings.contactPointDiscovery().requiredContactPointsNr();
    }

    public boolean isPastStableMargin(SeedNodesInformation info) {
        return Duration.between(info.contactPointsChangedAt(), info.currentTime()).toMillis() >= this.settings.contactPointDiscovery().stableMargin().toMillis();
    }

    public boolean isConfirmedCommunicationWithAllContactPointsRequired(SeedNodesInformation info) {
        return this.settings.contactPointDiscovery().contactWithAllContactPoints();
    }

    public Option<ServiceDiscovery.ResolvedTarget> lowestAddressContactPoint(SeedNodesInformation info) {
        return ((LinearSeqOps)info.seedNodesObservations().toList().map((Function1 & Serializable)x$3 -> x$3.contactPoint()).sorted(ServiceDiscovery.ResolvedTarget$.MODULE$.addressOrdering())).headOption();
    }

    public LowestAddressJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.settings = settings;
        super(system, settings);
    }
}

