/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings$;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import org.apache.pekko.management.scaladsl.PekkoManagement;
import org.apache.pekko.management.scaladsl.PekkoManagement$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tmd\u0001B\u001b7\u0005\rC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ya\u0016\u0005\u00065\u0002!\ta\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019A\u0007\u0001)A\u0005E\"9\u0011\u000e\u0001b\u0001\n\u001bQ\u0007bBAh\u0001\u0001\u0006ia\u001b\u0005\n\u0003#\u0004!\u0019!C\u0001\u0003'D\u0001\"a7\u0001A\u0003%\u0011Q\u001b\u0005\u000b\u0003;\u0004\u0001R1A\u0005\u0002\u0005}\u0007\"CAv\u0001\t\u0007I\u0011BAw\u0011!\t)\u0010\u0001Q\u0001\n\u0005=\b\u0002CA|\u0001\u0001\u0006I!!?\t\u0013\tU\u0001A1A\u0005\n\t]\u0001\u0002\u0003B\r\u0001\u0001\u0006I!!)\t\u000f\tm\u0001\u0001\"\u0011\u0003\u001e!9!1\n\u0001\u0005\u0002\t5\u0003\u0002\u0003B+\u0001\u0011\u0005aG!\u0014\t\u0011\t\u0015\u0004\u0001\"\u0001=\u0005OB\u0001Ba\u001c\u0001\t\u0003a$\u0011O\u0004\u0006uZB\ta\u001f\u0004\u0006kYB\t\u0001 \u0005\u00075V!\t!a\u0002\t\u000f\u0005%Q\u0003\"\u0011\u0002\f!9\u0011QB\u000b\u0005B\u0005=\u0001bBA\u0007+\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003G)B\u0011IA\u0013\u000f!\tI#\u0006E\u0001m\u0005-b\u0001CA\u0018+!\u0005a'!\r\t\ricB\u0011AA\u001a\r%\t)\u0004\bI\u0001$C\t9dB\u0004\u0002LrA\t)!1\u0007\u000f\u0005mF\u0004#!\u0002>\"1!\f\tC\u0001\u0003\u007fC\u0011\"!\u001a!\u0003\u0003%\t%a\u001a\t\u0013\u0005U\u0004%!A\u0005\u0002\u0005]\u0004\"CA@A\u0005\u0005I\u0011AAb\u0011%\ti\tIA\u0001\n\u0003\ny\tC\u0005\u0002\u001e\u0002\n\t\u0011\"\u0001\u0002H\"I\u0011\u0011\u0016\u0011\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003[\u0003\u0013\u0011!C!\u0003_C\u0011\"!-!\u0003\u0003%I!a-\b\u000f\u00055G\u0004#!\u0002d\u00199\u00111\b\u000f\t\u0002\u0006u\u0002B\u0002.,\t\u0003\t\t\u0007C\u0005\u0002f-\n\t\u0011\"\u0011\u0002h!I\u0011QO\u0016\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u007fZ\u0013\u0011!C\u0001\u0003\u0003C\u0011\"!$,\u0003\u0003%\t%a$\t\u0013\u0005u5&!A\u0005\u0002\u0005}\u0005\"CAUW\u0005\u0005I\u0011IAV\u0011%\tikKA\u0001\n\u0003\ny\u000bC\u0005\u00022.\n\t\u0011\"\u0003\u00024\n\u00012\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\u0006\u0003oa\n\u0011BY8piN$(/\u00199\u000b\u0005eR\u0014aB2mkN$XM\u001d\u0006\u0003wq\n!\"\\1oC\u001e,W.\u001a8u\u0015\tid(A\u0003qK.\\wN\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011S\u0005\u000b\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001br\nQ!Y2u_JL!a\u0014'\u0003\u0013\u0015CH/\u001a8tS>t\u0007CA)U\u001b\u0005\u0011&BA*;\u0003!\u00198-\u00197bINd\u0017BA+S\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'/\u0001\u0004tsN$X-\u001c\t\u0003\u0017bK!!\u0017'\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\u0005aFCA/`!\tq\u0006!D\u00017\u0011\u00151&\u0001q\u0001X\u0003\rawnZ\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q\rP\u0001\u0006KZ,g\u000e^\u0005\u0003O\u0012\u0014a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!\u00042p_R\u001cHO]1q'R,\u0007/F\u0001l!\raWo^\u0007\u0002[*\u0011an\\\u0001\u0007CR|W.[2\u000b\u0005A\f\u0018AC2p]\u000e,(O]3oi*\u0011!o]\u0001\u0005kRLGNC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Yl'aD!u_6L7MU3gKJ,gnY3\u0011\u0005atbBA=\u001c\u001d\tqF#\u0001\tDYV\u001cH/\u001a:C_>$8\u000f\u001e:baB\u0011a,F\n\u0006+\u0011k\u0018\u0011\u0001\t\u0004\u0017zl\u0016BA@M\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0007-\u000b\u0019!C\u0002\u0002\u00061\u00131#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012a_\u0001\u0007Y>|7.\u001e9\u0016\u0003e\f1aZ3u)\ri\u0016\u0011\u0003\u0005\u0007-b\u0001\r!a\u0005\u0011\u0007-\u000b)\"C\u0002\u0002\u00181\u00131\"Q2u_J\u001c\u0016p\u001d;f[R\u0019Q,a\u0007\t\rYK\u0002\u0019AA\u000f!\rY\u0015qD\u0005\u0004\u0003Ca%AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007u\u000b9\u0003C\u0003W5\u0001\u0007q+\u0001\u0005J]R,'O\\1m!\r\ti\u0003H\u0007\u0002+\tA\u0011J\u001c;fe:\fGn\u0005\u0002\u001d\tR\u0011\u00111\u0006\u0002\u000e\u0005>|Go\u001d;sCB\u001cF/\u001a9\u0014\u0005y!\u0015f\u0001\u0010,A\ta\u0011J\\5uS\u0006d\u0017N_5oONA1\u0006RA \u0003\u0007\nI\u0005E\u0002\u0002Byi\u0011\u0001\b\t\u0004\u000b\u0006\u0015\u0013bAA$\r\n9\u0001K]8ek\u000e$\b\u0003BA&\u00037rA!!\u0014\u0002X9!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\t\u000ba\u0001\u0010:p_Rt\u0014\"A$\n\u0007\u0005ec)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u000332ECAA2!\r\t\teK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=4/\u0001\u0003mC:<\u0017\u0002BA:\u0003[\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA=!\r)\u00151P\u0005\u0004\u0003{2%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAB\u0003\u0013\u00032!RAC\u0013\r\t9I\u0012\u0002\u0004\u0003:L\b\"CAF_\u0005\u0005\t\u0019AA=\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0013\t\u0007\u0003'\u000bI*a!\u000e\u0005\u0005U%bAAL\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\"\u0006\u001d\u0006cA#\u0002$&\u0019\u0011Q\u0015$\u0003\u000f\t{w\u000e\\3b]\"I\u00111R\u0019\u0002\u0002\u0003\u0007\u00111Q\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011P\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003k\u0003B!a\u001b\u00028&!\u0011\u0011XA7\u0005\u0019y%M[3di\nQaj\u001c;Sk:t\u0017N\\4\u0014\u0011\u0001\"\u0015qHA\"\u0003\u0013\"\"!!1\u0011\u0007\u0005\u0005\u0003\u0005\u0006\u0003\u0002\u0004\u0006\u0015\u0007\"CAFI\u0005\u0005\t\u0019AA=)\u0011\t\t+!3\t\u0013\u0005-e%!AA\u0002\u0005\r\u0015A\u0003(piJ+hN\\5oO\u0006a\u0011J\\5uS\u0006d\u0017N_5oO\u0006q!m\\8ugR\u0014\u0018\r]*uKB\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\u0005U\u0007c\u00010\u0002X&\u0019\u0011\u0011\u001c\u001c\u00031\rcWo\u001d;fe\n{w\u000e^:ue\u0006\u00048+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005IA-[:d_Z,'/_\u000b\u0003\u0003C\u0004B!a9\u0002h6\u0011\u0011Q\u001d\u0006\u0004\u0003;d\u0014\u0002BAu\u0003K\u0014\u0001cU3sm&\u001cW\rR5tG>4XM]=\u0002\u0017)|\u0017N\u001c#fG&$WM]\u000b\u0003\u0003_\u00042AXAy\u0013\r\t\u0019P\u000e\u0002\f\u0015>Lg\u000eR3dS\u0012,'/\u0001\u0007k_&tG)Z2jI\u0016\u0014\b%\u0001\u000b`g\u0016dgmQ8oi\u0006\u001cG\u000fU8j]R,&/\u001b\t\u0007\u0003w\fyPa\u0001\u000e\u0005\u0005u(B\u00019G\u0013\u0011\u0011\t!!@\u0003\u000fA\u0013x.\\5tKB!!Q\u0001B\t\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011!B7pI\u0016d'bA*\u0003\u000e)\u0019!q\u0002\u001f\u0002\t!$H\u000f]\u0005\u0005\u0005'\u00119AA\u0002Ve&\f\u0011\"Y;u_N$\u0018M\u001d;\u0016\u0005\u0005\u0005\u0016AC1vi>\u001cH/\u0019:uA\u00051!o\\;uKN$BAa\b\u0003BA!!\u0011\u0005B\u001e\u001d\u0011\u0011\u0019Ca\u000e\u000f\t\t\u0015\"1\u0007\b\u0005\u0005O\u0011\tD\u0004\u0003\u0003*\t=b\u0002\u0002B\u0016\u0005[i\u0011AP\u0005\u0003{yJ1Aa\u0004=\u0013\r\u0019&QB\u0005\u0005\u0005k\u0011Y!\u0001\u0004tKJ4XM]\u0005\u0005\u00033\u0012ID\u0003\u0003\u00036\t-\u0011\u0002\u0002B\u001f\u0005\u007f\u0011QAU8vi\u0016TA!!\u0017\u0003:!9!1I\bA\u0002\t\u0015\u0013!\u0006:pkR,\u0007K]8wS\u0012,'oU3ui&twm\u001d\t\u0004#\n\u001d\u0013b\u0001B%%\nyR*\u00198bO\u0016lWM\u001c;S_V$X\r\u0015:pm&$WM]*fiRLgnZ:\u0002\u000bM$\u0018M\u001d;\u0015\u0005\t=\u0003cA#\u0003R%\u0019!1\u000b$\u0003\tUs\u0017\u000e^\u0001\u0017K:\u001cXO]3TK247i\u001c8uC\u000e$\bk\\5oi\"\u001a\u0011C!\u0017\u0011\t\tm#\u0011M\u0007\u0003\u0005;R1Aa\u0018=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0012iFA\u0006J]R,'O\\1m\u0003BL\u0017aE:fiN+GNZ\"p]R\f7\r\u001e)pS:$H\u0003\u0002B(\u0005SBqAa\u001b\u0013\u0001\u0004\u0011\u0019!A\u0004cCN,WK]5)\u0007I\u0011I&\u0001\ttK247i\u001c8uC\u000e$\bk\\5oiV\u0011!1\u000f\t\u0007\u0003w\u0014)Ha\u0001\n\t\t]\u0014Q \u0002\u0007\rV$XO]3)\u0007M\u0011I\u0006")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private final boolean autostart;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem system) {
        return ClusterBootstrap$.MODULE$.createExtension(system);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider system) {
        return ClusterBootstrap$.MODULE$.get(system);
    }

    public static ClusterBootstrap get(ActorSystem system) {
        return ClusterBootstrap$.MODULE$.get(system);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ClusterBootstrap$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return ClusterBootstrap$.MODULE$.apply(system);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        block6: {
            ClusterBootstrap clusterBootstrap = this;
            synchronized (clusterBootstrap) {
                ServiceDiscovery serviceDiscovery;
                block7: {
                    if (this.bitmap$0) break block6;
                    String string = this.settings().contactPointDiscovery().discoveryMethod();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1046136388: {
                            if (!"pekko.discovery".equals(string)) break;
                            ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                            this.log().info("Bootstrap using default `pekko.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                            serviceDiscovery = discovery;
                            break block7;
                        }
                    }
                    this.log().info("Bootstrap using `pekko.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        if (!this.bitmap$0) {
            return this.discovery$lzycompute();
        }
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    private boolean autostart() {
        return this.autostart;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `pekko.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
            return;
        }
        if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
            return;
        }
        this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (!this.selfContactPoint().isCompleted()) {
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via pekko-management.");
                return;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    private final void autostartFailed$1(Throwable ex) {
        this.log().error(ex, "Failed to autostart cluster bootstrap, terminating system");
        this.system.terminate();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = bootstrap$1.$bang$default$2((Object)x$1);
        bootstrap$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        BoxedUnit boxedUnit;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
        this.autostart = system.settings().config().getStringList("pekko.extensions").contains(ClusterBootstrap.class.getName());
        if (this.autostart()) {
            this.log().info("ClusterBootstrap loaded through 'pekko.extensions' auto starting management and bootstrap.");
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    ((PekkoManagement)PekkoManagement$.MODULE$.apply((ActorSystem)$this.system)).start().failed().foreach((Function1 & Serializable)ex -> {
                        this.autostartFailed$1(ex);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    ((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply((ActorSystem)$this.system)).start();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex2 = (Throwable)option.get();
                        this.autostartFailed$1(ex2);
                    }
                    throw throwable;
                }
            }, (ExecutionContext)system.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

