/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.CodingDirectives;
import org.apache.pekko.http.scaladsl.server.directives.CodingDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.ContentTypeResolver;
import org.apache.pekko.http.scaladsl.server.directives.FileAndResourceDirectives;
import org.apache.pekko.http.scaladsl.server.directives.RangeDirectives;
import org.apache.pekko.http.scaladsl.server.directives.RangeDirectives$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class FileAndResourceDirectives$
implements FileAndResourceDirectives {
    public static final FileAndResourceDirectives$ MODULE$ = new FileAndResourceDirectives$();
    private static final Directive<BoxedUnit> org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;

    static {
        TupleOps.Join fromDirective_join = new TupleOps.Join<BoxedUnit, T>(){

            public T apply(BoxedUnit prefix, T suffix) {
                return suffix;
            }
        };
        Directive fromDirective_other = CodingDirectives.withPrecompressedMediaTypeSupport$(CodingDirectives$.MODULE$);
        Object var0_1 = null;
        Object var1 = null;
        org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport = (Directive)RangeDirectives.withRangeSupport$(RangeDirectives$.MODULE$).$amp(new ConjunctionMagnet<L>(fromDirective_other, fromDirective_join){
            private final Directive other$1;
            private final TupleOps.Join join$1;

            public Directive<Object> apply(Directive<L> underlying) {
                Function1 & Serializable apply_f = (Function1 & Serializable)inner -> underlying.tapply((Function1 & Serializable)prefix -> $this.other$1.tapply((Function1 & Serializable)suffix -> (Function1)inner.apply($this.join$1.apply(prefix, suffix))));
                return new Directive<T>(null, (Function1)apply_f){
                    private final Function1 f$4;

                    public Function1<RequestContext, Future<RouteResult>> tapply(Function1<T, Function1<RequestContext, Future<RouteResult>>> inner) {
                        return (Function1)this.f$4.apply(inner);
                    }
                    {
                        this.f$4 = f$4;
                        super(evidence$4$1);
                    }
                };
            }
            {
                this.other$1 = other$1;
                this.join$1 = join$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$$anon$2 org.apache.pekko.http.scaladsl.server.Directive scala.Function1 ), $anonfun$apply$2(org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$$anon$2 scala.Function1 java.lang.Object ), $anonfun$apply$3(org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$$anon$2 scala.Function1 java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, fileName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, contentType);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, contentType, classLoader);
    }

    @Override
    public ClassLoader getFromResource$default$3() {
        return FileAndResourceDirectives.getFromResource$default$3$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromDirectory$(this, directoryName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return FileAndResourceDirectives.listDirectoryContents$(this, directories, renderer);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectory$(this, directory, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectories$(this, directories, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResourceDirectory$(this, directoryName, classLoader, resolver);
    }

    @Override
    public ClassLoader getFromResourceDirectory$default$2() {
        return FileAndResourceDirectives.getFromResourceDirectory$default$2$(this);
    }

    @Override
    public ClassLoader _defaultClassLoader() {
        return FileAndResourceDirectives._defaultClassLoader$(this);
    }

    public Directive<BoxedUnit> org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport() {
        return org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return new StringBuilder(11).append(path).append('/').toString();
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(String basePath, Uri.Path path, LoggingAdapter log, char separator) {
        String string = this.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(basePath, path, log, separator);
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return "";
            }
        }
        return this.checkIsSafeDescendant(basePath, string, log);
    }

    public char org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4() {
        return File.separatorChar;
    }

    public String org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(String base, Uri.Path path, LoggingAdapter log, char separator) {
        return this.rec$1(path.startsWithSlash() ? path.tail() : path, new StringBuilder(base), separator, log, base, path);
    }

    private String checkIsSafeDescendant(String basePath, String finalPath, LoggingAdapter log) {
        File baseFile = new File(basePath);
        File finalFile = new File(finalPath);
        String canonicalFinalPath = finalFile.getCanonicalPath();
        if (!canonicalFinalPath.startsWith(baseFile.getCanonicalPath())) {
            log.warning(new StringBuilder(92).append("[").append(finalFile).append("] points to a location that is not part of [").append(baseFile).append("]. This might be a directory ").append("traversal attempt.").toString());
            return "";
        }
        return canonicalFinalPath;
    }

    private final String rec$1(Uri.Path p, StringBuilder result, char separator$1, LoggingAdapter log$1, String base$2, Uri.Path path$2) {
        while (true) {
            if (Uri.Path$.Empty$.MODULE$.equals(p)) {
                return result.toString();
            }
            if (p instanceof Uri.Path$.Slash) {
                result = result.append(separator$1);
                p = ((Uri.Path$.Slash)p).tail();
                continue;
            }
            if (!(p instanceof Uri.Path$.Segment)) break;
            Uri.Path$.Segment segment = (Uri.Path$.Segment)p;
            String head = segment.head();
            Uri.Path.SlashOrEmpty tail = segment.tail();
            if (head.indexOf(47) >= 0 || head.indexOf(92) >= 0 || head.equals("..")) {
                log$1.warning("File-system path for base [{}] and Uri.Path [{}] contains suspicious path segment [{}], GET access was disallowed", (Object)base$2, (Object)path$2, (Object)head);
                return "";
            }
            result = result.append(head);
            p = tail;
        }
        throw new MatchError((Object)p);
    }

    private static final StringBuilder rec$default$2$1(String base$2) {
        return new StringBuilder(base$2);
    }

    private FileAndResourceDirectives$() {
    }
}

