/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SetOps;
import scala.collection.SortedSetOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a!\u0002\b\u0010\u0001E9\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011\r\u0002!\u0011!Q\u0001\n\u0001BQ\u0001\n\u0001\u0005\u0002\u0015BQA\u000b\u0001\u0005\u0006-BQa\u000e\u0001\u0005\u0006aBQA\u0012\u0001\u0005\u0002\u001dCQA\u0014\u0001\u0005\u0012=CQ!\u0015\u0001\u0005\u0012ICQ\u0001\u0016\u0001\u0005\u0012UCQ\u0001\u0017\u0001\u0005\u0012eCQA\u0018\u0001\u0005\u0012}CQ!\u0019\u0001\u0005\u0012\tDQ\u0001\u001e\u0001\u0005\u0012U\u0014AcR8tg&\u0004H+\u0019:hKR\u001cV\r\\3di>\u0014(B\u0001\t\u0012\u0003\u001d\u0019G.^:uKJT!AE\n\u0002\u000bA,7n[8\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017\u0001\n:fIV\u001cWmR8tg&\u0004H)\u001b4gKJ,g\u000e\u001e,jK^\u0004&o\u001c2bE&d\u0017\u000e^=\u0004\u0001A\u0011\u0011$I\u0005\u0003Ei\u0011a\u0001R8vE2,\u0017\u0001G2s_N\u001cHiY$pgNL\u0007\u000f\u0015:pE\u0006\u0014\u0017\u000e\\5us\u00061A(\u001b8jiz\"2A\n\u0015*!\t9\u0003!D\u0001\u0010\u0011\u0015q2\u00011\u0001!\u0011\u0015\u00193\u00011\u0001!\u000319wn]:jaR\u000b'oZ3u)\ta#\u0007E\u0002\u001a[=J!A\f\u000e\u0003\r=\u0003H/[8o!\t9\u0003'\u0003\u00022\u001f\tiQK\\5rk\u0016\fE\r\u001a:fgNDQa\r\u0003A\u0002Q\nQa\u001d;bi\u0016\u0004\"aJ\u001b\n\u0005Yz!aD'f[\n,'o\u001d5jaN#\u0018\r^3\u0002\u001b\u001d|7o]5q)\u0006\u0014x-\u001a;t)\tIT\tE\u0002;\u0005>r!a\u000f!\u000f\u0005qzT\"A\u001f\u000b\u0005yz\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t\t%$A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%A\u0002,fGR|'O\u0003\u0002B5!)1'\u0002a\u0001i\u0005A\"/\u00198e_6tu\u000eZ3t\r>\u0014h)\u001e7m\u000f>\u001c8/\u001b9\u0015\u0007eB\u0015\nC\u00034\r\u0001\u0007A\u0007C\u0003K\r\u0001\u00071*A\u0001o!\tIB*\u0003\u0002N5\t\u0019\u0011J\u001c;\u0002)1|7-\u00197EG\u001e{7o]5q)\u0006\u0014x-\u001a;t)\tI\u0004\u000bC\u00034\u000f\u0001\u0007A'\u0001\u000bnk2$\u0018\u000eR2H_N\u001c\u0018\u000e\u001d+be\u001e,Go\u001d\u000b\u0003sMCQa\r\u0005A\u0002Q\na%\u00193kkN$X\rZ$pgNL\u0007\u000fR5gM\u0016\u0014XM\u001c;WS\u0016<\bK]8cC\nLG.\u001b;z)\t\u0001c\u000bC\u0003X\u0013\u0001\u00071*A\u0006dYV\u001cH/\u001a:TSj,\u0017AE:fY\u0016\u001cG\u000fR2M_\u000e\fGNT8eKN$\"AW/\u0011\u0005eY\u0016B\u0001/\u001b\u0005\u001d\u0011un\u001c7fC:DQa\r\u0006A\u0002Q\nA\u0004\u001d:fM\u0016\u0014hj\u001c3fg^KG\u000f\u001b#jM\u001a,'/\u001a8u-&,w\u000f\u0006\u0002[A\")1g\u0003a\u0001i\u0005\u0001BmY:J]J\u000bg\u000eZ8n\u001fJ$WM\u001d\u000b\u0003GJ\u00042A\u000f3g\u0013\t)GI\u0001\u0003MSN$\bCA4p\u001d\tAWN\u0004\u0002jY:\u0011!n[\u0007\u0002'%\u0011!cE\u0005\u0003!EI!A\\\b\u0002\u001f\rcWo\u001d;feN+G\u000f^5oONL!\u0001]9\u0003\u0015\u0011\u000bG/Y\"f]R,'O\u0003\u0002o\u001f!)1\u000f\u0004a\u0001G\u0006\u0019AmY:\u0002!M,G.Z2u%\u0006tGm\\7O_\u0012,GC\u0001\u0017w\u0011\u00159X\u00021\u0001y\u0003\u0015qw\u000eZ3t!\rQ\u0014pL\u0005\u0003u\u0012\u0013!\"\u00138eKb,GmU3rQ\t\u0001A\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fF\t!\"\u00198o_R\fG/[8o\u0013\r\t\u0019A \u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class GossipTargetSelector {
    private final double reduceGossipDifferentViewProbability;
    private final double crossDcGossipProbability;

    public final Option<UniqueAddress> gossipTarget(MembershipState state) {
        return this.selectRandomNode((IndexedSeq<UniqueAddress>)this.gossipTargets(state));
    }

    public final Vector<UniqueAddress> gossipTargets(MembershipState state) {
        if (state.latestGossip().isMultiDc()) {
            return this.multiDcGossipTargets(state);
        }
        return this.localDcGossipTargets(state);
    }

    public Vector<UniqueAddress> randomNodesForFullGossip(MembershipState state, int n) {
        if (state.latestGossip().isMultiDc() && ((SetOps)state.ageSortedTopOldestMembersPerDc().apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            Vector randomLocalNodes = (Vector)Random$.MODULE$.shuffle((IterableOnce)state.members().toVector().collect((PartialFunction)new Serializable(null, state){
                private static final long serialVersionUID = 0L;
                private final MembershipState state$1;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    String string = x1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(x1.uniqueAddress())) {
                        return (B1)x1.uniqueAddress();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Member x1) {
                    String string = x1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    return !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(x1.uniqueAddress());
                }
                {
                    this.state$1 = state$1;
                }
            }), BuildFrom$.MODULE$.buildFromIterableOps());
            List otherDcs = (List)Random$.MODULE$.shuffle((IterableOnce)state.ageSortedTopOldestMembersPerDc().keySet().$minus((Object)state.selfDc()).toList(), BuildFrom$.MODULE$.buildFromIterableOps());
            Option option = this.selectOtherDcNode$1(otherDcs, state);
            if (option instanceof Some) {
                UniqueAddress node = (UniqueAddress)((Some)option).value();
                return (Vector)randomLocalNodes.take(n - 1).$colon$plus((Object)node);
            }
            if (None$.MODULE$.equals(option)) {
                return randomLocalNodes.take(n);
            }
            throw new MatchError((Object)option);
        }
        Vector selectedNodes = (Vector)state.members().toVector().collect((PartialFunction)new Serializable(null, state){
            private static final long serialVersionUID = 0L;
            private final MembershipState state$1;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                String string = x2.dataCenter();
                String string2 = this.state$1.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(x2.uniqueAddress())) {
                    return (B1)x2.uniqueAddress();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Member x2) {
                String string = x2.dataCenter();
                String string2 = this.state$1.selfDc();
                return !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(x2.uniqueAddress());
            }
            {
                this.state$1 = state$1;
            }
        });
        if (selectedNodes.size() <= n) {
            return selectedNodes;
        }
        return ((Vector)Random$.MODULE$.shuffle((IterableOnce)selectedNodes, BuildFrom$.MODULE$.buildFromIterableOps())).take(n);
    }

    public Vector<UniqueAddress> localDcGossipTargets(MembershipState state) {
        Vector firstSelection;
        Gossip latestGossip = state.latestGossip();
        Vector vector = firstSelection = this.preferNodesWithDifferentView(state) ? (Vector)latestGossip.members().iterator().collect((PartialFunction)new Serializable(null, state, latestGossip){
            private static final long serialVersionUID = 0L;
            private final MembershipState state$2;
            private final Gossip latestGossip$1;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string = x1.dataCenter();
                String string2 = this.state$2.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(x1.uniqueAddress()) && this.state$2.validNodeForGossip(x1.uniqueAddress())) {
                        return (B1)x1.uniqueAddress();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Member x1) {
                String string = x1.dataCenter();
                String string2 = this.state$2.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(x1.uniqueAddress()) && this.state$2.validNodeForGossip(x1.uniqueAddress())) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.state$2 = state$2;
                this.latestGossip$1 = latestGossip$1;
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)scala.package$.MODULE$.Vector())) : scala.package$.MODULE$.Vector().empty();
        if (firstSelection.isEmpty()) {
            return (Vector)latestGossip.members().toVector().collect((PartialFunction)new Serializable(null, state){
                private static final long serialVersionUID = 0L;
                private final MembershipState state$2;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    String string = x2.dataCenter();
                    String string2 = this.state$2.selfDc();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$2.validNodeForGossip(x2.uniqueAddress())) {
                        return (B1)x2.uniqueAddress();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Member x2) {
                    String string = x2.dataCenter();
                    String string2 = this.state$2.selfDc();
                    return !(string != null ? !string.equals(string2) : string2 != null) && this.state$2.validNodeForGossip(x2.uniqueAddress());
                }
                {
                    this.state$2 = state$2;
                }
            });
        }
        return firstSelection;
    }

    public Vector<UniqueAddress> multiDcGossipTargets(MembershipState state) {
        if (this.selectDcLocalNodes(state)) {
            return this.localDcGossipTargets(state);
        }
        Map<String, SortedSet<Member>> nodesPerDc = state.ageSortedTopOldestMembersPerDc();
        if (!((SetOps)nodesPerDc.apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            return this.localDcGossipTargets(state);
        }
        List<String> otherDcsInRandomOrder = this.dcsInRandomOrder((List<String>)nodesPerDc.$minus((Object)state.selfDc()).keys().toList());
        Vector nodes2 = this.findFirstDcWithValidNodes$1(otherDcsInRandomOrder, nodesPerDc, state);
        if (nodes2.nonEmpty()) {
            return nodes2;
        }
        return this.localDcGossipTargets(state);
    }

    public double adjustedGossipDifferentViewProbability(int clusterSize) {
        double low = this.reduceGossipDifferentViewProbability;
        double high = low * (double)3;
        if ((double)clusterSize <= low) {
            return this.reduceGossipDifferentViewProbability;
        }
        double minP = this.reduceGossipDifferentViewProbability / (double)10;
        if ((double)clusterSize >= high) {
            return minP;
        }
        double k = (minP - this.reduceGossipDifferentViewProbability) / (high - low);
        return this.reduceGossipDifferentViewProbability + ((double)clusterSize - low) * k;
    }

    public boolean selectDcLocalNodes(MembershipState state) {
        double probability;
        int localMembers = state.dcMembers().size();
        double d = probability = localMembers > 4 ? this.crossDcGossipProbability : package$.MODULE$.max((double)(5 - localMembers) * 0.25, this.crossDcGossipProbability);
        return ThreadLocalRandom.current().nextDouble() > probability;
    }

    public boolean preferNodesWithDifferentView(MembershipState state) {
        return ThreadLocalRandom.current().nextDouble() < this.adjustedGossipDifferentViewProbability(state.latestGossip().members().size());
    }

    public List<String> dcsInRandomOrder(List<String> dcs) {
        return (List)Random$.MODULE$.shuffle(dcs, BuildFrom$.MODULE$.buildFromIterableOps());
    }

    public Option<UniqueAddress> selectRandomNode(IndexedSeq<UniqueAddress> nodes2) {
        if (nodes2.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(nodes2.apply(ThreadLocalRandom.current().nextInt(nodes2.size())));
    }

    private final Option selectOtherDcNode$1(List randomizedDcs, MembershipState state$1) {
        block3: {
            Option option;
            while (true) {
                if (Nil$.MODULE$.equals(randomizedDcs)) {
                    return None$.MODULE$;
                }
                if (!(randomizedDcs instanceof .colon.colon)) break block3;
                .colon.colon colon2 = (.colon.colon)randomizedDcs;
                String dc = (String)colon2.head();
                List tail = colon2.next$access$1();
                option = ((IterableOnceOps)state$1.ageSortedTopOldestMembersPerDc().apply((Object)dc)).collectFirst((PartialFunction)new Serializable(null, state$1){
                    private static final long serialVersionUID = 0L;
                    private final MembershipState state$1;

                    public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        if (this.state$1.validNodeForGossip(x1.uniqueAddress())) {
                            return (B1)x1.uniqueAddress();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Member x1) {
                        return this.state$1.validNodeForGossip(x1.uniqueAddress());
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
                if (option instanceof Some) {
                    UniqueAddress addr = (UniqueAddress)((Some)option).value();
                    return new Some((Object)addr);
                }
                if (!None$.MODULE$.equals(option)) break;
                randomizedDcs = tail;
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)randomizedDcs);
    }

    private final Vector findFirstDcWithValidNodes$1(List left, Map nodesPerDc$1, MembershipState state$3) {
        while (left instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)left;
            String dc = (String)colon2.head();
            List tail = colon2.next$access$1();
            SortedSet validNodes = (SortedSet)((SortedSetOps)nodesPerDc$1.apply((Object)dc)).collect((PartialFunction)new Serializable(null, state$3){
                private static final long serialVersionUID = 0L;
                private final MembershipState state$3;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (this.state$3.validNodeForGossip(x1.uniqueAddress())) {
                        return (B1)x1.uniqueAddress();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Member x1) {
                    return this.state$3.validNodeForGossip(x1.uniqueAddress());
                }
                {
                    this.state$3 = state$3;
                }
            }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            if (validNodes.nonEmpty()) {
                return validNodes.toVector();
            }
            left = tail;
        }
        if (Nil$.MODULE$.equals(left)) {
            return scala.package$.MODULE$.Vector().empty();
        }
        throw new MatchError((Object)left);
    }

    public GossipTargetSelector(double reduceGossipDifferentViewProbability, double crossDcGossipProbability) {
        this.reduceGossipDifferentViewProbability = reduceGossipDifferentViewProbability;
        this.crossDcGossipProbability = crossDcGossipProbability;
    }
}

